/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class TabFolder
extends Composite {
    TabItem[] items;
    int lastSelected = -1;

    public TabFolder(Composite composite, int n) {
        super(composite, TabFolder.checkStyle(n));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        n = TabFolder.checkBits(n, 128, 1024, 0, 0, 0, 0);
        return n & 0xFFFFFCFF;
    }

    int callPaintEventHandler(int n, int n2, int n3, int n4, int n5) {
        int[] nArray = new int[1];
        OS.GetEventParameter(n4, 1668183160, 1668183160, null, 4, null, nArray);
        OS.CGContextSaveGState(nArray[0]);
        CGRect cGRect = new CGRect();
        OS.HIViewGetBounds(this.handle, cGRect);
        OS.CGContextAddRect(nArray[0], cGRect);
        OS.CGContextClip(nArray[0]);
        int n6 = super.callPaintEventHandler(n, n2, n3, n4, n5);
        OS.CGContextRestoreGState(nArray[0]);
        return n6;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        Point point = super.computeSize(n, n2, bl);
        if (n == -1 && this.items.length > 0) {
            int n3 = 0;
            GC gC = new GC(this);
            int n4 = 0;
            while (n4 < this.items.length) {
                if (this.items[n4] != null) {
                    n3 += this.items[n4].calculateWidth(gC);
                }
                ++n4;
            }
            gC.dispose();
            Rectangle rectangle = this.computeTrim(0, 0, n3, 0);
            point.x = Math.max(rectangle.width, point.x);
        }
        return point;
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        CGRect cGRect;
        this.checkWidget();
        CGRect cGRect2 = cGRect = new CGRect();
        OS.HIViewGetFrame(this.handle, cGRect);
        int n5 = 100;
        if (cGRect.width < (float)n5 || cGRect.height < (float)n5) {
            OS.HIViewSetDrawingEnabled(this.handle, false);
            cGRect2 = new CGRect();
            cGRect2.height = 100.0f;
            cGRect2.width = 100.0f;
            OS.HIViewSetFrame(this.handle, cGRect2);
        }
        Rect rect = new Rect();
        OS.GetTabContentRect(this.handle, rect);
        if (cGRect.width < (float)n5 || cGRect.height < (float)n5) {
            OS.HIViewSetFrame(this.handle, cGRect);
            OS.HIViewSetDrawingEnabled(this.handle, this.drawCount == 0);
        }
        n -= rect.left;
        n2 -= rect.top;
        n3 += (int)cGRect2.width - (rect.right - rect.left);
        n4 += (int)cGRect2.height - (rect.bottom - rect.top);
        Rect rect2 = this.getInset();
        n -= rect2.left;
        n2 -= rect2.top;
        return new Rectangle(-rect.left, -rect.top, n3 += rect2.left + rect2.right, n4 += rect2.top + rect2.bottom);
    }

    void createHandle() {
        int[] nArray = new int[1];
        int n = OS.GetControlOwner(this.parent.handle);
        short s = (this.style & 0x400) != 0 ? (short)1 : 0;
        OS.CreateTabsControl(n, new Rect(), (short)0, s, (short)0, 0, nArray);
        if (nArray[0] == 0) {
            this.error(2);
        }
        this.handle = nArray[0];
    }

    void createItem(TabItem tabItem, int n) {
        Object object;
        int n2 = OS.GetControl32BitMaximum(this.handle);
        if (n < 0 || n > n2) {
            this.error(6);
        }
        OS.SetControl32BitMaximum(this.handle, n2 + 1);
        if (n2 == this.items.length) {
            object = new TabItem[this.items.length + 4];
            System.arraycopy(this.items, 0, object, 0, this.items.length);
            this.items = object;
        }
        System.arraycopy(this.items, n, this.items, n + 1, n2 - n);
        this.items[n] = tabItem;
        if (n2 == 0) {
            OS.SetControl32BitValue(this.handle, 1);
            this.lastSelected = 0;
            object = new Event();
            object.item = this.items[0];
            this.sendEvent(13, (Event)object);
        }
    }

    void createWidget() {
        super.createWidget();
        this.items = new TabItem[4];
    }

    void destroyItem(TabItem tabItem) {
        int n = OS.GetControl32BitMaximum(this.handle);
        int n2 = 0;
        while (n2 < n) {
            if (this.items[n2] == tabItem) break;
            ++n2;
        }
        if (n2 == n) {
            return;
        }
        this.redrawWidget(this.handle, false);
        int n3 = OS.GetControl32BitValue(this.handle) - 1;
        OS.SetControl32BitMaximum(this.handle, --n);
        System.arraycopy(this.items, n2 + 1, this.items, n2, n - n2);
        this.items[n] = null;
        if (n == 0) {
            this.items = new TabItem[4];
        }
        int n4 = n2;
        while (n4 < n) {
            this.items[n4].update();
            ++n4;
        }
        if (n > 0 && n2 == n3) {
            this.setSelection(Math.max(0, n3 - 1), true, true);
        }
        this.invalidateVisibleRegion(this.handle);
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        Rect rect = new Rect();
        if (OS.GetControlData(this.handle, (short)0, 1919247220, 8, rect, null) != 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n = Math.max(0, rect.left);
        int n2 = Math.max(0, rect.top);
        int n3 = Math.max(0, rect.right - rect.left);
        int n4 = Math.max(0, rect.bottom - rect.top);
        return new Rectangle(n, n2, n3, n4);
    }

    public TabItem getItem(int n) {
        this.checkWidget();
        int n2 = OS.GetControl32BitMaximum(this.handle);
        if (n < 0 || n >= n2) {
            this.error(6);
        }
        return this.items[n];
    }

    public TabItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int n = OS.GetControl32BitMaximum(this.handle);
        int n2 = 0;
        while (n2 < n) {
            TabItem tabItem = this.items[n2];
            Rectangle rectangle = tabItem.getBounds();
            if (rectangle.contains(point)) {
                return tabItem;
            }
            ++n2;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.GetControl32BitMaximum(this.handle);
    }

    public TabItem[] getItems() {
        this.checkWidget();
        int n = OS.GetControl32BitMaximum(this.handle);
        TabItem[] tabItemArray = new TabItem[n];
        System.arraycopy(this.items, 0, tabItemArray, 0, n);
        return tabItemArray;
    }

    public TabItem[] getSelection() {
        this.checkWidget();
        int n = OS.GetControl32BitValue(this.handle) - 1;
        if (n == -1) {
            return new TabItem[0];
        }
        return new TabItem[]{this.items[n]};
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return OS.GetControl32BitValue(this.handle) - 1;
    }

    float getThemeAlpha() {
        return 0.25f * this.parent.getThemeAlpha();
    }

    public int indexOf(TabItem tabItem) {
        this.checkWidget();
        if (tabItem == null) {
            this.error(4);
        }
        int n = OS.GetControl32BitMaximum(this.handle);
        int n2 = 0;
        while (n2 < n) {
            if (this.items[n2] == tabItem) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    Point minimumSize(int n, int n2, boolean bl) {
        Control[] controlArray = this._getChildren();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < controlArray.length) {
            SerializableCompatibility serializableCompatibility;
            Control control2 = controlArray[n5];
            int n6 = 0;
            int n7 = OS.GetControl32BitMaximum(this.handle);
            while (n6 < n7) {
                if (this.items[n6].control == control2) break;
                ++n6;
            }
            if (n6 == n7) {
                serializableCompatibility = control2.getBounds();
                n3 = Math.max(n3, serializableCompatibility.x + serializableCompatibility.width);
                n4 = Math.max(n4, serializableCompatibility.y + serializableCompatibility.height);
            } else {
                serializableCompatibility = control2.computeSize(n, n2, bl);
                n3 = Math.max(n3, ((Point)serializableCompatibility).x);
                n4 = Math.max(n4, ((Point)serializableCompatibility).y);
            }
            ++n5;
        }
        return new Point(n3, n4);
    }

    Rect getInset() {
        if (OS.VERSION >= 4128) {
            return super.getInset();
        }
        return (this.style & 0x400) != 0 ? this.display.tabFolderSouthInset : this.display.tabFolderNorthInset;
    }

    int kEventControlApplyBackground(int n, int n2, int n3) {
        return 0;
    }

    int kEventControlHit(int n, int n2, int n3) {
        Object object;
        int n4 = super.kEventControlHit(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        int n5 = OS.GetControl32BitValue(this.handle) - 1;
        if (n5 == this.lastSelected) {
            return n4;
        }
        this.lastSelected = n5;
        int n6 = OS.GetControl32BitMaximum(this.handle);
        int n7 = 0;
        while (n7 < n6) {
            if (n7 != n5 && (object = this.items[n7].control) != null && !((Widget)object).isDisposed()) {
                ((Control)object).setVisible(false);
            }
            ++n7;
        }
        TabItem tabItem = null;
        if (n5 != -1) {
            tabItem = this.items[n5];
        }
        if (tabItem != null && (object = tabItem.control) != null && !((Widget)object).isDisposed()) {
            ((Control)object).setBounds(this.getClientArea());
            ((Control)object).setVisible(true);
        }
        object = new Event();
        ((Event)object).item = tabItem;
        this.postEvent(13, (Event)object);
        return 0;
    }

    int kEventControlSetFocusPart(int n, int n2, int n3) {
        short[] sArray = new short[1];
        OS.GetEventParameter(n2, 1668313716, 1668313716, null, 2, null, sArray);
        if (sArray[0] == 0 || sArray[0] == -1) {
            return super.kEventControlSetFocusPart(n, n2, n3);
        }
        return -9874;
    }

    void releaseChildren(boolean bl) {
        if (this.items != null) {
            int n = 0;
            while (n < this.items.length) {
                TabItem tabItem = this.items[n];
                if (tabItem != null && !tabItem.isDisposed()) {
                    tabItem.release(false);
                }
                ++n;
            }
            this.items = null;
        }
        super.releaseChildren(bl);
    }

    void removeControl(Control control2) {
        super.removeControl(control2);
        int n = OS.GetControl32BitMaximum(this.handle);
        int n2 = 0;
        while (n2 < n) {
            TabItem tabItem = this.items[n2];
            if (tabItem.control == control2) {
                tabItem.setControl(null);
            }
            ++n2;
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        int n5;
        int n6 = super.setBounds(n, n2, n3, n4, bl, bl2, bl3);
        if ((n6 & 0x80) != 0 && (n5 = OS.GetControl32BitValue(this.handle) - 1) != -1) {
            TabItem tabItem = this.items[n5];
            Control control2 = tabItem.control;
            if (control2 != null && !control2.isDisposed()) {
                control2.setBounds(this.getClientArea());
            }
        }
        return n6;
    }

    public void setSelection(TabItem tabItem) {
        this.checkWidget();
        if (tabItem == null) {
            this.error(4);
        }
        this.setSelection(new TabItem[]{tabItem});
    }

    public void setSelection(TabItem[] tabItemArray) {
        this.checkWidget();
        if (tabItemArray == null) {
            this.error(4);
        }
        if (tabItemArray.length == 0) {
            this.setSelection(-1, false, false);
        } else {
            int n = tabItemArray.length - 1;
            while (n >= 0) {
                int n2 = this.indexOf(tabItemArray[n]);
                if (n2 != -1) {
                    this.setSelection(n2, false, false);
                }
                --n;
            }
        }
    }

    public void setSelection(int n) {
        this.checkWidget();
        int n2 = OS.GetControl32BitMaximum(this.handle);
        if (n < 0 || n >= n2) {
            return;
        }
        this.setSelection(n, false, false);
    }

    void setSelection(int n, boolean bl, boolean bl2) {
        Control control2;
        TabItem tabItem;
        if (n >= OS.GetControl32BitMaximum(this.handle)) {
            return;
        }
        int n2 = OS.GetControl32BitValue(this.handle) - 1;
        if (!bl2 && n2 == n) {
            return;
        }
        if (n2 != -1 && (tabItem = this.items[n2]) != null && (control2 = tabItem.control) != null && !control2.isDisposed()) {
            control2.setVisible(false);
        }
        OS.SetControl32BitValue(this.handle, n + 1);
        n = OS.GetControl32BitValue(this.handle) - 1;
        if (this.hasFocus()) {
            int n3 = OS.GetControlOwner(this.handle);
            OS.SetKeyboardFocus(n3, this.handle, (short)(n + 1));
        }
        this.lastSelected = n;
        if (n != -1 && (tabItem = this.items[n]) != null) {
            control2 = tabItem.control;
            if (control2 != null && !control2.isDisposed()) {
                control2.setBounds(this.getClientArea());
                control2.setVisible(true);
            }
            if (bl) {
                Event event = new Event();
                event.item = tabItem;
                this.sendEvent(13, event);
            }
        }
    }

    boolean traversePage(boolean bl) {
        int n = this.getItemCount();
        if (n == 0) {
            return false;
        }
        int n2 = this.getSelectionIndex();
        if (n2 == -1) {
            n2 = 0;
        } else {
            int n3 = bl ? 1 : -1;
            n2 = (n2 + n3 + n) % n;
        }
        this.setSelection(n2, true, false);
        return n2 == this.getSelectionIndex();
    }
}

