/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.internal.IntAffineMatrix;
import org.eclipse.ui.internal.Shape;

public class OvalComposite
extends Composite
implements PaintListener {
    static final int[] TOP_LEFT_CORNER;
    private int orientation;
    private Color interiorColor;

    static {
        int[] nArray = new int[6];
        nArray[1] = 2;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 2;
        TOP_LEFT_CORNER = nArray;
    }

    public OvalComposite(Composite parent, int orientation) {
        super(parent, 0);
        this.addPaintListener(this);
        this.orientation = orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
        this.redraw();
    }

    public void paintControl(PaintEvent e) {
        GC gc = e.gc;
        Color color = e.display.getSystemColor(18);
        gc.setForeground(color);
        if (this.interiorColor != null) {
            gc.setBackground(this.interiorColor);
        }
        Shape shape = new Shape(TOP_LEFT_CORNER.length + 2);
        IntAffineMatrix rotation = IntAffineMatrix.getRotation(this.orientation);
        rotation = rotation.multiply(IntAffineMatrix.ROT_180);
        Point size = this.getSize();
        if (!Geometry.isHorizontal(this.orientation)) {
            Geometry.flipXY(size);
        }
        shape.add(0, size.y);
        shape.add(new Shape(TOP_LEFT_CORNER));
        shape.add(IntAffineMatrix.translation(size.x - 3, 0).multiply(IntAffineMatrix.FLIP_YAXIS), shape.reverse());
        Point rawSize = this.getSize();
        Point adjust = new Point(0, 0);
        switch (this.orientation) {
            case 128: {
                adjust = rawSize;
                break;
            }
            case 16384: {
                adjust = new Point(rawSize.x - 1, 0);
                break;
            }
            case 131072: {
                adjust = new Point(0, rawSize.y - 3);
            }
        }
        Shape targetShape = IntAffineMatrix.translation(adjust.x, adjust.y).multiply(rotation).transform(shape);
        int[] shapeArray = targetShape.getData();
        if (this.interiorColor != null) {
            gc.fillPolygon(shapeArray);
        }
        gc.drawPolyline(shapeArray);
    }

    public Rectangle getClientArea() {
        Rectangle result = Geometry.copy(super.getClientArea());
        if (Geometry.isHorizontal(this.orientation)) {
            Geometry.expand(result, -6, -6, this.orientation == 1024 ? -1 : 0, this.orientation == 128 ? -1 : 0);
        } else {
            Geometry.expand(result, this.orientation == 131072 ? -1 : 0, this.orientation == 16384 ? -1 : 0, -6, -6);
        }
        return result;
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        Rectangle result = Geometry.copy(super.computeTrim(x, y, width, height));
        if (Geometry.isHorizontal(this.orientation)) {
            Geometry.expand(result, 6, 6, this.orientation == 1024 ? 1 : 0, this.orientation == 128 ? 1 : 0);
        } else {
            Geometry.expand(result, this.orientation == 131072 ? 1 : 0, this.orientation == 16384 ? 1 : 0, 6, 6);
        }
        return result;
    }

    public Color getInteriorColor() {
        return this.interiorColor;
    }

    public void setInteriorColor(Color interiorColor) {
        this.interiorColor = interiorColor;
    }
}

