/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.activities.ActivityDefinition;
import org.eclipse.ui.internal.activities.ActivityPatternBindingDefinition;
import org.eclipse.ui.internal.activities.ActivityRequirementBindingDefinition;
import org.eclipse.ui.internal.activities.CategoryActivityBindingDefinition;
import org.eclipse.ui.internal.activities.CategoryDefinition;
import org.eclipse.ui.internal.util.Util;

final class Persistence {
    static final String PACKAGE_BASE = "activities";
    static final String PACKAGE_FULL = "org.eclipse.ui.activities";
    static final String PACKAGE_PREFIX = "org.eclipse.ui";
    static final String TAG_ACTIVITY = "activity";
    static final String TAG_ACTIVITY_REQUIREMENT_BINDING = "activityRequirementBinding";
    static final String TAG_DEFAULT_ENABLEMENT = "defaultEnablement";
    static final String TAG_ACTIVITY_ID = "activityId";
    static final String TAG_ACTIVITY_PATTERN_BINDING = "activityPatternBinding";
    static final String TAG_CATEGORY = "category";
    static final String TAG_CATEGORY_ACTIVITY_BINDING = "categoryActivityBinding";
    static final String TAG_CATEGORY_ID = "categoryId";
    static final String TAG_REQUIRED_ACTIVITY_ID = "requiredActivityId";
    static final String TAG_ID = "id";
    static final String TAG_NAME = "name";
    static final String TAG_PATTERN = "pattern";
    static final String TAG_SOURCE_ID = "sourceId";
    static final String TAG_DESCRIPTION = "description";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    static ActivityRequirementBindingDefinition readActivityRequirementBindingDefinition(IMemento memento, String sourceIdOverride) {
        if (memento == null) {
            throw new NullPointerException();
        }
        String childActivityId = memento.getString(TAG_REQUIRED_ACTIVITY_ID);
        String parentActivityId = memento.getString(TAG_ACTIVITY_ID);
        if (childActivityId == null || parentActivityId == null) {
            return null;
        }
        String sourceId = sourceIdOverride != null ? sourceIdOverride : memento.getString(TAG_SOURCE_ID);
        return new ActivityRequirementBindingDefinition(childActivityId, parentActivityId, sourceId);
    }

    static List readActivityRequirementBindingDefinitions(IMemento memento, String name, String sourceIdOverride) {
        if (memento == null || name == null) {
            throw new NullPointerException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new NullPointerException();
        }
        ArrayList<ActivityRequirementBindingDefinition> list = new ArrayList<ActivityRequirementBindingDefinition>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            ActivityRequirementBindingDefinition binding = Persistence.readActivityRequirementBindingDefinition(mementos[i], sourceIdOverride);
            if (binding != null) {
                list.add(binding);
            }
            ++i;
        }
        return list;
    }

    static String readDefaultEnablement(IMemento memento) {
        if (memento == null) {
            throw new NullPointerException();
        }
        return memento.getString(TAG_ID);
    }

    static ActivityDefinition readActivityDefinition(IMemento memento, String sourceIdOverride) {
        if (memento == null) {
            throw new NullPointerException();
        }
        String id = memento.getString(TAG_ID);
        if (id == null) {
            return null;
        }
        String name = memento.getString(TAG_NAME);
        if (name == null) {
            return null;
        }
        String description = memento.getString(TAG_DESCRIPTION);
        if (description == null) {
            description = "";
        }
        String sourceId = sourceIdOverride != null ? sourceIdOverride : memento.getString(TAG_SOURCE_ID);
        return new ActivityDefinition(id, name, sourceId, description);
    }

    static List readActivityDefinitions(IMemento memento, String name, String sourceIdOverride) {
        if (memento == null || name == null) {
            throw new NullPointerException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new NullPointerException();
        }
        ArrayList<ActivityDefinition> list = new ArrayList<ActivityDefinition>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            ActivityDefinition definition = Persistence.readActivityDefinition(mementos[i], sourceIdOverride);
            if (definition != null) {
                list.add(definition);
            }
            ++i;
        }
        return list;
    }

    static ActivityPatternBindingDefinition readActivityPatternBindingDefinition(IMemento memento, String sourceIdOverride) {
        if (memento == null) {
            throw new NullPointerException();
        }
        String activityId = memento.getString(TAG_ACTIVITY_ID);
        if (activityId == null) {
            return null;
        }
        String pattern = memento.getString(TAG_PATTERN);
        if (pattern == null) {
            return null;
        }
        String sourceId = sourceIdOverride != null ? sourceIdOverride : memento.getString(TAG_SOURCE_ID);
        return new ActivityPatternBindingDefinition(activityId, pattern, sourceId);
    }

    static List readActivityPatternBindingDefinitions(IMemento memento, String name, String sourceIdOverride) {
        if (memento == null || name == null) {
            throw new NullPointerException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new NullPointerException();
        }
        ArrayList<ActivityPatternBindingDefinition> list = new ArrayList<ActivityPatternBindingDefinition>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            ActivityPatternBindingDefinition definition = Persistence.readActivityPatternBindingDefinition(mementos[i], sourceIdOverride);
            if (definition != null) {
                list.add(definition);
            }
            ++i;
        }
        return list;
    }

    static CategoryActivityBindingDefinition readCategoryActivityBindingDefinition(IMemento memento, String sourceIdOverride) {
        if (memento == null) {
            throw new NullPointerException();
        }
        String activityId = memento.getString(TAG_ACTIVITY_ID);
        if (activityId == null) {
            return null;
        }
        String categoryId = memento.getString(TAG_CATEGORY_ID);
        if (categoryId == null) {
            return null;
        }
        String sourceId = sourceIdOverride != null ? sourceIdOverride : memento.getString(TAG_SOURCE_ID);
        return new CategoryActivityBindingDefinition(activityId, categoryId, sourceId);
    }

    static List readCategoryActivityBindingDefinitions(IMemento memento, String name, String sourceIdOverride) {
        if (memento == null || name == null) {
            throw new NullPointerException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new NullPointerException();
        }
        ArrayList<CategoryActivityBindingDefinition> list = new ArrayList<CategoryActivityBindingDefinition>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            CategoryActivityBindingDefinition definition = Persistence.readCategoryActivityBindingDefinition(mementos[i], sourceIdOverride);
            if (definition != null) {
                list.add(definition);
            }
            ++i;
        }
        return list;
    }

    static CategoryDefinition readCategoryDefinition(IMemento memento, String sourceIdOverride) {
        if (memento == null) {
            throw new NullPointerException();
        }
        String id = memento.getString(TAG_ID);
        if (id == null) {
            return null;
        }
        String name = memento.getString(TAG_NAME);
        if (name == null) {
            return null;
        }
        String description = memento.getString(TAG_DESCRIPTION);
        if (description == null) {
            description = "";
        }
        String sourceId = sourceIdOverride != null ? sourceIdOverride : memento.getString(TAG_SOURCE_ID);
        return new CategoryDefinition(id, name, sourceId, description);
    }

    static List readCategoryDefinitions(IMemento memento, String name, String sourceIdOverride) {
        if (memento == null || name == null) {
            throw new NullPointerException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new NullPointerException();
        }
        ArrayList<CategoryDefinition> list = new ArrayList<CategoryDefinition>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            CategoryDefinition definition = Persistence.readCategoryDefinition(mementos[i], sourceIdOverride);
            if (definition != null) {
                list.add(definition);
            }
            ++i;
        }
        return list;
    }

    static void writeActivityRequirementBindingDefinition(IMemento memento, ActivityRequirementBindingDefinition activityRequirementBindingDefinition) {
        if (memento == null || activityRequirementBindingDefinition == null) {
            throw new NullPointerException();
        }
        memento.putString(TAG_REQUIRED_ACTIVITY_ID, activityRequirementBindingDefinition.getRequiredActivityId());
        memento.putString(TAG_ACTIVITY_ID, activityRequirementBindingDefinition.getActivityId());
        memento.putString(TAG_SOURCE_ID, activityRequirementBindingDefinition.getSourceId());
    }

    static void writeActivityRequirementBindingDefinitions(IMemento memento, String name, List activityRequirementBindingDefinitions) {
        if (memento == null || name == null || activityRequirementBindingDefinitions == null) {
            throw new NullPointerException();
        }
        activityRequirementBindingDefinitions = new ArrayList(activityRequirementBindingDefinitions);
        Iterator iterator = activityRequirementBindingDefinitions.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.ui.internal.activities.ActivityRequirementBindingDefinition");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Util.assertInstance(e, clazz);
        }
        iterator = activityRequirementBindingDefinitions.iterator();
        while (iterator.hasNext()) {
            Persistence.writeActivityRequirementBindingDefinition(memento.createChild(name), (ActivityRequirementBindingDefinition)iterator.next());
        }
    }

    static void writeActivityDefinition(IMemento memento, ActivityDefinition activityDefinition) {
        if (memento == null || activityDefinition == null) {
            throw new NullPointerException();
        }
        memento.putString(TAG_ID, activityDefinition.getId());
        memento.putString(TAG_NAME, activityDefinition.getName());
        memento.putString(TAG_SOURCE_ID, activityDefinition.getSourceId());
    }

    static void writeActivityDefinitions(IMemento memento, String name, List activityDefinitions) {
        if (memento == null || name == null || activityDefinitions == null) {
            throw new NullPointerException();
        }
        activityDefinitions = new ArrayList(activityDefinitions);
        Iterator iterator = activityDefinitions.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.ui.internal.activities.ActivityDefinition");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Util.assertInstance(e, clazz);
        }
        iterator = activityDefinitions.iterator();
        while (iterator.hasNext()) {
            Persistence.writeActivityDefinition(memento.createChild(name), (ActivityDefinition)iterator.next());
        }
    }

    static void writeActivityPatternBindingDefinition(IMemento memento, ActivityPatternBindingDefinition activityPatternBindingDefinition) {
        if (memento == null || activityPatternBindingDefinition == null) {
            throw new NullPointerException();
        }
        memento.putString(TAG_ACTIVITY_ID, activityPatternBindingDefinition.getActivityId());
        memento.putString(TAG_PATTERN, activityPatternBindingDefinition.getPattern());
        memento.putString(TAG_SOURCE_ID, activityPatternBindingDefinition.getSourceId());
    }

    static void writeActivityPatternBindingDefinitions(IMemento memento, String name, List activityPatternBindingDefinitions) {
        if (memento == null || name == null || activityPatternBindingDefinitions == null) {
            throw new NullPointerException();
        }
        activityPatternBindingDefinitions = new ArrayList(activityPatternBindingDefinitions);
        Iterator iterator = activityPatternBindingDefinitions.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.ui.internal.activities.ActivityPatternBindingDefinition");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Util.assertInstance(e, clazz);
        }
        iterator = activityPatternBindingDefinitions.iterator();
        while (iterator.hasNext()) {
            Persistence.writeActivityPatternBindingDefinition(memento.createChild(name), (ActivityPatternBindingDefinition)iterator.next());
        }
    }

    static void writeCategoryActivityBindingDefinition(IMemento memento, CategoryActivityBindingDefinition categoryActivityBindingDefinition) {
        if (memento == null || categoryActivityBindingDefinition == null) {
            throw new NullPointerException();
        }
        memento.putString(TAG_ACTIVITY_ID, categoryActivityBindingDefinition.getActivityId());
        memento.putString(TAG_CATEGORY_ID, categoryActivityBindingDefinition.getCategoryId());
        memento.putString(TAG_SOURCE_ID, categoryActivityBindingDefinition.getSourceId());
    }

    static void writeCategoryActivityBindingDefinitions(IMemento memento, String name, List categoryActivityBindingDefinitions) {
        if (memento == null || name == null || categoryActivityBindingDefinitions == null) {
            throw new NullPointerException();
        }
        categoryActivityBindingDefinitions = new ArrayList(categoryActivityBindingDefinitions);
        Iterator iterator = categoryActivityBindingDefinitions.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.ui.internal.activities.CategoryActivityBindingDefinition");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Util.assertInstance(e, clazz);
        }
        iterator = categoryActivityBindingDefinitions.iterator();
        while (iterator.hasNext()) {
            Persistence.writeCategoryActivityBindingDefinition(memento.createChild(name), (CategoryActivityBindingDefinition)iterator.next());
        }
    }

    static void writeCategoryDefinition(IMemento memento, CategoryDefinition categoryDefinition) {
        if (memento == null || categoryDefinition == null) {
            throw new NullPointerException();
        }
        memento.putString(TAG_ID, categoryDefinition.getId());
        memento.putString(TAG_NAME, categoryDefinition.getName());
        memento.putString(TAG_SOURCE_ID, categoryDefinition.getSourceId());
    }

    static void writeCategoryDefinitions(IMemento memento, String name, List categoryDefinitions) {
        if (memento == null || name == null || categoryDefinitions == null) {
            throw new NullPointerException();
        }
        categoryDefinitions = new ArrayList(categoryDefinitions);
        Iterator iterator = categoryDefinitions.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.ui.internal.activities.CategoryDefinition");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Util.assertInstance(e, clazz);
        }
        iterator = categoryDefinitions.iterator();
        while (iterator.hasNext()) {
            Persistence.writeCategoryDefinition(memento.createChild(name), (CategoryDefinition)iterator.next());
        }
    }

    private Persistence() {
    }
}

