/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.handlers.HandlerProxy;
import org.eclipse.ui.internal.handlers.LegacyHandlerProxy;
import org.eclipse.ui.internal.handlers.LegacyHandlerWrapper;

final class HandlerPersistence {
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_COMMAND_ID = "commandId";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_DEFAULT_HANDLER = "defaultHandler";
    private static final String ELEMENT_COMMAND = "command";
    private static final String ELEMENT_ACTIVE_WHEN = "activeWhen";
    private static final String ELEMENT_CLASS = "class";
    private static final String ELEMENT_DEFAULT_HANDLER = "defaultHandler";
    private static final String ELEMENT_ENABLED_WHEN = "enabledWhen";
    private static final String ELEMENT_HANDLER = "handler";
    private static final String ELEMENT_HANDLER_SUBMISSION = "handlerSubmission";
    private static final String EXTENSION_COMMANDS = "org.eclipse.ui.commands";
    private static final String EXTENSION_HANDLERS = "org.eclipse.ui.handlers";
    private static final Collection handlerActivations = new ArrayList();
    private static final int INDEX_COMMAND_DEFINITIONS = 0;
    private static final int INDEX_HANDLER_DEFINITIONS = 1;
    private static final int INDEX_HANDLER_SUBMISSIONS = 2;
    private static boolean listenersAttached = false;

    HandlerPersistence() {
    }

    private static final void addElementToIndexedArray(IConfigurationElement elementToAdd, IConfigurationElement[][] indexedArray, int index, int currentCount) {
        IConfigurationElement[] elements;
        if (currentCount == 0) {
            elements = new IConfigurationElement[1];
            indexedArray[index] = elements;
        } else if (currentCount >= indexedArray[index].length) {
            IConfigurationElement[] copy = new IConfigurationElement[indexedArray[index].length * 2];
            System.arraycopy(indexedArray[index], 0, copy, 0, currentCount);
            elements = copy;
            indexedArray[index] = elements;
        } else {
            elements = indexedArray[index];
        }
        elements[currentCount] = elementToAdd;
    }

    private static final void clearActivations(IHandlerService handlerService) {
        handlerService.deactivateHandlers(handlerActivations);
        handlerActivations.clear();
    }

    static final void read(final IHandlerService handlerService) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        int commandDefinitionCount = 0;
        int handlerDefinitionCount = 0;
        int handlerSubmissionCount = 0;
        IConfigurationElement[][] indexedConfigurationElements = new IConfigurationElement[3][];
        IConfigurationElement[] commandsExtensionPoint = registry.getConfigurationElementsFor(EXTENSION_COMMANDS);
        int i = 0;
        while (i < commandsExtensionPoint.length) {
            IConfigurationElement configurationElement = commandsExtensionPoint[i];
            String name = configurationElement.getName();
            if (ELEMENT_HANDLER_SUBMISSION.equals(name)) {
                HandlerPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 2, handlerSubmissionCount++);
            } else if (ELEMENT_COMMAND.equals(name)) {
                HandlerPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 0, commandDefinitionCount++);
            }
            ++i;
        }
        IConfigurationElement[] handlersExtensionPoint = registry.getConfigurationElementsFor(EXTENSION_HANDLERS);
        int i2 = 0;
        while (i2 < handlersExtensionPoint.length) {
            IConfigurationElement configurationElement = handlersExtensionPoint[i2];
            String name = configurationElement.getName();
            if (ELEMENT_HANDLER.equals(name)) {
                HandlerPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 1, handlerDefinitionCount++);
            }
            ++i2;
        }
        HandlerPersistence.clearActivations(handlerService);
        HandlerPersistence.readDefaultHandlersFromCommandsExtensionPoint(indexedConfigurationElements[0], commandDefinitionCount, handlerService);
        HandlerPersistence.readHandlerSubmissionsFromCommandsExtensionPoint(indexedConfigurationElements[2], handlerSubmissionCount, handlerService);
        HandlerPersistence.readHandlersFromHandlersExtensionPoint(indexedConfigurationElements[1], handlerDefinitionCount, handlerService);
        if (!listenersAttached) {
            registry.addRegistryChangeListener(new IRegistryChangeListener(){

                public final void registryChanged(IRegistryChangeEvent event) {
                    IExtensionDelta[] actionDefinitionDeltas;
                    IExtensionDelta[] commandDeltas;
                    IExtensionDelta[] handlerDeltas = event.getExtensionDeltas("org.eclipse.ui", "handlers");
                    if (handlerDeltas.length == 0 && (commandDeltas = event.getExtensionDeltas("org.eclipse.ui", "commands")).length == 0 && (actionDefinitionDeltas = event.getExtensionDeltas("org.eclipse.ui", "actionDefinitions")).length == 0) {
                        return;
                    }
                    Display.getDefault().asyncExec(new Runnable(this, handlerService){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ IHandlerService val$handlerService;
                        {
                            this.this$1 = var1_1;
                            this.val$handlerService = iHandlerService;
                        }

                        public void run() {
                            HandlerPersistence.read(this.val$handlerService);
                        }
                    });
                }
            }, "org.eclipse.ui");
            listenersAttached = true;
        }
    }

    private static final void readDefaultHandlersFromCommandsExtensionPoint(IConfigurationElement[] configurationElements, int configurationElementCount, IHandlerService handlerService) {
        int i = 0;
        while (i < configurationElementCount) {
            IConfigurationElement configurationElement = configurationElements[i];
            String commandId = configurationElement.getAttribute(ATTRIBUTE_ID);
            if (commandId != null && commandId.length() != 0 && (configurationElement.getAttribute("defaultHandler") != null || configurationElement.getChildren("defaultHandler").length != 0)) {
                handlerActivations.add(handlerService.activateHandler(commandId, (IHandler)new HandlerProxy(configurationElement, "defaultHandler")));
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static final void readHandlersFromHandlersExtensionPoint(IConfigurationElement[] configurationElements, int configurationElementCount, IHandlerService handlerService) {
        warningsToLog = null;
        i = 0;
        while (i < configurationElementCount) {
            block17: {
                block19: {
                    block20: {
                        block18: {
                            block16: {
                                configurationElement = configurationElements[i];
                                commandId = configurationElement.getAttribute("commandId");
                                if (commandId != null && commandId.length() != 0) break block16;
                                message = "Handlers need a command id: plug-in='" + configurationElement.getNamespace() + "'.";
                                status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, message, null);
                                if (warningsToLog == null) {
                                    warningsToLog = new ArrayList<Status>();
                                }
                                warningsToLog.add(status);
                                break block17;
                            }
                            if (configurationElement.getAttribute("class") != null || configurationElement.getChildren("class").length != 0) break block18;
                            message = "Handlers need a class: plug-in='" + configurationElement.getNamespace() + "', commandId=" + commandId + "'.";
                            status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, message, null);
                            if (warningsToLog == null) {
                                warningsToLog = new ArrayList<E>();
                            }
                            warningsToLog.add(status);
                            break block17;
                        }
                        activeWhenElements = configurationElement.getChildren("activeWhen");
                        activeWhenExpression = null;
                        if (activeWhenElements.length <= 0) break block19;
                        if (activeWhenElements.length <= 1) break block20;
                        message = "Handlers should only have one activeWhen element: plug-in='" + configurationElement.getNamespace() + "', commandId=" + commandId + "'.";
                        status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, message, null);
                        if (warningsToLog == null) {
                            warningsToLog = new ArrayList<E>();
                        }
                        warningsToLog.add(status);
                        break block17;
                    }
                    elementHandler = ElementHandler.getDefault();
                    converter = ExpressionConverter.getDefault();
                    try {
                        activeWhenExpression = elementHandler.create(converter, activeWhenElements[0]);
                    }
                    catch (CoreException v0) {
                        message = "Problem creating activeWhen element: plug-in='" + configurationElement.getNamespace() + "', commandId=" + commandId + "'.";
                        status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, message, null);
                        if (warningsToLog == null) {
                            warningsToLog = new ArrayList<E>();
                        }
                        warningsToLog.add(status);
                    }
                }
                enabledWhenElements = configurationElement.getChildren("enabledWhen");
                enabledWhenExpression = null;
                if (enabledWhenElements.length <= 0) ** GOTO lbl72
                if (enabledWhenElements.length > 1) {
                    message = "Handlers should only have one enabledWhen element: plug-in='" + configurationElement.getNamespace() + "', commandId=" + commandId + "'.";
                    status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, message, null);
                    if (warningsToLog == null) {
                        warningsToLog = new ArrayList<E>();
                    }
                    warningsToLog.add(status);
                } else {
                    elementHandler = ElementHandler.getDefault();
                    converter = ExpressionConverter.getDefault();
                    try {
                        enabledWhenExpression = elementHandler.create(converter, enabledWhenElements[0]);
                    }
                    catch (CoreException v1) {
                        message = "Problem creating enabledWhen element: plug-in='" + configurationElement.getNamespace() + "', commandId=" + commandId + "'.";
                        status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, message, null);
                        if (warningsToLog == null) {
                            warningsToLog = new ArrayList<E>();
                        }
                        warningsToLog.add(status);
                    }
lbl72:
                    // 3 sources

                    if (activeWhenExpression != null) {
                        HandlerPersistence.handlerActivations.add(handlerService.activateHandler(commandId, (IHandler)new HandlerProxy(configurationElement, "class", enabledWhenExpression, handlerService), activeWhenExpression, 0x40440040));
                    } else {
                        HandlerPersistence.handlerActivations.add(handlerService.activateHandler(commandId, (IHandler)new HandlerProxy(configurationElement, "class", enabledWhenExpression, handlerService)));
                    }
                }
            }
            ++i;
        }
        if (warningsToLog != null) {
            status = new MultiStatus(WorkbenchPlugin.PI_WORKBENCH, 0, warningsToLog.toArray(new IStatus[warningsToLog.size()]), "Warnings while parsing the handlers from the 'org.eclipse.ui.handlers' extension point.", null);
            WorkbenchPlugin.log(status);
        }
    }

    private static final void readHandlerSubmissionsFromCommandsExtensionPoint(IConfigurationElement[] configurationElements, int configurationElementCount, IHandlerService handlerService) {
        ArrayList<Status> warningsToLog = null;
        int i = 0;
        while (i < configurationElementCount) {
            IConfigurationElement configurationElement = configurationElements[i];
            String commandId = configurationElement.getAttribute(ATTRIBUTE_COMMAND_ID);
            if (commandId == null || commandId.length() == 0) {
                String message = "Handler submissions need a command id: '" + configurationElement.getNamespace() + "'.";
                Status status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, message, null);
                if (warningsToLog == null) {
                    warningsToLog = new ArrayList<Status>();
                }
                warningsToLog.add(status);
            } else {
                handlerActivations.add(handlerService.activateHandler(commandId, new LegacyHandlerWrapper(new LegacyHandlerProxy(configurationElement))));
            }
            ++i;
        }
        if (warningsToLog != null) {
            MultiStatus status = new MultiStatus(WorkbenchPlugin.PI_WORKBENCH, 0, warningsToLog.toArray(new IStatus[warningsToLog.size()]), "Warnings while parsing the handler submissions from the 'org.eclipse.ui.commands' extension point.", null);
            WorkbenchPlugin.log(status);
        }
    }
}

