/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys;

import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.ISchemeListener;
import org.eclipse.jface.bindings.SchemeEvent;
import org.eclipse.ui.commands.IKeyConfigurationListener;
import org.eclipse.ui.commands.KeyConfigurationEvent;
import org.eclipse.ui.internal.keys.SchemeWrapper;

final class SchemeListenerWrapper
implements ISchemeListener {
    private final BindingManager bindingManager;
    private final IKeyConfigurationListener listener;

    SchemeListenerWrapper(IKeyConfigurationListener listener, BindingManager bindingManager) {
        if (listener == null) {
            throw new NullPointerException("Cannot wrap a null listener");
        }
        if (bindingManager == null) {
            throw new NullPointerException("Cannot wrap a listener without a binding manager");
        }
        this.listener = listener;
        this.bindingManager = bindingManager;
    }

    public final boolean equals(Object object) {
        if (object instanceof SchemeListenerWrapper) {
            SchemeListenerWrapper wrapper = (SchemeListenerWrapper)object;
            return this.listener.equals(wrapper.listener);
        }
        if (object instanceof IKeyConfigurationListener) {
            IKeyConfigurationListener other = (IKeyConfigurationListener)object;
            return this.listener.equals(other);
        }
        return false;
    }

    public final int hashCode() {
        return this.listener.hashCode();
    }

    public final void schemeChanged(SchemeEvent schemeEvent) {
        SchemeWrapper keyConfiguration = new SchemeWrapper(schemeEvent.getScheme(), this.bindingManager);
        boolean definedChanged = schemeEvent.isDefinedChanged();
        boolean nameChanged = schemeEvent.isNameChanged();
        boolean parentIdChanged = schemeEvent.isParentIdChanged();
        this.listener.keyConfigurationChanged(new KeyConfigurationEvent(keyConfiguration, false, definedChanged, nameChanged, parentIdChanged));
    }
}

