/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.part;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.components.framework.ComponentException;
import org.eclipse.ui.internal.components.framework.Components;
import org.eclipse.ui.internal.components.framework.FactoryMap;
import org.eclipse.ui.internal.components.framework.ServiceFactory;
import org.eclipse.ui.internal.part.IPartPropertyProvider;
import org.eclipse.ui.internal.part.NewPartToWorkbenchPartAdapter;
import org.eclipse.ui.internal.part.Part;
import org.eclipse.ui.internal.part.SelectionProviderAdapter;
import org.eclipse.ui.internal.part.StatusPart;
import org.eclipse.ui.internal.part.components.services.IPartActionBars;
import org.eclipse.ui.internal.part.components.services.ISecondaryId;
import org.eclipse.ui.internal.part.components.services.ISelectionHandler;
import org.eclipse.ui.internal.part.components.services.IStatusHandler;
import org.eclipse.ui.internal.part.components.services.IWorkbenchPartFactory;

abstract class NewPartToOldWrapper
extends NewPartToWorkbenchPartAdapter {
    private Part part = null;
    private SelectionProviderAdapter selectionProvider;
    private PartServices services = new PartServices();
    private IWorkbenchPartSite partSite;
    private IPartActionBars partActionBars = null;
    private ResourceManager rm;
    private ImageDescriptor currentStatusImageDescriptor = null;
    private Image currentStatusImage = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public NewPartToOldWrapper(IPartPropertyProvider provider) {
        super(provider);
    }

    public void setStatus(IStatus message, ImageDescriptor image) {
        IStatusLineManager mgr = this.getStatusLineManager();
        Image newImage = null;
        if (image != null) {
            newImage = this.getResources().createImageWithDefault(image);
        }
        if (message == null) {
            mgr.setErrorMessage(null);
            mgr.setMessage(null);
        } else if (message.getSeverity() == 4) {
            mgr.setMessage(null);
            if (newImage == null) {
                mgr.setErrorMessage(message.getMessage());
            } else {
                mgr.setErrorMessage(newImage, message.getMessage());
            }
        } else {
            mgr.setErrorMessage(null);
            if (newImage == null) {
                mgr.setMessage(message.getMessage());
            } else {
                mgr.setMessage(newImage, message.getMessage());
            }
        }
        this.disposeStatusImage();
        this.currentStatusImage = newImage;
        this.currentStatusImageDescriptor = image;
    }

    private void disposeStatusImage() {
        if (this.currentStatusImageDescriptor != null) {
            this.getResources().destroy(this.currentStatusImageDescriptor);
            this.currentStatusImage = null;
            this.currentStatusImageDescriptor = null;
        }
    }

    protected abstract IStatusLineManager getStatusLineManager();

    public IPartActionBars getPartActionBars() {
        if (this.partActionBars == null) {
            this.partActionBars = this.createPartActionBars();
        }
        return this.partActionBars;
    }

    protected abstract IPartActionBars createPartActionBars();

    protected abstract IMemento getMemento();

    public void createPartControl(Composite parent) {
        try {
            FactoryMap args = new FactoryMap();
            args.addInstance(this.services);
            args.addInstance(this.getPropertyProvider());
            this.addServices(args);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.widgets.Composite");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            args.mapInstance(clazz, parent);
            parent.setLayout(new FillLayout());
            this.part = this.createPart(parent, args);
        }
        catch (ComponentException e) {
            WorkbenchPlugin.getDefault().getLog().log(e.getStatus());
            new StatusPart(parent, e.getStatus());
        }
    }

    private ResourceManager getResources() {
        if (this.rm == null) {
            IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.jface.resource.ResourceManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.rm = (ResourceManager)iWorkbenchPartSite.getAdapter(clazz);
        }
        return this.rm;
    }

    protected void addServices(FactoryMap context) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.internal.part.IPartPropertyProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        context.mapInstance(clazz, this.getPropertyProvider());
    }

    protected abstract Part createPart(Composite var1, ServiceFactory var2) throws ComponentException;

    protected abstract String getSecondaryId();

    public void setFocus() {
        if (this.part != null) {
            this.part.getControl().setFocus();
        }
    }

    private SelectionProviderAdapter getSelectionProvider() {
        if (this.selectionProvider == null) {
            this.selectionProvider = new SelectionProviderAdapter();
            this.getSite().setSelectionProvider(this.selectionProvider);
        }
        return this.selectionProvider;
    }

    protected Part getPart() {
        return this.part;
    }

    protected IWorkbenchPartFactory getFactory() {
        IWorkbenchPartFactory siteFactory;
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.ui.internal.part.components.services.IWorkbenchPartFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((siteFactory = (IWorkbenchPartFactory)iWorkbenchPartSite.getAdapter(clazz)) == null) {
            return ((WorkbenchPage)this.getSite().getPage()).getPartFactory();
        }
        return siteFactory;
    }

    protected void setSite(IWorkbenchPartSite site) {
        this.partSite = site;
    }

    public IWorkbenchPartSite getSite() {
        return this.partSite;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this)) {
            return this;
        }
        if (this.part != null) {
            return Components.getAdapter(this.part, adapter);
        }
        return null;
    }

    public void dispose() {
        this.disposeStatusImage();
        super.dispose();
    }

    private final class PartServices
    implements ISecondaryId,
    IAdaptable,
    ISelectionHandler,
    IStatusHandler {
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        PartServices() {
        }

        public String getSecondaryId() {
            return NewPartToOldWrapper.this.getSecondaryId();
        }

        public void set(IStatus message, ImageDescriptor image) {
            NewPartToOldWrapper.this.setStatus(message, image);
        }

        public Object getAdapter(Class adapter) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.internal.part.components.services.IPartActionBars");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter == clazz) {
                return NewPartToOldWrapper.this.getPartActionBars();
            }
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.ui.IKeyBindingService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter == clazz2) {
                return NewPartToOldWrapper.this.getSite().getKeyBindingService();
            }
            return null;
        }

        public void setSelection(ISelection newSelection) {
            SelectionProviderAdapter newSelectionProvider = null;
            if (newSelection != null) {
                newSelectionProvider = NewPartToOldWrapper.this.getSelectionProvider();
                newSelectionProvider.setSelection(newSelection);
            }
            if (NewPartToOldWrapper.this.getSite().getSelectionProvider() != newSelectionProvider) {
                NewPartToOldWrapper.this.getSite().setSelectionProvider(newSelectionProvider);
            }
        }
    }
}

