/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.part.services;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.part.components.services.IStatusFactory;
import org.eclipse.ui.internal.part.components.services.IStatusHandler;
import org.eclipse.ui.internal.part.services.NullContributionManager;

public class StatusLineManagerAdapter
extends NullContributionManager
implements IStatusLineManager {
    private IStatusHandler handler;
    private IStatusFactory factory;
    private String currentError;
    private Image currentErrorImage;
    private String currentMessage;
    private Image currentMessageImage;

    public StatusLineManagerAdapter(IStatusHandler handler, IStatusFactory factory) {
        this.handler = handler;
        this.factory = factory;
    }

    public IProgressMonitor getProgressMonitor() {
        return new NullProgressMonitor();
    }

    public boolean isCancelEnabled() {
        return false;
    }

    public void setCancelEnabled(boolean enabled) {
    }

    public void setErrorMessage(String message) {
        this.setErrorMessage(null, message);
    }

    public void setErrorMessage(Image image, String message) {
        this.currentErrorImage = image;
        this.currentError = message;
        this.updateHandler();
    }

    public void setMessage(String message) {
        this.setMessage(null, message);
    }

    public void setMessage(Image image, String message) {
        this.currentMessageImage = image;
        this.currentMessage = message;
        this.updateHandler();
    }

    private void updateHandler() {
        if (this.currentError != null) {
            this.handler.set(this.factory.newError(this.currentError, null), this.currentErrorImage == null ? null : ImageDescriptor.createFromImage(this.currentErrorImage));
            return;
        }
        if (this.currentMessage != null) {
            this.handler.set(this.factory.newMessage(this.currentMessage), this.currentMessageImage == null ? null : ImageDescriptor.createFromImage(this.currentMessageImage));
            return;
        }
        this.handler.set(null, null);
    }
}

