/*
 * Decompiled with CFR 0.152.
 */
package org.gvt;

import cpath.client.PathwayCommonsIOHandler;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.pattern.util.Blacklist;
import org.cbio.causality.data.portal.CBioPortalAccessor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.gvt.ChsFileDragSourceListener;
import org.gvt.ChsFileDropTargetListener;
import org.gvt.PopupManager;
import org.gvt.ToolbarManager;
import org.gvt.TopMenuBar;
import org.gvt.action.ColorWithExperimentAction;
import org.gvt.action.DeleteAction;
import org.gvt.action.InspectorAction;
import org.gvt.action.LoadBioPaxModelAction;
import org.gvt.action.LoadExperimentDataAction;
import org.gvt.action.ZoomAction;
import org.gvt.editpart.ChsEditPartFactory;
import org.gvt.editpart.ChsScalableRootEditPart;
import org.gvt.figure.HighlightLayer;
import org.gvt.model.BioPAXGraph;
import org.gvt.model.CompoundModel;
import org.gvt.model.EntityAssociated;
import org.gvt.model.GraphObject;
import org.gvt.model.basicsif.BasicSIFGraph;
import org.gvt.model.biopaxl2.BioPAXL2Graph;
import org.gvt.model.biopaxl3.Actor;
import org.gvt.model.biopaxl3.BioPAXL3Graph;
import org.gvt.util.BioPAXUtil;
import org.gvt.util.PathwayHolder;
import org.patika.mada.dataXML.ChisioExperimentData;
import org.patika.mada.util.ExperimentDataManager;

public class ChisioMain
extends ApplicationWindow
implements MouseListener,
KeyListener,
MouseTrackListener {
    private CTabFolder tabFolder;
    private PopupManager popupManager;
    private KeyHandler keyHandler;
    private Set<String> openTabNames;
    private Map<CTabItem, ScrollingGraphicalViewer> tabToViewerMap;
    private Map<String, CTabItem> nameToTabMap;
    public static boolean transferNode = false;
    public static Color higlightColor;
    public boolean isClusterBoundShown = false;
    public static Combo zoomCombo;
    private String owlFileName;
    public Point clickLocation;
    private Map<String, ExperimentDataManager> dataManagerMap = new HashMap<String, ExperimentDataManager>();
    private Shell lockShell;
    private Model rootBioPAXModel;
    private boolean dirty;
    private Action firstAction;
    private Action secondAction;
    public static CBioPortalAccessor cBioPortalAccessor;
    public static final String TOOL_NAME = "Chisio BioPAX Editor";
    public static boolean runningOnWindows;

    public ChisioMain() {
        super((Shell)null);
    }

    @Override
    protected void handleShellCloseEvent() {
        if (LoadBioPaxModelAction.saveChangesBeforeDiscard(this)) {
            super.handleShellCloseEvent();
            for (Shell current : Display.getDefault().getShells()) {
                if (current.getText().indexOf("Properties") <= 0) continue;
                current.close();
            }
        }
    }

    public static void main(String[] args) throws InterruptedException, URISyntaxException, IOException {
        ChisioMain window = new ChisioMain();
        window.setBlockOnOpen(true);
        window.addMenuBar();
        window.addToolBar(0x820000);
        if (args.length > 0) {
            String filename = args[0];
            if (filename.endsWith(".owl")) {
                LoadBioPaxModelAction action = new LoadBioPaxModelAction(window, filename);
                window.firstAction = action;
            } else if (filename.matches("\\d*")) {
                try {
                    SimpleIOHandler reader = new SimpleIOHandler();
                    PathwayCommonsIOHandler pcIOHandler = new PathwayCommonsIOHandler(reader);
                    Model model = pcIOHandler.retrieveByID(filename);
                    LoadBioPaxModelAction action = new LoadBioPaxModelAction(window, model);
                    window.firstAction = action;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.err.println("Cannot load the specified pathway; CPATH_ID:" + filename);
                }
            }
        }
        if (args.length > 1) {
            LoadExperimentDataAction ledAction;
            String cedFilename = args[1];
            if (cedFilename.startsWith("http")) {
                URL cedUrl = new URL(cedFilename);
                ledAction = new LoadExperimentDataAction(window, cedUrl);
            } else {
                ledAction = new LoadExperimentDataAction(window, cedFilename);
            }
            window.secondAction = ledAction;
        }
        window.open();
        Display.getCurrent().dispose();
    }

    public Dimension getCurrentSize() {
        int w = this.getShell().getSize().x;
        int h = this.getShell().getSize().y;
        return new Dimension(w, h);
    }

    @Override
    protected Control createContents(Composite parent) {
        this.getShell().setText(TOOL_NAME);
        this.getShell().setSize(800, 600);
        this.getShell().setImage(ImageDescriptor.createFromFile(this.getClass(), "icon/cbe-icon.png").createImage());
        Composite compositeRoot = new Composite(parent, 2048);
        compositeRoot.setLayout(new FillLayout());
        this.tabFolder = new CTabFolder(compositeRoot, 0);
        this.tabFolder.setSimple(false);
        this.tabFolder.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                if (ChisioMain.this.getViewer() != null) {
                    ChisioMain.updateCombo(((ChsScalableRootEditPart)ChisioMain.this.getViewer().getRootEditPart()).getZoomManager().getZoomAsText());
                }
            }
        });
        this.openTabNames = new HashSet<String>();
        this.nameToTabMap = new HashMap<String, CTabItem>();
        this.tabToViewerMap = new HashMap<CTabItem, ScrollingGraphicalViewer>();
        this.popupManager = new PopupManager(this);
        this.popupManager.setRemoveAllWhenShown(true);
        this.popupManager.addMenuListener(new IMenuListener(){

            @Override
            public void menuAboutToShow(IMenuManager manager) {
                ChisioMain.this.popupManager.createActions(manager);
            }
        });
        this.keyHandler = new KeyHandler();
        ActionRegistry a = new ActionRegistry();
        this.keyHandler.put(KeyStroke.getPressed('\u007f', 127, 0), new DeleteAction(this));
        this.keyHandler.put(KeyStroke.getPressed('+', 16777259, 0), new ZoomAction(this, 1, null));
        this.keyHandler.put(KeyStroke.getPressed('-', 16777261, 0), new ZoomAction(this, -1, null));
        this.keyHandler.put(KeyStroke.getPressed(0x100000B, 0), a.getAction("org.eclipse.gef.direct_edit"));
        higlightColor = ColorConstants.yellow;
        this.createCombos();
        if (this.firstAction != null) {
            this.firstAction.run();
        }
        if (this.secondAction != null) {
            this.secondAction.run();
        }
        return compositeRoot;
    }

    public CTabItem createNewTab(CompoundModel root) {
        String name;
        assert (root != null);
        root.setAsRoot();
        if (root instanceof BioPAXGraph) {
            BioPAXGraph graph;
            graph.setName((graph = (BioPAXGraph)root).getPathway() != null ? graph.getPathway().getName() : this.adviceTabName(graph.getName()));
            name = graph.getName();
        } else {
            String nameCand = root.getText();
            name = this.adviceTabName(nameCand.trim().length() > 0 ? nameCand : null);
        }
        if (this.openTabNames.contains(name)) {
            return null;
        }
        CTabItem tab = new CTabItem(this.tabFolder, 0);
        Composite composite = new Composite(this.tabFolder, 0);
        composite.setLayout(new FillLayout());
        tab.setControl(composite);
        ScrollingGraphicalViewer viewer = new ScrollingGraphicalViewer();
        viewer.setEditDomain(new EditDomain());
        viewer.createControl(composite);
        viewer.getControl().setBackground(ColorConstants.white);
        ChsScalableRootEditPart rootEditPart = new ChsScalableRootEditPart();
        viewer.setRootEditPart(rootEditPart);
        viewer.setEditPartFactory(new ChsEditPartFactory());
        ((FigureCanvas)viewer.getControl()).setScrollBarVisibility(FigureCanvas.ALWAYS);
        viewer.addDropTargetListener(new ChsFileDropTargetListener((EditPartViewer)viewer, this));
        viewer.addDragSourceListener(new ChsFileDragSourceListener(viewer));
        tab.setText(name);
        viewer.setContents(root);
        viewer.getControl().addMouseListener(this);
        viewer.setKeyHandler(this.keyHandler);
        this.tabToViewerMap.put(tab, viewer);
        this.setSelectedTab(tab);
        this.openTabNames.add(name);
        this.nameToTabMap.put(name, tab);
        return tab;
    }

    public String adviceTabName(String candidate) {
        String name = candidate != null ? candidate : "Tab - " + Long.toString(System.currentTimeMillis()).substring(8);
        int i = 2;
        Set<String> existing = this.getAllPathwayNames();
        while (existing.contains(name)) {
            name = candidate + " (" + i++ + ")";
        }
        return name;
    }

    public CTabItem getSelectedTab() {
        if (this.tabFolder != null && this.tabFolder.getItemCount() > 0) {
            return this.tabFolder.getSelection();
        }
        return null;
    }

    public void setSelectedTab(CTabItem tab) {
        this.tabFolder.setSelection(tab);
    }

    public void closeTab(String tabName, boolean remmeberLayout) {
        assert (this.openTabNames.contains(tabName)) : "Tab close request with an unknown name:" + tabName;
        assert (this.nameToTabMap.containsKey(tabName)) : "Tab name not known: " + tabName;
        CTabItem tab = this.nameToTabMap.get(tabName);
        this.closeTab(tab, remmeberLayout);
    }

    public void closeTabIfNotBasicSIF(String tabName, boolean remmeberLayout) {
        assert (this.openTabNames.contains(tabName)) : "Tab close request with an unknown name:" + tabName;
        assert (this.nameToTabMap.containsKey(tabName)) : "Tab name not known: " + tabName;
        CTabItem tab = this.nameToTabMap.get(tabName);
        ScrollingGraphicalViewer viewer = this.tabToViewerMap.get(tab);
        CompoundModel root = (CompoundModel)viewer.getContents().getModel();
        if (root instanceof BasicSIFGraph) {
            return;
        }
        this.closeTab(tab, remmeberLayout);
    }

    public void closeTab(CTabItem tab, boolean rememberLayout) {
        ScrollingGraphicalViewer viewer = this.tabToViewerMap.get(tab);
        CompoundModel root = (CompoundModel)viewer.getContents().getModel();
        if (root instanceof BioPAXGraph) {
            BioPAXGraph graph = (BioPAXGraph)root;
            assert (graph.getName().equals(tab.getText())) : "graph name: " + graph.getName() + " tab name: " + tab.getText();
            if (rememberLayout && graph.isMechanistic()) {
                graph.recordLayout();
            }
        }
        boolean removed = this.openTabNames.remove(tab.getText());
        assert (removed) : "tab name: " + tab.getText();
        ScrollingGraphicalViewer v = this.tabToViewerMap.remove(tab);
        assert (v != null);
        CTabItem t = this.nameToTabMap.remove(tab.getText());
        assert (t != null);
        tab.dispose();
    }

    public void closeAllTabs(boolean rememberLayout) {
        for (CTabItem tab : this.tabFolder.getItems()) {
            this.closeTab(tab, rememberLayout);
        }
        assert (this.tabFolder.getItemCount() == 0);
        assert (this.tabToViewerMap.size() == 0);
        assert (this.nameToTabMap.size() == 0);
        assert (this.openTabNames.size() == 0);
    }

    public Map<CTabItem, ScrollingGraphicalViewer> getTabToViewerMap() {
        return this.tabToViewerMap;
    }

    public ScrollingGraphicalViewer getViewer() {
        CTabItem tab = this.getSelectedTab();
        if (tab != null) {
            return this.tabToViewerMap.get(tab);
        }
        return null;
    }

    public Set<String> getOpenTabNames() {
        return this.openTabNames;
    }

    public Set<String> getAllPathwayNames() {
        HashSet<String> names = new HashSet<String>();
        for (CTabItem cTabItem : this.tabToViewerMap.keySet()) {
            names.add(cTabItem.getText());
        }
        names.addAll(BioPAXUtil.getPathwayNames(this.rootBioPAXModel));
        return names;
    }

    public void renamePathway(CTabItem tab, String newName) {
        this.nameToTabMap.remove(tab.getText());
        this.openTabNames.remove(tab.getText());
        this.nameToTabMap.put(newName, tab);
        this.openTabNames.add(newName);
        Object compmod = this.tabToViewerMap.get(tab).getContents().getModel();
        if (compmod instanceof BioPAXGraph) {
            BioPAXGraph graph = (BioPAXGraph)compmod;
            graph.setName(newName);
        }
        tab.setText(newName);
        assert (this.nameToTabMap.size() == this.openTabNames.size());
    }

    public boolean isDirty() {
        if (this.dirty) {
            return true;
        }
        for (ScrollingGraphicalViewer viewer : this.tabToViewerMap.values()) {
            if (!viewer.getEditDomain().getCommandStack().isDirty()) continue;
            return true;
        }
        return false;
    }

    public void markSaved() {
        this.dirty = false;
        for (ScrollingGraphicalViewer viewer : this.tabToViewerMap.values()) {
            viewer.getEditDomain().getCommandStack().markSaveLocation();
        }
    }

    public void makeDirty() {
        this.dirty = true;
    }

    public void lockWithMessage(String msg) {
        System.out.println(msg);
        this.unlock();
        this.lockShell = new Shell(this.getShell(), 65536);
        this.lockShell.setLocation(this.getShell().getLocation());
        this.lockShell.setLayout(new GridLayout());
        StyledText txt = new StyledText(this.lockShell, 4);
        txt.setEditable(false);
        FontData fd = txt.getFont().getFontData()[0];
        fd.setHeight(fd.getHeight() + 2);
        fd.setStyle(1);
        Font font = new Font(null, new FontData[]{fd});
        txt.setFont(font);
        txt.setText(msg);
        Dimension extents = TextUtilities.INSTANCE.getStringExtents(msg, font);
        int buffer = 15;
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 64;
        data.widthHint = extents.width + buffer;
        data.heightHint = extents.height + buffer;
        data.horizontalIndent = buffer;
        data.verticalIndent = buffer;
        txt.setLayoutData(data);
        Color prgrssBgColor = new Color(null, 255, 247, 240);
        Color fgcolor = new Color(null, 90, 100, 90);
        this.lockShell.setBackground(prgrssBgColor);
        txt.setBackground(prgrssBgColor);
        txt.setForeground(fgcolor);
        txt.getCaret().setVisible(false);
        this.lockShell.pack();
        this.lockShell.setLocation(this.lockShell.getLocation().x + this.getShell().getBounds().width / 2 - msg.length() * fd.getHeight() / 2, this.lockShell.getLocation().y + this.getShell().getBounds().height / 2 - 50);
        this.lockShell.open();
        Display display = this.getShell().getDisplay();
        long time = System.currentTimeMillis();
        while (System.currentTimeMillis() - time < 50L) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void unlock() {
        if (this.lockShell != null) {
            this.lockShell.dispose();
            this.lockShell = null;
        }
    }

    public boolean isLevel2() {
        return this.getBioPAXModel() != null && this.getBioPAXModel().getLevel() == BioPAXLevel.L2;
    }

    public boolean isLevel3() {
        return this.getBioPAXModel() != null && this.getBioPAXModel().getLevel() == BioPAXLevel.L3;
    }

    @Override
    protected MenuManager createMenuManager() {
        return TopMenuBar.createBarMenu(this);
    }

    @Override
    protected ToolBarManager createToolBarManager(int style) {
        return new ToolbarManager(style, this);
    }

    @Override
    public void mouseDoubleClick(MouseEvent e) {
        InspectorAction inspectorAction = new InspectorAction(this, false);
        inspectorAction.run();
    }

    @Override
    public void mouseDown(MouseEvent e) {
        this.clickLocation = new Point(e.x, e.y);
        this.popupManager.setClickLocation(this.clickLocation);
        this.getViewer().getControl().setMenu(this.popupManager.createContextMenu(this.getViewer().getControl()));
    }

    @Override
    public void mouseUp(MouseEvent e) {
        this.clickLocation = new Point(e.x, e.y);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        transferNode = !transferNode;
        JOptionPane.showMessageDialog(null, "Transfer Mode: " + transferNode);
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void mouseEnter(MouseEvent e) {
    }

    @Override
    public void mouseExit(MouseEvent e) {
    }

    @Override
    public void mouseHover(MouseEvent e) {
    }

    public EditDomain getEditDomain() {
        ScrollingGraphicalViewer viewer = this.getViewer();
        if (viewer != null) {
            return viewer.getEditDomain();
        }
        return null;
    }

    public void createCombos() {
        ToolBar toolbar = this.getToolBarManager().getControl();
        ToolItem item = new ToolItem(toolbar, 2, 15);
        zoomCombo = new Combo(toolbar, 0);
        zoomCombo.add("2000%");
        zoomCombo.add("1000%");
        zoomCombo.add("500%");
        zoomCombo.add("150%");
        zoomCombo.add("100%");
        zoomCombo.add("75%");
        zoomCombo.add("50%");
        zoomCombo.add("25%");
        zoomCombo.pack();
        item.setWidth(ChisioMain.zoomCombo.getSize().x);
        item.setControl(zoomCombo);
        zoomCombo.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 13 && ChisioMain.this.getViewer() != null) {
                    ((ChsScalableRootEditPart)ChisioMain.this.getViewer().getRootEditPart()).getZoomManager().setZoomAsText(zoomCombo.getText());
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        zoomCombo.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                if (ChisioMain.this.getViewer() != null) {
                    ((ChsScalableRootEditPart)ChisioMain.this.getViewer().getRootEditPart()).getZoomManager().setZoomAsText(zoomCombo.getText());
                }
            }
        });
        if (this.getViewer() != null) {
            ChisioMain.updateCombo(((ChsScalableRootEditPart)this.getViewer().getRootEditPart()).getZoomManager().getZoomAsText());
        }
    }

    public static void updateCombo(String newValue) {
        zoomCombo.setText(newValue);
        zoomCombo.update();
    }

    public void setOwlFileName(String filename) {
        this.owlFileName = filename;
        String suffix = "";
        Model model = this.getBioPAXModel();
        if (model != null) {
            suffix = " (Level " + (model.getLevel() == BioPAXLevel.L3 ? "3" : "2") + ")";
        }
        suffix = suffix + " - Chisio BioPAX Editor";
        if (filename != null) {
            this.getShell().setText(filename + suffix);
        } else {
            this.getShell().setText(suffix);
        }
    }

    public String getOwlFileName() {
        return this.owlFileName;
    }

    public HighlightLayer getHighlightLayer() {
        HighlightLayer highlight = (HighlightLayer)((ChsScalableRootEditPart)this.getViewer().getRootEditPart()).getLayer("Highlight Layer");
        return highlight;
    }

    public Layer getHandleLayer() {
        Layer handle = (Layer)((ChsScalableRootEditPart)this.getViewer().getRootEditPart()).getLayer("Handle Layer");
        return handle;
    }

    public List<GraphObject> getSelectedModel() {
        if (this.getViewer() == null) {
            return null;
        }
        ArrayList<GraphObject> models = new ArrayList<GraphObject>();
        List parts = ((IStructuredSelection)this.getViewer().getSelection()).toList();
        for (Object partObj : parts) {
            EditPart ep = (EditPart)partObj;
            models.add((GraphObject)ep.getModel());
        }
        return models;
    }

    public Set<BioPAXElement> getSelectedBioPAXElements() {
        HashSet<BioPAXElement> set = new HashSet<BioPAXElement>();
        for (GraphObject go : this.getSelectedModel()) {
            if (!(go instanceof EntityAssociated)) continue;
            set.add(((EntityAssociated)((Object)go)).getEntity().getEntity());
        }
        return set;
    }

    public BioPAXGraph createAModelForView(PathwayHolder p) {
        if (p.l3p != null) {
            return new BioPAXL3Graph(this.rootBioPAXModel, p.l3p);
        }
        if (p.l2p != null) {
            return new BioPAXL2Graph(this.rootBioPAXModel, p.l2p);
        }
        return null;
    }

    public Model getBioPAXModel() {
        return this.rootBioPAXModel;
    }

    public void setBioPAXModel(Model model) {
        this.rootBioPAXModel = model;
    }

    public BioPAXGraph getPathwayGraph() {
        Object o;
        ScrollingGraphicalViewer viewer = this.getViewer();
        if (viewer != null && (o = viewer.getContents().getModel()) instanceof BioPAXGraph) {
            return (BioPAXGraph)o;
        }
        return null;
    }

    public List<BioPAXGraph> getAllPathwayGraphs() {
        ArrayList<BioPAXGraph> list = new ArrayList<BioPAXGraph>();
        for (CTabItem tab : this.tabFolder.getItems()) {
            Object o;
            ScrollingGraphicalViewer viewer = this.tabToViewerMap.get(tab);
            if (viewer == null || !((o = viewer.getContents().getModel()) instanceof BioPAXGraph)) continue;
            list.add((BioPAXGraph)o);
        }
        return list;
    }

    public void highlightIDs(Collection<String> ids) {
        BioPAXGraph graph = this.getPathwayGraph();
        if (graph == null) {
            return;
        }
        for (GraphObject o : graph.getGraphObjects()) {
            EntityAssociated ea;
            if (!(o instanceof EntityAssociated) || (ea = (EntityAssociated)((Object)o)).getEntity() == null || !ids.contains(ea.getEntity().getID())) continue;
            o.setHighlightColor(higlightColor);
            o.setHighlight(true);
        }
    }

    public Blacklist collectUbiqueIDs() {
        return Actor.getBlackList();
    }

    public boolean hasExperimentData(String type) {
        return this.dataManagerMap.containsKey(type) && this.dataManagerMap.get(type).isDataAvailable();
    }

    public void setExperimentData(ChisioExperimentData data, String fileLocation) {
        String type = data.getExperimentType();
        ExperimentDataManager man = new ExperimentDataManager(data, fileLocation);
        this.dataManagerMap.put(type, man);
        for (ScrollingGraphicalViewer viewer : this.tabToViewerMap.values()) {
            Object model = viewer.getContents().getModel();
            if (!(model instanceof BioPAXGraph)) continue;
            BioPAXGraph graph = (BioPAXGraph)model;
            man.clearExperimentData(graph);
            man.associateExperimentData(graph);
        }
    }

    public Set<String> getLoadedExperimentTypes() {
        return this.dataManagerMap.keySet();
    }

    public ExperimentDataManager getExperimentDataManager(String type) {
        return this.dataManagerMap.get(type);
    }

    public ChisioExperimentData getExperimentData(String type) {
        return this.dataManagerMap.get(type).getCed();
    }

    public void associateGraphWithExperimentData() {
        this.associateGraphWithExperimentData(this.getPathwayGraph());
    }

    public void associateGraphWithExperimentData(BioPAXGraph graph) {
        if (graph == null || this.dataManagerMap.keySet().isEmpty()) {
            return;
        }
        for (String type : this.dataManagerMap.keySet()) {
            ExperimentDataManager man = this.dataManagerMap.get(type);
            man.associateExperimentData(graph);
        }
        String type = graph.getLastAppliedColoring();
        if (type != null) {
            graph.setLastAppliedColoring(null);
            new ColorWithExperimentAction(this, graph, type).run();
        }
    }

    static {
        runningOnWindows = System.getProperty("os.name").startsWith("Windows");
    }
}

