/*
 * Decompiled with CFR 0.152.
 */
package org.gvt;

import java.util.Iterator;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.gvt.ChisioMain;
import org.gvt.command.ChsCompoundCommand;

public class ChsDragEditPartsTracker
extends DragEditPartsTracker {
    public ChsDragEditPartsTracker(EditPart sourceEditPart) {
        super(sourceEditPart);
    }

    @Override
    protected Command getCommand() {
        ChsCompoundCommand command = new ChsCompoundCommand();
        command.setDebugLabel("Drag Object Tracker");
        Iterator iter = this.getOperationSet().iterator();
        Request request = this.getTargetRequest();
        if (this.isCloneActive()) {
            request.setType("clone");
        } else if (this.isMove()) {
            request.setType("move");
        } else {
            request.setType("orphan");
        }
        if (!this.isCloneActive()) {
            while (iter.hasNext()) {
                EditPart editPart = (EditPart)iter.next();
                command.add(editPart.getCommand(request));
            }
        }
        if (ChisioMain.transferNode && (!this.isMove() || this.isCloneActive())) {
            if (!this.isCloneActive()) {
                request.setType("add children");
            }
            if (this.getTargetEditPart() == null) {
                command.add(UnexecutableCommand.INSTANCE);
            } else {
                command.add(this.getTargetEditPart().getCommand(this.getTargetRequest()));
            }
        }
        return command;
    }
}

