/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import org.biopax.paxtools.pattern.miner.SIFType;
import org.cbio.causality.analysis.Graph;
import org.cbio.causality.network.PathwayCommons;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.gvt.ChisioMain;
import org.gvt.action.CoSELayoutAction;
import org.gvt.gui.EnrichmentInSIFParameterDialog;
import org.gvt.model.basicsif.BasicSIFGraph;
import org.gvt.model.basicsif.BasicSIFNode;
import org.gvt.model.sifl3.SIFGraph;

public class FindEnrichedInPCSifAction
extends Action {
    private ChisioMain main;
    private List<SIFType> selectedRuleTypes;
    private String genesfile;
    private String backgroundFile;
    private Double fdr;

    public FindEnrichedInPCSifAction(ChisioMain main) {
        super("Search Enriched Network ...");
        this.setToolTipText(this.getText());
        this.main = main;
        this.selectedRuleTypes = new ArrayList<SIFType>();
    }

    public FindEnrichedInPCSifAction(ChisioMain main, String genesfile, String backgroundFile, List<SIFType> selectedRuleTypes) {
        this(main);
        this.backgroundFile = backgroundFile;
        this.genesfile = genesfile;
        this.selectedRuleTypes = selectedRuleTypes;
    }

    @Override
    public void run() {
        EnrichmentInSIFParameterDialog dialog = new EnrichmentInSIFParameterDialog(this.main.getShell(), SIFGraph.getPossibleRuleTypes(), this.selectedRuleTypes, this.genesfile, this.backgroundFile, this.fdr);
        if (dialog.open()) {
            this.backgroundFile = dialog.getBackgroundfile();
            this.genesfile = dialog.getGenefile();
            this.fdr = dialog.getFdr();
            Graph g = PathwayCommons.getGraph(this.selectedRuleTypes.toArray(new SIFType[this.selectedRuleTypes.size()]));
            Set<String> bg = null;
            if (this.backgroundFile != null) {
                bg = this.readFile(this.backgroundFile);
            }
            Set<String> query = this.readFile(this.genesfile);
            Graph.NeighborType nType = Graph.NeighborType.values()[dialog.getNeighTypeIndex()];
            List<String> enriched = g.getEnrichedGenes(query, bg, this.fdr, nType, 1);
            HashSet<String> set = new HashSet<String>(enriched);
            query.retainAll(nType == Graph.NeighborType.UPSTREAM ? g.getUpstream((Set<String>)set) : (nType == Graph.NeighborType.DOWNSTREAM ? g.getDownstream(set) : g.getNeighbors(set)));
            HashSet<String> result = new HashSet<String>(enriched);
            result.addAll(query);
            g.crop(result);
            BasicSIFGraph graph = new BasicSIFGraph(g);
            if (graph.getNodes().isEmpty()) {
                MessageDialog.openInformation(this.main.getShell(), "Graph empty!", "Loaded SIF file does not have any interaction of specified type.");
                return;
            }
            graph.setName("Enriched graph");
            graph.groupSimilarNodes();
            System.out.println("GOI has " + graph.getNodes().size() + " nodes and " + graph.getEdges().size() + " edges.");
            boolean cont = MessageDialog.openConfirm(this.main.getShell(), "Confirm", "GOI has " + graph.getNodes().size() + " nodes and " + graph.getEdges().size() + " edges. Layout?");
            if (cont) {
                this.main.createNewTab(graph);
                for (Object o : graph.getNodes()) {
                    BasicSIFNode node;
                    if (!(o instanceof BasicSIFNode) || !enriched.contains((node = (BasicSIFNode)o).getText())) continue;
                    node.setHighlightColor(ChisioMain.higlightColor);
                    node.setHighlight(true);
                }
                new CoSELayoutAction(this.main).run();
            }
        }
    }

    private Set<String> readFile(String filename) {
        try {
            HashSet<String> genes = new HashSet<String>();
            Scanner sc = new Scanner(new File(filename));
            while (sc.hasNextLine()) {
                String line = sc.nextLine();
                Collections.addAll(genes, line.split("\\s+"));
            }
            return genes;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

