/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.biopax.paxtools.pattern.miner.SIFType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.gvt.ChisioMain;
import org.gvt.action.CoSELayoutAction;
import org.gvt.gui.GOIofSIFParameterDialog;
import org.gvt.model.basicsif.BasicSIFGraph;
import org.gvt.model.basicsif.BasicSIFNode;
import org.gvt.model.sifl3.SIFGraph;
import org.gvt.util.SIFReader;
import org.patika.mada.algorithm.AlgoRunner;
import org.patika.mada.graph.GraphObject;
import org.patika.mada.graph.Node;
import org.patika.mada.util.XRef;

public class GOIofSIFAction
extends Action {
    private ChisioMain main;
    private List<SIFType> selectedRuleTypes;
    private String siffile;
    private String genesfile;
    private Integer limit;
    private Boolean directed;

    public GOIofSIFAction(ChisioMain main) {
        super("Paths-Between Query on SIF File ...");
        this.setToolTipText(this.getText());
        this.main = main;
        this.selectedRuleTypes = new ArrayList<SIFType>();
        this.limit = 1;
        this.directed = false;
    }

    public GOIofSIFAction(ChisioMain main, String siffile, String genesfile, List<SIFType> selectedRuleTypes) {
        this(main);
        this.siffile = siffile;
        this.genesfile = genesfile;
        this.selectedRuleTypes = selectedRuleTypes;
    }

    @Override
    public void run() {
        GOIofSIFParameterDialog dialog = new GOIofSIFParameterDialog(this.main.getShell(), SIFGraph.getPossibleRuleTypes(), this.selectedRuleTypes, this.siffile, this.genesfile, this.limit, this.directed);
        if (dialog.open()) {
            this.siffile = dialog.getSiffile();
            this.genesfile = dialog.getGenefile();
            this.limit = dialog.getLimit();
            this.directed = dialog.getDirected();
            SIFReader sifReader = new SIFReader(this.selectedRuleTypes);
            BasicSIFGraph graph = (BasicSIFGraph)sifReader.readXMLFile(new File(this.siffile));
            if (graph.getNodes().isEmpty()) {
                MessageDialog.openInformation(this.main.getShell(), "Graph empty!", "Loaded SIF file does not have any interaction of specified type.");
                return;
            }
            HashSet<XRef> refs = new HashSet<XRef>();
            try {
                Object line;
                BufferedReader reader = new BufferedReader(new FileReader(this.genesfile));
                while ((line = reader.readLine()) != null) {
                    if (((String)line).startsWith("#")) continue;
                    for (String string : ((String)line).split(" ")) {
                        refs.add(new XRef("name:" + string));
                    }
                }
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (refs.isEmpty()) {
                MessageDialog.openInformation(this.main.getShell(), "No reference for genes-of-interest!", "Genes-of-interest file does not contain any references.");
                return;
            }
            HashSet<Node> seed = new HashSet<Node>();
            block4: for (Object o : graph.getNodes()) {
                Node node = (Node)o;
                for (XRef xRef : node.getReferences()) {
                    if (!refs.contains(xRef)) continue;
                    seed.add(node);
                    continue block4;
                }
            }
            if (seed.isEmpty()) {
                MessageDialog.openInformation(this.main.getShell(), "No genes-of-interest!", "Loaded references do not match any genes in the loaded SIF file.");
                return;
            }
            System.out.println("Nmber of genes of interest = " + seed.size());
            Collection<GraphObject> graphObjects = AlgoRunner.searchPathsBetweenSIF(seed, this.limit, this.directed, 0, true);
            HashSet<String> rdfseed = new HashSet<String>();
            for (Node node : seed) {
                rdfseed.add(((BasicSIFNode)node).getRdfid());
            }
            BasicSIFGraph goi = (BasicSIFGraph)graph.excise((Collection)graphObjects, true);
            goi.setName("Paths between nodes in SIF");
            System.out.println("GOI has " + goi.getNodes().size() + " nodes and " + goi.getEdges().size() + " edges.");
            boolean cont = MessageDialog.openConfirm(this.main.getShell(), "Confirm", "GOI has " + goi.getNodes().size() + " nodes and " + goi.getEdges().size() + " edges. Layout?");
            if (cont) {
                this.main.createNewTab(goi);
                for (Object o : goi.getNodes()) {
                    BasicSIFNode node;
                    if (!(o instanceof BasicSIFNode) || !rdfseed.contains((node = (BasicSIFNode)o).getRdfid())) continue;
                    node.setHighlightColor(ChisioMain.higlightColor);
                    node.setHighlight(true);
                }
                new CoSELayoutAction(this.main).run();
            }
        }
    }
}

