/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.gvt.ChisioMain;
import org.gvt.gui.ItemSelectionDialog;
import org.gvt.gui.ItemSelectionRunnable;
import org.gvt.model.BioPAXGraph;
import org.patika.mada.algorithm.AlgoRunner;
import org.patika.mada.graph.Node;
import org.patika.mada.util.Path;

public class HighlightPathsBetweenSelectedAction
extends Action {
    private ChisioMain main;
    private Map<String, Path> idMap;

    public HighlightPathsBetweenSelectedAction(ChisioMain main) {
        super("Highlight Paths Between Selected");
        this.setToolTipText(this.getText());
        this.main = main;
    }

    @Override
    public void run() {
        if (this.main.getViewer() == null) {
            return;
        }
        BioPAXGraph graph = this.main.getPathwayGraph();
        if (graph == null) {
            MessageDialog.openError(this.main.getShell(), "Not applicable!", "This feature works only for process views.");
            return;
        }
        ArrayList<Node> selectedNodes = new ArrayList<Node>();
        ScrollingGraphicalViewer viewer = this.main.getViewer();
        if (viewer == null) {
            return;
        }
        Iterator selectedObjects = ((IStructuredSelection)viewer.getSelection()).iterator();
        while (selectedObjects.hasNext()) {
            Object model = ((EditPart)selectedObjects.next()).getModel();
            if (!(model instanceof Node)) continue;
            selectedNodes.add((Node)model);
        }
        int limit = 10;
        Map<Node, Map<Integer, List<Path>>> allMap = AlgoRunner.searchPathsBetween(graph, selectedNodes, limit);
        ArrayList<String> pathIDs = new ArrayList<String>();
        this.idMap = new HashMap<String, Path>();
        for (Node target : allMap.keySet()) {
            Map<Integer, List<Path>> pathsMap = allMap.get(target);
            if (pathsMap == null) continue;
            for (int i = 1; i <= limit; ++i) {
                List<Path> pathList = pathsMap.get(i);
                if (pathList == null) continue;
                for (Path path : pathList) {
                    String id = path.toString();
                    if (pathIDs.contains(id)) {
                        String nextID;
                        int j = 2;
                        while (pathIDs.contains(nextID = id + " (" + j++ + ")")) {
                        }
                        id = nextID;
                    }
                    pathIDs.add(id);
                    this.idMap.put(id, path);
                }
            }
        }
        if (!pathIDs.isEmpty()) {
            ItemSelectionDialog dialog = new ItemSelectionDialog(this.main.getShell(), 250, "Path Selection Dialog", "Select path to visualize", pathIDs, new ArrayList(), false, false, new Runner());
            dialog.setUpdateUponSelection(true);
            Object object = dialog.open();
        } else {
            MessageDialog.openInformation(this.main.getShell(), "No results!", "No directed paths found between selected nodes.");
        }
    }

    private class Runner
    implements ItemSelectionRunnable {
        private String lastID;

        private Runner() {
        }

        @Override
        public void run(Collection selectedTerms) {
            if (selectedTerms.isEmpty()) {
                return;
            }
            String id = selectedTerms.iterator().next().toString();
            this.run(id);
        }

        public void run(String id) {
            if (id.equals(this.lastID)) {
                return;
            }
            if (this.lastID != null) {
                ((Path)HighlightPathsBetweenSelectedAction.this.idMap.get(this.lastID)).highlight(false);
            }
            if (id.equals("None")) {
                this.lastID = null;
                return;
            }
            ((Path)HighlightPathsBetweenSelectedAction.this.idMap.get(id)).highlight(true);
            this.lastID = id;
        }
    }
}

