/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Dialog;
import org.gvt.ChisioMain;
import org.gvt.action.CoSELayoutAction;
import org.gvt.action.HideCompartmentsAction;
import org.gvt.action.HighlightWithRefAction;
import org.gvt.gui.ItemSelectionDialog;
import org.gvt.gui.PathwaySelectionDialog;
import org.gvt.model.BioPAXGraph;
import org.gvt.model.CompoundModel;
import org.gvt.util.BioPAXUtil;
import org.gvt.util.Conf;
import org.gvt.util.PathwayHolder;
import org.patika.mada.util.XRef;

public class OpenPathwaysAction
extends Action {
    private ChisioMain main;
    private List<String> pathways;
    private Collection<XRef> refsToHighlight;

    public OpenPathwaysAction(ChisioMain main) {
        super("Open Pathway ...");
        this.setToolTipText(this.getText());
        this.setImageDescriptor(ImageDescriptor.createFromFile(ChisioMain.class, "icon/pathway-open.png"));
        this.main = main;
    }

    public OpenPathwaysAction(ChisioMain main, List<String> pathways) {
        this(main);
        this.pathways = new ArrayList<String>();
        if (pathways != null) {
            this.pathways.addAll(pathways);
        }
    }

    public OpenPathwaysAction(ChisioMain main, String pathwayName) {
        this(main, (List<String>)null);
        this.pathways.add(pathwayName);
    }

    @Override
    public void run() {
        Model model = this.main.getBioPAXModel();
        if (model == null) {
            MessageDialog.openError(this.main.getShell(), "Error!", "Load or query a BioPAX model first.");
            return;
        }
        ArrayList<String> allNames = new ArrayList<String>(this.main.getAllPathwayNames());
        Map<String, PathwayHolder> nameToPathwayMap = BioPAXUtil.getNameToPathwayMap(model);
        if (allNames.isEmpty()) {
            String message = model.getObjects().isEmpty() ? "BioPAX model is empty!" : "There is no pathway defined in this BioPAX model.\nYou can create one using \"Pathway > Create\" menu.";
            MessageDialog.openInformation(this.main.getShell(), "No Pathway!", message);
            return;
        }
        if (this.pathways != null) {
            this.pathways.retainAll(allNames);
        } else {
            Dialog dialog;
            this.pathways = new ArrayList<String>();
            this.pathways.addAll(this.main.getOpenTabNames());
            if (model.getLevel() == BioPAXLevel.L2) {
                dialog = new ItemSelectionDialog(this.main.getShell(), 500, "Pathway Selection Dialog", "Select pathways to view", allNames, this.pathways, true, true, null);
                ((ItemSelectionDialog)dialog).open();
                if (((ItemSelectionDialog)dialog).isCancelled()) {
                    this.pathways = null;
                    return;
                }
            } else {
                dialog = new PathwaySelectionDialog(this.main.getShell(), model, this.pathways);
                ((PathwaySelectionDialog)dialog).open();
                if (((PathwaySelectionDialog)dialog).isCancelled()) {
                    this.pathways = null;
                    return;
                }
            }
        }
        if (this.pathways != null) {
            for (String name : new ArrayList<String>(this.main.getOpenTabNames())) {
                if (!this.pathways.contains(name)) {
                    this.main.closeTabIfNotBasicSIF(name, true);
                    continue;
                }
                this.pathways.remove(name);
            }
        }
        if (!this.pathways.isEmpty()) {
            for (String name : this.pathways) {
                this.openPathwayInTab(nameToPathwayMap.get(name));
            }
        }
        this.pathways = null;
    }

    private void openPathwayInTab(PathwayHolder p) {
        ScrollingGraphicalViewer viewer;
        CompoundModel root;
        assert (p != null);
        BioPAXGraph graph = BioPAXGraph.newInstance(this.main.getBioPAXModel(), p);
        boolean layedout = graph.fetchLayout();
        CTabItem tab = this.main.createNewTab(graph);
        if (this.refsToHighlight != null && !this.refsToHighlight.isEmpty() && (root = (CompoundModel)(viewer = this.main.getTabToViewerMap().get(tab)).getContents().getModel()) instanceof BioPAXGraph) {
            new HighlightWithRefAction(this.main, (BioPAXGraph)root, this.refsToHighlight).run();
        }
        if ((double)graph.getEdges().size() > Conf.getNumber("HIDE_COMPARTMENT_EDGE_THRESHOLD")) {
            new HideCompartmentsAction(this.main).run();
        }
        if (!layedout) {
            new CoSELayoutAction(this.main).run();
        }
    }

    public Collection<XRef> getRefsToHighlight() {
        return this.refsToHighlight;
    }

    public void setRefsToHighlight(Collection<XRef> refsToHighlight) {
        this.refsToHighlight = refsToHighlight;
    }
}

