/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import cpath.client.CPathClient;
import cpath.client.util.CPathException;
import cpath.query.CPathGetQuery;
import cpath.query.CPathGraphQuery;
import cpath.query.CPathSearchQuery;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.biopax.paxtools.controller.Cloner;
import org.biopax.paxtools.controller.Completer;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.RelationshipXref;
import org.biopax.paxtools.pattern.miner.SIFType;
import org.cbio.causality.network.PathwayCommons;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.gvt.ChisioMain;
import org.gvt.action.ChiBEAction;
import org.gvt.action.CoSELayoutAction;
import org.gvt.action.FileChooser;
import org.gvt.action.HighlightWithEntityIDAction;
import org.gvt.action.HighlightWithRefAction;
import org.gvt.action.LoadBioPaxModelAction;
import org.gvt.action.MergeAction;
import org.gvt.gui.AbstractQueryParamDialog;
import org.gvt.model.EntityAssociated;
import org.gvt.model.GraphObject;
import org.gvt.model.NodeModel;
import org.gvt.model.basicsif.BasicSIFEdge;
import org.gvt.model.basicsif.BasicSIFGraph;
import org.gvt.model.basicsif.BasicSIFGroup;
import org.gvt.model.basicsif.BasicSIFNode;
import org.gvt.model.sifl3.SIFEdge;
import org.gvt.model.sifl3.SIFGroup;
import org.gvt.util.Conf;
import org.gvt.util.QueryOptionsPack;
import org.patika.mada.graph.Graph;
import org.patika.mada.graph.Node;
import org.patika.mada.util.XRef;

public abstract class QueryPCAction
extends ChiBEAction {
    protected boolean useSelected;
    protected boolean ignoreIDsOfSelectedNodes;
    protected QueryOptionsPack options = new QueryOptionsPack();
    protected boolean increaseLimitIfNoResult;
    protected String newPathwayName;
    protected String openPathwayName;
    protected QueryLocation queryLoc;
    protected String localFilename;
    protected boolean createNewPathwayForView;

    public QueryPCAction(ChisioMain main, String text, boolean useSelected, QueryLocation qLoc) {
        super(text, "icon/query-neighbors.png", main);
        this.useSelected = useSelected;
        this.queryLoc = qLoc;
        this.increaseLimitIfNoResult = false;
        this.addFilterExtension("FILE_KEY", new String[]{this.queryLoc == QueryLocation.FILE_MECH ? "*.owl" : "*.sif"});
        this.addFilterName("FILE_KEY", new String[]{this.queryLoc == QueryLocation.FILE_MECH ? "BioPAX File (*.owl)" : "Simple Interaction File (*.sif)"});
        this.createNewPathwayForView = true;
    }

    public void setCreateNewPathwayForView(boolean createNewPathwayForView) {
        this.createNewPathwayForView = createNewPathwayForView;
    }

    public boolean isIncreaseLimitIfNoResult() {
        return this.increaseLimitIfNoResult;
    }

    public void setNewPathwayName(String newPathwayName) {
        this.newPathwayName = newPathwayName;
    }

    public void setOpenPathwayName(String openPathwayName) {
        this.openPathwayName = openPathwayName;
    }

    public void setIncreaseLimitIfNoResult(boolean increaseLimitIfNoResult) {
        this.increaseLimitIfNoResult = increaseLimitIfNoResult;
    }

    public void setIgnoreIDsOfSelectedNodes(boolean ignoreIDsOfSelectedNodes) {
        this.ignoreIDsOfSelectedNodes = ignoreIDsOfSelectedNodes;
    }

    public void execute() {
        if (this.queryLoc.isFile() && this.localFilename == null) {
            this.localFilename = new FileChooser(this).choose("FILE_KEY");
            if (this.localFilename == null) {
                return;
            }
        }
        if (this.main.getBioPAXModel() == null || this.main.getBioPAXModel().getLevel().equals((Object)BioPAXLevel.L3)) {
            try {
                if (!(this.useSelected && this.setSelectedPEIDsAsSource() || this.showParameterDialog())) {
                    return;
                }
                if (!this.canQuery()) {
                    return;
                }
                this.main.lockWithMessage("Querying Pathway Commons ...");
                if (this.queryLoc.isSIF()) {
                    this.doSIFQuery();
                }
                this.doMechanisticQuery();
            }
            catch (Exception e) {
                if (e instanceof CPathException || e.getCause() instanceof CPathException) {
                    this.alertNoResults();
                }
                e.printStackTrace();
                MessageDialog.openError(this.main.getShell(), "Error", "An error occurred during querying:\n" + e.getMessage());
            }
            finally {
                this.main.unlock();
                this.localFilename = null;
            }
        } else {
            MessageDialog.openError(this.main.getShell(), "Incompatible Levels", "This query is only applicable to Level 3 models.");
        }
    }

    private void doSIFQuery() throws CPathException {
        BasicSIFGraph goi = null;
        if (this.queryLoc.isFile()) {
            org.cbio.causality.analysis.Graph g = new org.cbio.causality.analysis.Graph("Local sif file", this.options.getSifTypes().iterator().next().getTag());
            List<SIFType> sifTypes = this.options.getSifTypes();
            Iterator<String> undirected = new HashSet();
            HashSet<String> directed = new HashSet<String>();
            for (SIFType sifType : sifTypes) {
                if (sifType.isDirected()) {
                    directed.add(sifType.getTag());
                    continue;
                }
                undirected.add(sifType.getTag());
            }
            g.load(this.localFilename, (Set<String>)((Object)undirected), directed);
            BasicSIFGraph graph = new BasicSIFGraph(g, false);
            Collection<org.patika.mada.graph.GraphObject> gos = this.doSIFQuery(graph);
            if (gos.isEmpty()) {
                this.alertNoResults();
                return;
            }
            goi = (BasicSIFGraph)graph.excise((Collection)gos, true);
        } else {
            String base = "http://www.pathwaycommons.org/sifgraph/v1/";
            String url = base + this.getSIFQueryType() + "?directed=true&direction=";
            if (this.options.isDownstream()) {
                url = this.options.isUpstream() ? url + "BOTHSTREAM" : url + "DOWNSTREAM";
            } else if (this.options.isUpstream()) {
                url = url + "UPSTREAM";
            }
            for (SIFType type : this.options.getSifTypes()) {
                url = url + "&pattern=" + type.getTag().toUpperCase().replaceAll("-", "_");
            }
            url = url + "&limit=" + this.options.getLengthLimit();
            for (String source : this.options.getSourceList()) {
                url = url + "&source=" + source;
            }
            if (this.options.getTargetList() != null) {
                for (String target : this.options.getTargetList()) {
                    url = url + "&target=" + target;
                }
            }
            try {
                System.out.println("url = " + url);
                goi = new BasicSIFGraph(new URL(url).openStream(), 6);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        goi.replaceChEBIIDsWithNames();
        goi.setName(this.getNewPathwayName());
        goi.setAsRoot();
        this.main.createNewTab(goi);
        new CoSELayoutAction(this.main).run();
        if (this.highlightSeed()) {
            HashSet<String> seed = new HashSet<String>(this.options.getConvertedSourceList());
            seed.addAll(this.options.getConvertedTargetList());
            for (Object o : goi.getNodes()) {
                NodeModel node = (NodeModel)o;
                if (!seed.contains(node.getText())) continue;
                node.setHighlight(true);
            }
        }
    }

    protected abstract String getSIFQueryType();

    protected boolean highlightSeed() {
        return this.options.getLengthLimit() > 1;
    }

    private void doMechanisticQuery() throws CPathException {
        Model model = this.queryLoc == QueryLocation.FILE_MECH ? this.doFileQuery(this.localFilename) : this.doQuery();
        if (model == null && this.increaseLimitIfNoResult) {
            this.options.setLengthLimit(this.options.getLengthLimit() + 1);
            model = this.doQuery();
        }
        this.main.unlock();
        if (model != null) {
            if (this.containsOnlyAnEmptyPathway(model)) {
                this.alertEmptyPathway();
            } else if (!model.getObjects().isEmpty()) {
                if (this.main.getBioPAXModel() != null) {
                    MergeAction merge = new MergeAction(this.main, model);
                    merge.setOpenPathways(true);
                    merge.setCreateNewPathway(this.createNewPathwayForView);
                    if (this.createNewPathwayForView) {
                        merge.setNewPathwayName(this.getNewPathwayName());
                    } else if (this.openPathwayName != null) {
                        merge.setNameOfPathwayToOpen(this.openPathwayName);
                    }
                    merge.updatePathways = false;
                    merge.run();
                } else {
                    LoadBioPaxModelAction load = new LoadBioPaxModelAction(this.main, model);
                    load.setOpenPathways(true);
                    if (this.createNewPathwayForView) {
                        load.setNewPathwayName(this.getNewPathwayName());
                    } else if (this.openPathwayName != null) {
                        load.setOpenPathwayName(this.openPathwayName);
                    }
                    load.run();
                }
                if (this.main.getPathwayGraph() != null) {
                    HashSet<String> st = new HashSet<String>();
                    if (this.options.getSourceList() != null) {
                        st.addAll(this.options.getSourceList());
                    }
                    if (this.options.getTargetList() != null) {
                        st.addAll(this.options.getTargetList());
                    }
                    if (this.options.isUseID()) {
                        HighlightWithEntityIDAction hac = new HighlightWithEntityIDAction(this.main, this.main.getPathwayGraph(), st);
                        hac.run();
                    } else {
                        HashSet<XRef> refSet = new HashSet<XRef>();
                        for (String name : st) {
                            refSet.add(new XRef("Name", name));
                        }
                        HighlightWithRefAction hac = new HighlightWithRefAction(this.main, this.main.getPathwayGraph(), refSet);
                        hac.run();
                    }
                }
            } else {
                this.alertNoResults();
            }
        } else {
            this.alertNoResults();
        }
    }

    protected boolean containsOnlyAnEmptyPathway(Model model) {
        return !model.getObjects(Pathway.class).isEmpty() && model.getObjects(Interaction.class).isEmpty();
    }

    protected String getNewPathwayName() {
        if (this.newPathwayName == null) {
            return this.getText();
        }
        return this.newPathwayName;
    }

    protected void alertNoResults() {
        MessageDialog.openInformation(this.main.getShell(), "Empty result set", "No results found!");
    }

    protected void alertEmptyPathway() {
        MessageDialog.openInformation(this.main.getShell(), "Empty pathway", "The pathway has no content.");
    }

    protected abstract Model doQuery() throws CPathException;

    protected abstract Collection<org.patika.mada.graph.GraphObject> doSIFQuery(BasicSIFGraph var1) throws CPathException;

    protected abstract AbstractQueryParamDialog getDialog();

    protected abstract boolean canQuery();

    protected boolean showParameterDialog() {
        this.options.clearUnknownSymbols();
        AbstractQueryParamDialog dialog = this.getDialog();
        if (dialog == null) {
            return true;
        }
        this.options = dialog.open(this.options);
        if (this.options.isCancel()) {
            return false;
        }
        this.options.setCancel(true);
        return true;
    }

    protected boolean modelHasNonEmptyPathway(Model model) {
        for (Pathway p : model.getObjects(Pathway.class)) {
            if (p.getPathwayComponent().isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected Set<GraphObject> getSelectedObjects() {
        HashSet<GraphObject> selected = new HashSet<GraphObject>();
        ScrollingGraphicalViewer viewer = this.main.getViewer();
        Iterator selectedObjects = ((IStructuredSelection)viewer.getSelection()).iterator();
        while (selectedObjects.hasNext()) {
            Object o = ((EditPart)selectedObjects.next()).getModel();
            if (!(o instanceof GraphObject)) continue;
            selected.add((GraphObject)o);
        }
        return selected;
    }

    protected boolean setSelectedPEIDsAsSource() {
        HashSet<String> set = new HashSet<String>();
        Set<GraphObject> selectedObjects = this.getSelectedObjects();
        for (GraphObject nm : selectedObjects) {
            if (nm instanceof BasicSIFEdge) {
                set.addAll(((BasicSIFEdge)nm).getMediators(selectedObjects));
                continue;
            }
            if (nm instanceof SIFEdge) {
                set.addAll(((SIFEdge)nm).getMediators(selectedObjects));
                continue;
            }
            if (nm instanceof BasicSIFGroup) {
                set.addAll(((BasicSIFGroup)nm).getMediators(selectedObjects));
                continue;
            }
            if (nm instanceof SIFGroup) {
                set.addAll(((SIFGroup)nm).getMediators(selectedObjects));
                continue;
            }
            if (!(!(nm instanceof EntityAssociated) || nm instanceof NodeModel && this.ignoreIDsOfSelectedNodes)) {
                set.add(((EntityAssociated)((Object)nm)).getEntity().getID());
                continue;
            }
            if (!(nm instanceof BasicSIFNode) || this.ignoreIDsOfSelectedNodes) continue;
            set.add(nm.getText());
        }
        this.options.setSourceList(new ArrayList<String>(set));
        this.options.setUseID(true);
        return !this.options.getSourceList().isEmpty();
    }

    protected CPathClient getPCClient() {
        System.setProperty("cPath2Url", Conf.get("PATHWAY_COMMONS_URL"));
        CPathClient pc2 = CPathClient.newInstance();
        return pc2;
    }

    protected CPathGraphQuery getPCGraphQuery() {
        CPathClient client = this.getPCClient();
        CPathGraphQuery query = client.createGraphQuery();
        return query;
    }

    protected CPathSearchQuery getPCSearchQuery() {
        CPathClient client = this.getPCClient();
        CPathSearchQuery query = client.createSearchQuery();
        return query;
    }

    protected CPathGetQuery getPCGetQuery() {
        CPathClient client = this.getPCClient();
        CPathGetQuery query = client.createGetQuery();
        return query;
    }

    protected void warnForUnknownSymbols(List<String> unknown) {
        if (unknown != null && unknown.size() > 0) {
            String s = "Unknown symbol";
            if (unknown.size() > 1) {
                s = s + "s";
            }
            s = s + ":";
            for (String un : unknown) {
                s = s + "  \"" + un + "\"";
            }
            MessageDialog.openWarning(this.main.getShell(), "Some symbols are unfamiliar", s);
        }
    }

    protected void warnForLowInput(int required, int found) {
        MessageDialog.openWarning(this.main.getShell(), "Need more input", "Query needs at least " + required + " entities. Currently only " + found + " is recognized.");
    }

    protected Set<BioPAXElement> findRelatedReferences(Model model, Collection<String> symbols) {
        HashSet<BioPAXElement> set = new HashSet<BioPAXElement>();
        for (RelationshipXref xref2 : model.getObjects(RelationshipXref.class)) {
            if (!symbols.contains(xref2.getId())) continue;
            set.add(xref2);
        }
        return set;
    }

    protected Model excise(Model model, Set<BioPAXElement> result) {
        Completer c = new Completer(SimpleEditorMap.L3);
        result = c.complete(result, model);
        Cloner cln = new Cloner(SimpleEditorMap.L3, BioPAXLevel.L3.getDefaultFactory());
        return cln.clone(model, result);
    }

    protected Model doFileQuery(String filename) {
        try {
            SimpleIOHandler handler = new SimpleIOHandler();
            Model model = handler.convertFromOWL(new FileInputStream(filename));
            Set<BioPAXElement> results = this.doFileQuery(model);
            return this.excise(model, results);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected abstract Set<BioPAXElement> doFileQuery(Model var1);

    protected Set<BioPAXElement> findInFile(Model model, Set<String> ids) {
        HashSet<BioPAXElement> result = new HashSet<BioPAXElement>();
        for (String id : ids) {
            BioPAXElement element = model.getByID(id);
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }

    public void setLocalFilename(String localFilename) {
        this.localFilename = localFilename;
    }

    public static BasicSIFGraph getPCGraph(List<? extends SIFType> types) {
        return new BasicSIFGraph(PathwayCommons.getGraph(types.toArray(new SIFType[types.size()])));
    }

    public static Set<Node> getSeed(Graph graph, Collection<String> symbols) {
        HashSet<Node> seed = new HashSet<Node>();
        for (Node node : graph.getNodes()) {
            if (!symbols.contains(node.getName())) continue;
            seed.add(node);
        }
        return seed;
    }

    public static enum QueryLocation {
        PC_MECH,
        PC_SIF,
        FILE_MECH,
        FILE_SIF;


        boolean isFile() {
            return this == FILE_MECH || this == FILE_SIF;
        }

        boolean isSIF() {
            return this == FILE_SIF || this == PC_SIF;
        }
    }
}

