/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import cpath.client.util.CPathException;
import cpath.service.GraphType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.query.QueryExecuter;
import org.biopax.paxtools.query.wrapperL3.Filter;
import org.gvt.ChisioMain;
import org.gvt.action.QueryPCAction;
import org.gvt.gui.AbstractQueryParamDialog;
import org.gvt.gui.GoIQueryParamWithEntitiesDialog;
import org.gvt.model.basicsif.BasicSIFGraph;
import org.patika.mada.algorithm.AlgoRunner;
import org.patika.mada.graph.GraphObject;

public class QueryPCPathsBetweenAction
extends QueryPCAction {
    private String[] symbols;

    public QueryPCPathsBetweenAction(ChisioMain main, QueryPCAction.QueryLocation qLoc, String ... symbols) {
        super(main, "Paths Between ...", false, qLoc);
        if (symbols.length > 1) {
            this.symbols = symbols;
            String text = "Paths Between " + symbols[0];
            for (int i = 1; i < symbols.length; ++i) {
                text = text + " and " + symbols[i];
            }
            this.setText(text);
        }
    }

    public QueryPCPathsBetweenAction(ChisioMain main, boolean useSelected, QueryPCAction.QueryLocation qLoc) {
        super(main, "Paths Between ...", useSelected, qLoc);
    }

    @Override
    public void run() {
        this.execute();
    }

    @Override
    protected Model doQuery() throws CPathException {
        List<String> sourceSymbols = this.options.getConvertedSourceList();
        return this.getPCGraphQuery().kind(GraphType.PATHSBETWEEN).sources(sourceSymbols).limit(this.options.getLengthLimit()).result();
    }

    @Override
    protected Set<BioPAXElement> doFileQuery(Model model) {
        List<String> symbols = this.options.getConvertedSourceList();
        Set<BioPAXElement> source = this.findRelatedReferences(model, symbols);
        return QueryExecuter.runPathsBetween(source, model, this.options.getLengthLimit(), new Filter[0]);
    }

    @Override
    protected Collection<GraphObject> doSIFQuery(BasicSIFGraph graph) throws CPathException {
        return AlgoRunner.searchPathsBetweenSIF(QueryPCPathsBetweenAction.getSeed(graph, this.options.getConvertedSourceList()), this.options.getLengthLimit(), !this.options.undirectedSIFTypeSelected(), this.options.getLimitType() ? -1 : this.options.getShortestPlusKLimit(), this.options.isStrict());
    }

    @Override
    protected AbstractQueryParamDialog getDialog() {
        if (this.symbols == null || this.symbols.length < 2) {
            return new GoIQueryParamWithEntitiesDialog(this.main, this.queryLoc.isSIF());
        }
        this.options.setSourceList(Arrays.asList(this.symbols));
        this.options.setLengthLimit(1);
        return null;
    }

    @Override
    protected boolean canQuery() {
        List<String> sourceSymbols = this.options.getConvertedSourceList();
        this.warnForUnknownSymbols(this.options.getUnknownSymbols());
        if (sourceSymbols.size() < 2) {
            this.warnForLowInput(2, sourceSymbols.size());
        }
        return sourceSymbols.size() > 1;
    }

    @Override
    protected String getSIFQueryType() {
        return "pathsbetween";
    }

    @Override
    protected String getNewPathwayName() {
        if (this.newPathwayName != null) {
            return super.getNewPathwayName();
        }
        if (this.symbols != null) {
            assert (this.symbols.length > 1);
            String s = this.symbols[0];
            for (int i = 1; i < this.symbols.length; ++i) {
                s = s + " -- " + this.symbols[i];
            }
            return s;
        }
        return super.getNewPathwayName();
    }
}

