/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import cpath.client.util.CPathException;
import cpath.service.GraphType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.query.QueryExecuter;
import org.biopax.paxtools.query.algorithm.LimitType;
import org.biopax.paxtools.query.wrapperL3.Filter;
import org.gvt.ChisioMain;
import org.gvt.action.QueryPCAction;
import org.gvt.gui.AbstractQueryParamDialog;
import org.gvt.gui.PoIQueryParamWithEntitiesDialog;
import org.gvt.model.basicsif.BasicSIFGraph;
import org.patika.mada.algorithm.AlgoRunner;
import org.patika.mada.graph.GraphObject;

public class QueryPCPathsFromToAction
extends QueryPCAction {
    private String fromSymbol;
    private String toSymbol;

    public QueryPCPathsFromToAction(ChisioMain main, QueryPCAction.QueryLocation qLoc) {
        super(main, "Paths From To ...", false, qLoc);
    }

    public QueryPCPathsFromToAction(ChisioMain main, String fromSymbol, String toSymbol, QueryPCAction.QueryLocation qLoc) {
        super(main, "Paths from " + fromSymbol + " to " + toSymbol, false, qLoc);
        this.fromSymbol = fromSymbol;
        this.toSymbol = toSymbol;
    }

    @Override
    public void run() {
        this.execute();
    }

    @Override
    protected Model doQuery() throws CPathException {
        List<String> sourceSymbols = this.options.getConvertedSourceList();
        List<String> targetSymbols = this.options.getConvertedTargetList();
        return this.getPCGraphQuery().limit(this.options.getLengthLimit()).kind(GraphType.PATHSFROMTO).sources(sourceSymbols).targets(targetSymbols).result();
    }

    @Override
    protected Set<BioPAXElement> doFileQuery(Model model) {
        List<String> sourceSym = this.options.getConvertedSourceList();
        Set<BioPAXElement> source = this.findRelatedReferences(model, sourceSym);
        List<String> targSym = this.options.getConvertedTargetList();
        Set<BioPAXElement> target = this.findRelatedReferences(model, targSym);
        return QueryExecuter.runPathsFromTo(source, target, model, this.options.getLimitType() ? LimitType.NORMAL : LimitType.SHORTEST_PLUS_K, this.options.getLengthLimit(), new Filter[0]);
    }

    @Override
    protected Collection<GraphObject> doSIFQuery(BasicSIFGraph graph) throws CPathException {
        return AlgoRunner.searchPathsFromTo(QueryPCPathsFromToAction.getSeed(graph, this.options.getConvertedSourceList()), QueryPCPathsFromToAction.getSeed(graph, this.options.getConvertedTargetList()), this.options.getLengthLimit(), !this.options.undirectedSIFTypeSelected(), this.options.getLimitType() ? -1 : this.options.getShortestPlusKLimit(), this.options.isStrict());
    }

    @Override
    protected AbstractQueryParamDialog getDialog() {
        if (this.fromSymbol == null) {
            assert (this.toSymbol == null);
            return new PoIQueryParamWithEntitiesDialog(this.main, this.queryLoc.isSIF());
        }
        this.options.setSourceList(Arrays.asList(this.fromSymbol));
        this.options.setTargetList(Arrays.asList(this.toSymbol));
        this.options.setLengthLimit(1);
        return null;
    }

    @Override
    protected boolean canQuery() {
        List<String> sourceSymbols = this.options.getConvertedSourceList();
        List<String> targetSymbols = this.options.getConvertedTargetList();
        this.warnForUnknownSymbols(this.options.getUnknownSymbols());
        return !sourceSymbols.isEmpty() && !targetSymbols.isEmpty();
    }

    @Override
    protected String getSIFQueryType() {
        return "pathsfromto";
    }

    @Override
    protected String getNewPathwayName() {
        if (this.newPathwayName != null) {
            return super.getNewPathwayName();
        }
        if (this.fromSymbol != null) {
            assert (this.toSymbol != null);
            return this.fromSymbol + " -> " + this.toSymbol;
        }
        return super.getNewPathwayName();
    }
}

