/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.awt.Graphics2D;
import java.io.File;
import java.io.FileWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.ScalableLayeredPane;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Shell;
import org.gvt.ChisioMain;
import org.gvt.action.ChiBEAction;
import org.gvt.action.FileChooser;
import org.gvt.editpart.ChsRootEditPart;
import org.gvt.editpart.ChsScalableRootEditPart;
import org.gvt.model.CompoundModel;
import org.gvt.util.onotoa.GraphicsToGraphics2DAdaptor;
import org.w3c.dom.Document;

public class SaveAsImageAction
extends ChiBEAction {
    boolean saveWholeGraph;

    public SaveAsImageAction(ChisioMain chisio, boolean saveGraph) {
        super(saveGraph ? "Save Pathway As Image ..." : "Save View As Image ...", null, chisio);
        this.saveWholeGraph = saveGraph;
        this.addFilterExtension("FILE_KEY", new String[]{"*.svg", "*.jpg", "*.bmp", "*.png"});
        this.addFilterName("FILE_KEY", new String[]{"SVG (*.svg)", "JPEG (*.jpg)", "BMP (*.bmp)", "PNG (*.png)"});
    }

    @Override
    public String getCurrentFilename() {
        String tmpfilename = this.main.getPathwayGraph() != null ? this.main.getPathwayGraph().getName() : this.main.getSelectedTab().getText();
        return tmpfilename + ".svg";
    }

    @Override
    public void run() {
        org.eclipse.swt.graphics.Rectangle bounds;
        Shell shell = this.main.getShell();
        ScalableLayeredPane layer = null;
        if (this.main.getViewer() == null) {
            return;
        }
        Figure rootFigure = (Figure)((ChsScalableRootEditPart)this.main.getViewer().getRootEditPart()).getFigure();
        String filename = new FileChooser(this, true).choose("FILE_KEY");
        if (filename == null) {
            return;
        }
        if (!(filename.endsWith(".jpg") || filename.endsWith(".bmp") || filename.endsWith(".png") || filename.endsWith(".svg"))) {
            MessageDialog.openError(this.main.getShell(), "Invalid filename", "ChiBE supports SVG, JPEG, PNG and Bitmap file formats only.\nPlease provide a filename with an appropriate extension.");
            return;
        }
        if (!this.saveWholeGraph) {
            bounds = this.getBounds(rootFigure);
        } else {
            rootFigure = (Figure)rootFigure.getChildren().get(0);
            layer = (ScalableLayeredPane)rootFigure.getChildren().get(0);
            double scale = layer.getScale();
            bounds = SaveAsImageAction.getBounds(this.main.getViewer(), rootFigure, scale);
        }
        Image image = new Image((Device)shell.getDisplay(), bounds);
        if (filename.endsWith(".svg")) {
            this.exportSvg(image, rootFigure, new File(filename));
        } else {
            GC gc = new GC(image);
            gc.setAntialias(1);
            gc.setTextAntialias(1);
            SWTGraphics graphics = new SWTGraphics(gc);
            rootFigure.paint(graphics);
            ((Graphics)graphics).drawText(this.main.getPathwayGraph().getName(), 3, 3);
            ((Graphics)graphics).dispose();
            ImageLoader loader = new ImageLoader();
            loader.data = new ImageData[]{image.getImageData()};
            if (filename.endsWith(".bmp")) {
                loader.save(filename, 0);
            } else if (filename.endsWith(".jpg")) {
                loader.save(filename, 4);
            } else if (filename.endsWith(".png")) {
                loader.save(filename, 5);
            }
        }
    }

    public static org.eclipse.swt.graphics.Rectangle getBounds(ScrollingGraphicalViewer viewer, Figure f, double zoom) {
        CompoundModel rootModel = (CompoundModel)((ChsRootEditPart)viewer.getRootEditPart().getChildren().get(0)).getModel();
        Rectangle bounds = rootModel.calculateBounds();
        Rectangle boundsRoot = f.getBounds();
        boundsRoot.setSize((int)((double)bounds.x + (double)(bounds.width + CompoundModel.MARGIN_SIZE) * zoom), (int)((double)bounds.y + (double)(bounds.height + CompoundModel.MARGIN_SIZE) * zoom));
        return new org.eclipse.swt.graphics.Rectangle(boundsRoot.x, boundsRoot.y, boundsRoot.width, boundsRoot.height);
    }

    public org.eclipse.swt.graphics.Rectangle getBounds(Figure f) {
        Rectangle bounds = f.getBounds();
        return new org.eclipse.swt.graphics.Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void exportSvg(Image image, IFigure fig, File file) {
        Graphics g = null;
        try {
            String svgNS = "http://www.w3.org/2000/svg";
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation().createDocument(svgNS, "svg", null);
            SVGGeneratorContext ctx = SVGGeneratorContext.createDefault(doc);
            ctx.setComment("Generated by Onotoa with Batik SVG Generator");
            ctx.setEmbeddedFontsOn(true);
            ctx.setPrecision(3);
            SVGGraphics2D svgGraphics2d = new SVGGraphics2D(ctx, true);
            g = new GraphicsToGraphics2DAdaptor((Graphics2D)svgGraphics2d, image.getBounds());
            g.translate(fig.getBounds().getLocation().getCopy().scale(-1.0));
            fig.paint(g);
            FileWriter writer = new FileWriter(file);
            svgGraphics2d.stream(writer);
            writer.flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (g != null) {
                g.dispose();
            }
            if (image != null) {
                image.dispose();
            }
        }
    }
}

