/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.controller.Cloner;
import org.biopax.paxtools.controller.Completer;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.io.sbgn.L3ToSBGNPDConverter;
import org.biopax.paxtools.io.sbgn.ListUbiqueDetector;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Level3Element;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.gvt.ChisioMain;
import org.gvt.action.ChiBEAction;
import org.gvt.action.FileChooser;
import org.gvt.model.BioPAXGraph;
import org.gvt.model.CompoundModel;
import org.gvt.model.biopaxl3.Actor;
import org.gvt.util.ID;
import org.gvt.util.PathwayHolder;

public class SaveAsSBGNMLAction
extends ChiBEAction {
    boolean currentPathwayOnly;

    public SaveAsSBGNMLAction(ChisioMain chisio, boolean currentPathwayOnly) {
        super(currentPathwayOnly ? "Save Pathway As SBGM-ML ..." : "Save Model As SBGN-ML ...", null, chisio);
        this.currentPathwayOnly = currentPathwayOnly;
        this.addFilterExtension("FILE_KEY", new String[]{"*.sbgn"});
        this.addFilterName("FILE_KEY", new String[]{"SBGN-ML (*.sbgn)"});
    }

    @Override
    public String getCurrentFilename() {
        String tmpfilename = this.main.getPathwayGraph() != null ? this.main.getPathwayGraph().getName() : this.main.getSelectedTab().getText();
        return tmpfilename + ".sbgn";
    }

    @Override
    public void run() {
        if (this.currentPathwayOnly && this.main.getViewer() == null) {
            return;
        }
        String filename = new FileChooser(this, true).choose("FILE_KEY");
        if (filename == null) {
            return;
        }
        if (!filename.endsWith(".sbgn")) {
            filename = filename + ".sbgn";
        }
        Model model = this.main.getBioPAXModel();
        if (this.currentPathwayOnly) {
            PathwayHolder ph = this.main.getPathwayGraph().getPathway();
            Pathway pathway2 = ph.l3p;
            Set<BioPAXElement> eles = new HashSet<BioPAXElement>(Collections.singleton(pathway2));
            EditorMap editorMap = new SimpleIOHandler(BioPAXLevel.L3).getEditorMap();
            eles = new Completer(editorMap).complete(eles, model);
            model = new Cloner(editorMap, BioPAXLevel.L3.getDefaultFactory()).clone(model, eles);
        }
        ListUbiqueDetector ubDet = new ListUbiqueDetector(this.getUbiqueIDs());
        L3ToSBGNPDConverter converter = new L3ToSBGNPDConverter(ubDet, null, true);
        converter.writeSBGN(model, filename);
    }

    private Set<String> getUbiqueIDs() {
        HashSet<String> set = new HashSet<String>();
        BioPAXGraph graph = this.main.getPathwayGraph();
        for (Object o : graph.getNodes()) {
            if (o instanceof Actor) {
                this.processActor(set, (Actor)o);
                continue;
            }
            if (!(o instanceof CompoundModel)) continue;
            this.collectInsideCompound((CompoundModel)o, set);
        }
        return set;
    }

    private void collectInsideCompound(CompoundModel node, Set<String> set) {
        for (Object o : node.getChildren()) {
            if (o instanceof CompoundModel) {
                this.collectInsideCompound((CompoundModel)o, set);
                continue;
            }
            if (!(o instanceof Actor)) continue;
            this.processActor(set, (Actor)o);
        }
    }

    private void processActor(Set<String> set, Actor actor) {
        if (actor.isUbique()) {
            Collection<? extends Level3Element> elements = actor.getRelatedModelElements();
            for (Level3Element level3Element : elements) {
                if (!(level3Element instanceof PhysicalEntity)) continue;
                set.add(ID.get(level3Element));
            }
        }
    }
}

