/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.io.FileOutputStream;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.gvt.ChisioMain;
import org.gvt.action.ChiBEAction;
import org.gvt.action.FileChooser;
import org.gvt.model.basicsif.BasicSIFGraph;
import org.gvt.model.sifl3.SIFGraph;

public class SaveSIFLayoutAction
extends ChiBEAction {
    public SaveSIFLayoutAction(ChisioMain chisio) {
        super("Save SIF Layout ...", "icon/save-as.png", chisio);
        this.addFilterExtension("FILE_KEY", new String[]{"*.layout"});
        this.addFilterName("FILE_KEY", new String[]{"SIF Layout (*.layout)"});
    }

    @Override
    public String getCurrentFilename() {
        String currentFilename = this.main.getOwlFileName();
        if (currentFilename != null && !currentFilename.endsWith(".layout")) {
            if (currentFilename.indexOf(".") > 0) {
                currentFilename = currentFilename.substring(0, currentFilename.lastIndexOf("."));
            }
            currentFilename = currentFilename + ".layout";
        }
        return currentFilename;
    }

    @Override
    public void run() {
        if (this.main.getPathwayGraph() == null) {
            return;
        }
        SIFGraph sifL3Graph = null;
        BasicSIFGraph basicSifGraph = null;
        if (this.main.getPathwayGraph().getGraphType().equals("SIF_LEVEL3")) {
            sifL3Graph = (SIFGraph)this.main.getPathwayGraph();
        } else if (this.main.getPathwayGraph().getGraphType().equals("BASIC_SIF")) {
            basicSifGraph = (BasicSIFGraph)this.main.getPathwayGraph();
        }
        if (sifL3Graph == null && basicSifGraph == null) {
            MessageDialog.openError(this.main.getShell(), "Not A Valid View!", "Only the layouts of SIF graphs can be saved.");
            return;
        }
        String fileName = new FileChooser(this, true).choose("FILE_KEY");
        if (fileName == null) {
            return;
        }
        try {
            FileOutputStream os = new FileOutputStream(fileName);
            if (sifL3Graph != null) {
                sifL3Graph.writeLayout(os);
            } else if (basicSifGraph != null) {
                basicSifGraph.writeLayout(os);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageBox messageBox = new MessageBox(this.main.getShell(), 42);
            messageBox.setMessage("Layout cannot be saved!");
            messageBox.setText("Chisio BioPAX Editor");
            messageBox.open();
        }
    }
}

