/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.Collection;
import java.util.HashMap;
import org.biopax.paxtools.model.Model;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.gvt.ChisioMain;
import org.gvt.GraphAnimation;
import org.gvt.action.CoSELayoutAction;
import org.gvt.action.HideCompartmentsAction;
import org.gvt.editpart.ChsScalableRootEditPart;
import org.gvt.figure.HighlightLayer;
import org.gvt.model.BioPAXGraph;
import org.gvt.model.GraphObject;
import org.gvt.model.IBioPAXEdge;
import org.gvt.model.IBioPAXNode;
import org.gvt.util.Conf;
import org.gvt.util.PathwayHolder;

public class UpdatePathwayAction
extends Action {
    private ChisioMain main;
    private boolean allOpenPathways;
    private Collection<GraphObject> withContent;
    private Boolean showCompartments;

    public UpdatePathwayAction(ChisioMain main, boolean allOpenPathways) {
        super(allOpenPathways ? "Update All Open Pathways" : "Update Pathway");
        if (allOpenPathways) {
            this.setImageDescriptor(ImageDescriptor.createFromFile(ChisioMain.class, "icon/pathway-update-all.png"));
        }
        this.setToolTipText(this.getText());
        this.main = main;
        this.allOpenPathways = allOpenPathways;
    }

    public UpdatePathwayAction(ChisioMain main, Collection<GraphObject> withContent) {
        this(main, false);
        this.withContent = withContent;
    }

    public void setShowCompartments(boolean showCompartments) {
        this.showCompartments = showCompartments;
    }

    private void updateViewerContent(ScrollingGraphicalViewer viewer) {
        boolean layedout;
        BioPAXGraph graph = (BioPAXGraph)viewer.getContents().getModel();
        if (!graph.isMechanistic()) {
            return;
        }
        HashMap<String, Color> highlightMap = new HashMap<String, Color>();
        for (Object o : graph.getNodes()) {
            IBioPAXNode node = (IBioPAXNode)o;
            if (!node.isHighlighted()) continue;
            highlightMap.put(node.getIDHash(), node.getHighlightColor());
        }
        for (Object o : graph.getEdges()) {
            IBioPAXEdge edge = (IBioPAXEdge)o;
            if (!edge.isHighlighted()) continue;
            highlightMap.put(edge.getIDHash(), edge.getHighlightColor());
        }
        HighlightLayer hLayer = (HighlightLayer)((ChsScalableRootEditPart)viewer.getRootEditPart()).getLayer("Highlight Layer");
        hLayer.removeAll();
        hLayer.highlighted.clear();
        viewer.deselectAll();
        graph.recordLayout();
        PathwayHolder p = graph.getPathway();
        if (this.withContent != null) {
            p.updateContentWith(this.withContent);
        }
        BioPAXGraph newGraph = this.main.createAModelForView(p);
        newGraph.setAsRoot();
        newGraph.setName(graph.getName());
        viewer.setContents(newGraph);
        if (this.showCompartments == null && (double)newGraph.getEdges().size() > Conf.getNumber("HIDE_COMPARTMENT_EDGE_THRESHOLD") || this.showCompartments != null && !this.showCompartments.booleanValue()) {
            new HideCompartmentsAction(this.main).run();
        }
        if (!(layedout = newGraph.fetchLayout())) {
            new CoSELayoutAction(this.main).run();
        }
        viewer.deselectAll();
        GraphAnimation.run(viewer);
        for (Object o : newGraph.getNodes()) {
            IBioPAXNode node = (IBioPAXNode)o;
            if (!highlightMap.containsKey(node.getIDHash())) continue;
            node.setHighlightColor((Color)highlightMap.get(node.getIDHash()));
            node.setHighlight(true);
        }
        for (Object o : newGraph.getEdges()) {
            IBioPAXEdge edge = (IBioPAXEdge)o;
            if (!highlightMap.containsKey(edge.getIDHash())) continue;
            edge.setHighlightColor((Color)highlightMap.get(edge.getIDHash()));
            edge.setHighlight(true);
        }
    }

    @Override
    public void run() {
        Model model = this.main.getBioPAXModel();
        if (model == null) {
            MessageDialog.openError(this.main.getShell(), "Error!", "Load or query a BioPAX model first!");
            return;
        }
        if (this.allOpenPathways) {
            for (ScrollingGraphicalViewer viewer : this.main.getTabToViewerMap().values()) {
                this.updateViewerContent(viewer);
            }
        } else {
            this.updateViewerContent(this.main.getViewer());
        }
    }
}

