/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.gvt.ChisioMain;
import org.gvt.action.CenterViewAction;
import org.gvt.editpart.ChsRootEditPart;
import org.gvt.editpart.ChsScalableRootEditPart;
import org.gvt.model.CompoundModel;

public class ZoomAction
extends Action {
    private static final double zoomStep = 1.1;
    private int zoom;
    private ChisioMain main;
    private Point clickLocation;

    public ZoomAction(ChisioMain main, int zoom, Point clickLocation) {
        this.main = main;
        this.zoom = zoom;
        this.clickLocation = clickLocation;
        if (zoom == 1) {
            super.setText("Zoom In");
            super.setImageDescriptor(ImageDescriptor.createFromFile(ChisioMain.class, "icon/zoom-in.png"));
        } else if (zoom == -1) {
            super.setText("Zoom Out");
            super.setImageDescriptor(ImageDescriptor.createFromFile(ChisioMain.class, "icon/zoom-out.png"));
        } else if (zoom == 0) {
            super.setText("Fit In Window");
            super.setImageDescriptor(ImageDescriptor.createFromFile(ChisioMain.class, "icon/zoom-fit.png"));
        } else {
            super.setText(zoom + "%");
        }
        this.setToolTipText(this.getText());
    }

    @Override
    public void run() {
        if (this.main.getViewer() == null) {
            return;
        }
        double zoomLevel = ((ChsScalableRootEditPart)this.main.getViewer().getRootEditPart()).getZoomManager().getZoom();
        super.run();
        if (this.zoom == 0) {
            ((ChsScalableRootEditPart)this.main.getViewer().getRootEditPart()).getZoomManager().setZoom(1.0);
            ((ChsScalableRootEditPart)this.main.getViewer().getRootEditPart()).getZoomManager().setViewLocation(new Point(0, 0));
            CompoundModel root = (CompoundModel)((ChsRootEditPart)this.main.getViewer().getRootEditPart().getChildren().get(0)).getModel();
            Rectangle r = root.calculateBounds();
            r.expand(CompoundModel.MARGIN_SIZE, CompoundModel.MARGIN_SIZE);
            ((ChsScalableRootEditPart)this.main.getViewer().getRootEditPart()).getZoomManager().zoomTo(r);
        } else {
            zoomLevel = this.zoom == 1 ? (zoomLevel *= 1.1) : (this.zoom == -1 ? (zoomLevel /= 1.1) : (double)this.zoom / 100.0);
            if (this.clickLocation != null) {
                new CenterViewAction(this.main, this.clickLocation).run();
            }
            ((ChsScalableRootEditPart)this.main.getViewer().getRootEditPart()).getZoomManager().setZoom(zoomLevel);
        }
        this.main.getViewer().getEditDomain().setActiveTool(this.main.getViewer().getEditDomain().getDefaultTool());
        this.main.getHighlightLayer().refreshHighlights();
    }
}

