/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.figure;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.gvt.ChsXYLayout;
import org.gvt.figure.HighlightLayer;
import org.gvt.figure.RPPANodeFigure;
import org.gvt.figure.RoundRectWithInfo;
import org.gvt.model.NodeModel;

public class NodeFigure
extends Figure {
    Label label;
    String shape;
    boolean highlight;
    Color highlightColor;
    boolean smallMolecule;
    int multimer;
    boolean drawCloneMarker;
    int borderWidth;
    public PointList triangle = new PointList(3);

    public NodeFigure() {
    }

    public NodeFigure(Point absLocation, Dimension size, String text, String tooltipText, Font textFont, Color textColor, Color color, Color borderColor, int borderWidth, String shape, Color highlightColor, boolean highlight, int multimer) {
        this.label = new Label();
        if (tooltipText != null) {
            this.label.setToolTip(new Label(tooltipText));
        }
        this.add(this.label);
        this.highlight = highlight;
        this.multimer = multimer;
        this.setBackgroundColor(color);
        this.setForegroundColor(borderColor);
        this.borderWidth = borderWidth;
        this.setLayoutManager(new ChsXYLayout());
        Rectangle r = new Rectangle(absLocation.getCopy(), size.getCopy());
        this.setBounds(r);
        this.updateText(text);
        this.updateTextFont(textFont);
        this.updateTextColor(textColor);
        this.updateHighlightColor(highlightColor);
        this.updateShape(shape);
        this.smallMolecule = false;
        this.drawCloneMarker = false;
    }

    public boolean isSmallMolecule() {
        return this.smallMolecule;
    }

    public void setSmallMolecule(boolean smallMolecule2) {
        this.smallMolecule = smallMolecule2;
    }

    public int getMultimer() {
        return this.multimer;
    }

    public void setMultimer(int multimer) {
        this.multimer = multimer;
    }

    public boolean isDrawCloneMarker() {
        return this.drawCloneMarker;
    }

    public void setDrawCloneMarker(boolean drawCloneMarker) {
        this.drawCloneMarker = drawCloneMarker;
    }

    public void updateText(String str) {
        this.label.setText(str);
    }

    public void updateTooltipText(String str) {
        this.label.setToolTip(new Label(str));
    }

    public void updateTextFont(Font f) {
        this.label.setFont(f);
    }

    public void updateTextColor(Color c) {
        this.label.setForegroundColor(c);
    }

    public void updateColor(Color color) {
        this.setBackgroundColor(color);
    }

    public void updateBorderColor(Color color) {
        this.setForegroundColor(color);
    }

    public void updateBorderWidth(int width) {
        this.borderWidth = width;
    }

    public void updateShape(String s) {
        this.shape = s;
        this.removeAll();
        if (this.shape.equals(NodeModel.shapes[0])) {
            this.add(new RectangleFigure(this.getBounds()));
            this.add(this.label);
        } else if (this.shape.equals(NodeModel.shapes[1])) {
            this.add(new RoundRectFigure(this.getBounds()));
            this.add(this.label);
        } else if (this.shape.equals(NodeModel.shapes[2])) {
            this.add(new EllipseFigure(this.getBounds()));
            this.add(this.label);
        } else if (this.shape.equals(NodeModel.shapes[3])) {
            this.add(new TriangleFigure(this.getBounds()));
            this.add(this.label);
        } else if (this.shape.equals(NodeModel.shapes[4])) {
            this.add(new DiamondFigure(this.getBounds()));
            this.add(this.label);
        } else if (this.shape.startsWith(NodeModel.shapes[5])) {
            int semicolIndex = this.shape.indexOf(";");
            if (semicolIndex > 0 || this.multimer > 1) {
                ArrayList<String> infos = new ArrayList<String>();
                if (semicolIndex > 0) {
                    String line = this.shape.substring(semicolIndex + 1);
                    for (String info : line.split(";")) {
                        if (info.length() <= 0) continue;
                        infos.add(info);
                    }
                }
                if (this.multimer > 1) {
                    infos.add(0, "" + this.multimer);
                }
                this.add(new RoundRectWithInfo(this.getBounds(), infos, this.label, this.multimer > 1, this.borderWidth));
            } else {
                this.add(new RectangleFigure(this.getBounds()));
            }
        } else if (this.shape.startsWith(NodeModel.shapes[6])) {
            String[] parts = this.shape.split(";");
            if (parts.length > 1) {
                ArrayList<String> infos = new ArrayList<String>();
                Collections.addAll(infos, parts);
                infos.remove(0);
                this.add(new RPPANodeFigure(this.getBounds(), infos, this.label, this.borderWidth));
            } else {
                this.add(new RectangleFigure(this.getBounds()));
            }
        }
    }

    public void updateHighlight(Layer highlight, boolean isHighlight) {
        this.highlight = isHighlight;
        if (this.highlight) {
            ((HighlightLayer)highlight).addHighlightToNode(this);
        } else {
            ((HighlightLayer)highlight).removeHighlight(this);
        }
        this.repaint();
    }

    public void updateHighlightColor(Color color) {
        this.highlightColor = color;
        this.repaint();
    }

    @Override
    protected void paintFigure(Graphics g) {
        this.label.setSize(this.getSize());
    }

    public PointList calculateTrianglePoints(Rectangle r) {
        PointList points = new PointList(3);
        points.addPoint(new Point(r.x + (r.width - 1) / 2, r.y));
        points.addPoint(new Point(r.x, r.y + r.height - 1));
        points.addPoint(new Point(r.x + r.width - 1, r.y + r.height - 1));
        return points;
    }

    public class DiamondFigure
    extends Figure {
        public DiamondFigure(Rectangle rect) {
            this.setBounds(rect);
        }

        @Override
        protected void paintFigure(Graphics g) {
            g.setAntialias(1);
            Rectangle r = this.getParent().getBounds().getCopy();
            this.setBounds(r);
            PointList points = this.calculateDiamondPoints(r);
            g.fillPolygon(points);
            g.drawPolygon(points);
        }

        protected PointList calculateDiamondPoints(Rectangle r) {
            PointList points = new PointList(4);
            points.addPoint(new Point(r.x + (r.width - 1) / 2, r.y));
            points.addPoint(new Point(r.x + (r.width - 1), r.y + (r.height - 1) / 2));
            points.addPoint(new Point(r.x + (r.width - 1) / 2, r.y + (r.height - 1)));
            points.addPoint(new Point(r.x, r.y + (r.height - 1) / 2));
            return points;
        }
    }

    public class TriangleFigure
    extends Figure {
        public TriangleFigure(Rectangle rect) {
            this.setBounds(rect);
        }

        @Override
        protected void paintFigure(Graphics g) {
            g.setAntialias(1);
            Rectangle r = this.getParent().getBounds().getCopy();
            this.setBounds(r);
            PointList points = NodeFigure.this.calculateTrianglePoints(r);
            g.fillPolygon(points);
            g.drawPolygon(points);
        }
    }

    public class EllipseFigure
    extends Figure {
        public EllipseFigure(Rectangle rect) {
            this.setBounds(rect);
        }

        @Override
        protected void paintFigure(Graphics g) {
            g.setAntialias(1);
            Rectangle r = this.getParent().getBounds().getCopy();
            this.setBounds(r);
            g.fillOval(r);
            --r.height;
            --r.width;
            g.drawOval(r);
        }
    }

    public class RoundRectFigure
    extends Figure {
        public RoundRectFigure() {
        }

        public RoundRectFigure(Rectangle rect) {
            this.setBounds(rect);
        }

        @Override
        protected void paintFigure(Graphics g) {
            g.setAntialias(1);
            Rectangle r = this.getParent().getBounds().getCopy();
            this.setBounds(r);
            NodeFigure.this.label.setBounds(r);
            int rounding = NodeFigure.this.smallMolecule ? 15 : 10;
            g.fillRoundRectangle(r, rounding, rounding);
            if (NodeFigure.this.drawCloneMarker) {
                Color old = g.getBackgroundColor();
                g.setBackgroundColor(new Color(null, 220, 220, 220));
                double ratio = 0.3;
                Rectangle clip = new Rectangle(r.x, (int)Math.round((double)r.y + (double)r.height * (1.0 - ratio)), r.width, (int)Math.round((double)r.height * ratio));
                g.setClip(clip);
                g.fillRoundRectangle(r, rounding, rounding);
                g.setBackgroundColor(old);
                g.setClip(r);
            }
            Rectangle copy = r.getCopy();
            copy.x -= NodeFigure.this.borderWidth;
            copy.y -= NodeFigure.this.borderWidth;
            copy.width += 2 * NodeFigure.this.borderWidth;
            copy.height += 2 * NodeFigure.this.borderWidth;
            g.setClip(copy);
            int temp = g.getLineWidth();
            g.setLineWidth(NodeFigure.this.borderWidth);
            g.drawRoundRectangle(r, rounding, rounding);
            g.setLineWidth(temp);
        }
    }

    public class RectangleFigure
    extends Figure {
        public RectangleFigure() {
        }

        public RectangleFigure(Rectangle rect) {
            this.setBounds(rect);
        }

        @Override
        protected void paintFigure(Graphics g) {
            Rectangle r = this.getParent().getBounds().getCopy();
            this.setBounds(r);
            g.fillRectangle(r);
            r.height -= NodeFigure.this.borderWidth;
            r.width -= NodeFigure.this.borderWidth;
            int temp = g.getLineWidth();
            g.setLineWidth(NodeFigure.this.borderWidth);
            g.drawRectangle(r);
            g.setLineWidth(temp);
        }
    }
}

