/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.gui;

import org.cbio.causality.data.portal.CBioPortalOptions;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gvt.ChisioMain;

public class CBioPortalSettingsDialog
extends Dialog {
    private ChisioMain main;
    private Shell shell;

    public CBioPortalSettingsDialog(ChisioMain main) {
        super(main.getShell(), 0);
        this.main = main;
    }

    public void open() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setText("cBio Portal Settings");
        ImageDescriptor id = ImageDescriptor.createFromFile(ChisioMain.class, "icon/cbe-icon.png");
        this.shell.setImage(id.createImage());
        final CBioPortalOptions options = ChisioMain.cBioPortalAccessor.getOptions();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.shell.setLayout(gridLayout);
        Label expLabel = new Label(this.shell, 1);
        expLabel.setText("Alteration thresholds for data types");
        GridData gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = 2;
        expLabel.setLayoutData(gridData);
        Group expGroup = new Group(this.shell, 0);
        gridData = new GridData(4, 2, false, false);
        gridData.horizontalSpan = 1;
        expGroup.setLayoutData(gridData);
        expGroup.setLayout(new GridLayout(2, true));
        Label expDataLabel = new Label(expGroup, 1);
        expDataLabel.setText("Expression:");
        gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = 2;
        expDataLabel.setLayoutData(gridData);
        Label expUpper = new Label(expGroup, 1);
        expUpper.setText("Upper: ");
        gridData = new GridData(4, 2, false, false);
        gridData.horizontalSpan = 1;
        expUpper.setLayoutData(gridData);
        final Text upperExpLimit = new Text(expGroup, 2048);
        upperExpLimit.setText(((Double)options.get((Object)CBioPortalOptions.PORTAL_OPTIONS.EXP_UPPER_THRESHOLD)).toString());
        gridData = new GridData(4, 2, false, false);
        upperExpLimit.setLayoutData(gridData);
        Label expLower = new Label(expGroup, 1);
        expLower.setText("Lower: ");
        gridData = new GridData(4, 2, false, false);
        gridData.horizontalSpan = 1;
        expLower.setLayoutData(gridData);
        final Text lowerExpLimit = new Text(expGroup, 2048);
        lowerExpLimit.setText(((Double)options.get((Object)CBioPortalOptions.PORTAL_OPTIONS.EXP_LOWER_THRESHOLD)).toString());
        gridData = new GridData(4, 2, false, false);
        lowerExpLimit.setLayoutData(gridData);
        Group cnaGroup = new Group(this.shell, 0);
        gridData = new GridData(4, 2, false, false);
        gridData.horizontalSpan = 1;
        cnaGroup.setLayoutData(gridData);
        cnaGroup.setLayout(new GridLayout(2, true));
        Label cnaDataLabel = new Label(cnaGroup, 1);
        cnaDataLabel.setText("Copy-number:");
        gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = 2;
        cnaDataLabel.setLayoutData(gridData);
        Label cnaUpper = new Label(cnaGroup, 1);
        cnaUpper.setText("Upper: ");
        gridData = new GridData(4, 2, false, false);
        gridData.horizontalSpan = 1;
        cnaUpper.setLayoutData(gridData);
        final Text cnaUpperLimit = new Text(cnaGroup, 2048);
        cnaUpperLimit.setText(((Double)options.get((Object)CBioPortalOptions.PORTAL_OPTIONS.CNA_UPPER_THRESHOLD)).toString());
        gridData = new GridData(4, 2, false, false);
        cnaUpperLimit.setLayoutData(gridData);
        Label cnaLower = new Label(cnaGroup, 1);
        cnaLower.setText("Lower: ");
        gridData = new GridData(4, 2, false, false);
        gridData.horizontalSpan = 1;
        cnaLower.setLayoutData(gridData);
        final Text cnaLowerLimit = new Text(cnaGroup, 2048);
        cnaLowerLimit.setText(((Double)options.get((Object)CBioPortalOptions.PORTAL_OPTIONS.CNA_LOWER_THRESHOLD)).toString());
        gridData = new GridData(4, 2, false, false);
        cnaLowerLimit.setLayoutData(gridData);
        Group rppaGroup = new Group(this.shell, 0);
        gridData = new GridData(4, 2, false, false);
        gridData.horizontalSpan = 1;
        rppaGroup.setLayoutData(gridData);
        rppaGroup.setLayout(new GridLayout(2, true));
        Label rppaDataLabel = new Label(rppaGroup, 1);
        rppaDataLabel.setText("Protein:");
        gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = 2;
        rppaDataLabel.setLayoutData(gridData);
        Label rppaUpper = new Label(rppaGroup, 1);
        rppaUpper.setText("Upper: ");
        gridData = new GridData(4, 2, false, false);
        gridData.horizontalSpan = 1;
        rppaUpper.setLayoutData(gridData);
        final Text upperRppaLimit = new Text(rppaGroup, 2048);
        upperRppaLimit.setText(((Double)options.get((Object)CBioPortalOptions.PORTAL_OPTIONS.RPPA_UPPER_THRESHOLD)).toString());
        gridData = new GridData(4, 2, false, false);
        upperRppaLimit.setLayoutData(gridData);
        Label rppaLower = new Label(rppaGroup, 1);
        rppaLower.setText("Lower: ");
        gridData = new GridData(4, 2, false, false);
        gridData.horizontalSpan = 1;
        rppaLower.setLayoutData(gridData);
        final Text lowerRppaLimit = new Text(rppaGroup, 2048);
        lowerRppaLimit.setText(((Double)options.get((Object)CBioPortalOptions.PORTAL_OPTIONS.RPPA_LOWER_THRESHOLD)).toString());
        gridData = new GridData(4, 2, false, false);
        lowerRppaLimit.setLayoutData(gridData);
        Group methGroup = new Group(this.shell, 0);
        gridData = new GridData(4, 2, false, false);
        gridData.horizontalSpan = 1;
        methGroup.setLayoutData(gridData);
        methGroup.setLayout(new GridLayout(2, true));
        Label methDataLabel = new Label(methGroup, 1);
        methDataLabel.setText("Methylation:");
        gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = 2;
        methDataLabel.setLayoutData(gridData);
        Label methUpper = new Label(methGroup, 1);
        methUpper.setText("Upper: ");
        gridData = new GridData(4, 2, false, false);
        gridData.horizontalSpan = 1;
        methUpper.setLayoutData(gridData);
        final Text upperMethLimit = new Text(methGroup, 2048);
        upperMethLimit.setText(((Double)options.get((Object)CBioPortalOptions.PORTAL_OPTIONS.METHYLATION_THRESHOLD)).toString());
        gridData = new GridData(4, 2, false, false);
        upperMethLimit.setLayoutData(gridData);
        Button saveButton = new Button(this.shell, 0);
        saveButton.setText("Save");
        gridData = new GridData(3, 2, true, false);
        saveButton.setLayoutData(gridData);
        Button cancelButton = new Button(this.shell, 0);
        cancelButton.setText("Cancel");
        gridData = new GridData(1, 2, true, false);
        cancelButton.setLayoutData(gridData);
        cancelButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                CBioPortalSettingsDialog.this.shell.close();
            }
        });
        saveButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    int closeCount = 0;
                    if (Double.parseDouble(upperExpLimit.getText()) > Double.parseDouble(lowerExpLimit.getText())) {
                        options.put(CBioPortalOptions.PORTAL_OPTIONS.EXP_UPPER_THRESHOLD, Double.parseDouble(upperExpLimit.getText()));
                        options.put(CBioPortalOptions.PORTAL_OPTIONS.EXP_LOWER_THRESHOLD, Double.parseDouble(lowerExpLimit.getText()));
                        ++closeCount;
                    } else {
                        upperExpLimit.setText(((Double)options.get((Object)CBioPortalOptions.PORTAL_OPTIONS.EXP_UPPER_THRESHOLD)).toString());
                        lowerExpLimit.setText(((Double)options.get((Object)CBioPortalOptions.PORTAL_OPTIONS.EXP_LOWER_THRESHOLD)).toString());
                    }
                    if (Double.parseDouble(cnaUpperLimit.getText()) > Double.parseDouble(cnaLowerLimit.getText())) {
                        options.put(CBioPortalOptions.PORTAL_OPTIONS.CNA_UPPER_THRESHOLD, Double.parseDouble(cnaUpperLimit.getText()));
                        options.put(CBioPortalOptions.PORTAL_OPTIONS.CNA_LOWER_THRESHOLD, Double.parseDouble(cnaLowerLimit.getText()));
                        ++closeCount;
                    } else {
                        cnaUpperLimit.setText(((Double)options.get((Object)CBioPortalOptions.PORTAL_OPTIONS.CNA_UPPER_THRESHOLD)).toString());
                        cnaLowerLimit.setText(((Double)options.get((Object)CBioPortalOptions.PORTAL_OPTIONS.CNA_LOWER_THRESHOLD)).toString());
                    }
                    if (Double.parseDouble(upperRppaLimit.getText()) > Double.parseDouble(lowerRppaLimit.getText())) {
                        options.put(CBioPortalOptions.PORTAL_OPTIONS.RPPA_UPPER_THRESHOLD, Double.parseDouble(upperRppaLimit.getText()));
                        options.put(CBioPortalOptions.PORTAL_OPTIONS.RPPA_LOWER_THRESHOLD, Double.parseDouble(lowerRppaLimit.getText()));
                        ++closeCount;
                    } else {
                        upperRppaLimit.setText(((Double)options.get((Object)CBioPortalOptions.PORTAL_OPTIONS.RPPA_UPPER_THRESHOLD)).toString());
                        lowerRppaLimit.setText(((Double)options.get((Object)CBioPortalOptions.PORTAL_OPTIONS.RPPA_LOWER_THRESHOLD)).toString());
                    }
                    options.put(CBioPortalOptions.PORTAL_OPTIONS.METHYLATION_THRESHOLD, Double.parseDouble(upperMethLimit.getText()));
                    if (closeCount == 3) {
                        CBioPortalSettingsDialog.this.shell.close();
                    } else {
                        MessageDialog.openWarning(CBioPortalSettingsDialog.this.main.getShell(), "Invalid values!", "Upper thresholds must be greater than lower thresholds.");
                    }
                }
                catch (NumberFormatException e) {
                    MessageDialog.openError(CBioPortalSettingsDialog.this.main.getShell(), "Error", "An error occurred while parsing the threshold values:\n" + e.getMessage());
                }
            }
        });
        this.shell.pack();
        this.shell.setLocation(this.getParent().getLocation().x + this.getParent().getSize().x / 2 - this.shell.getSize().x / 2, this.getParent().getLocation().y + this.getParent().getSize().y / 2 - this.shell.getSize().y / 2);
        this.shell.open();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

