/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.gui;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.biopax.paxtools.pattern.miner.SIFType;
import org.cbio.causality.analysis.Graph;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gvt.ChisioMain;

public class EnrichmentInSIFParameterDialog
extends Dialog {
    private List<SIFType> possibleRules;
    private List<SIFType> selectedRules;
    private Map<String, SIFType> ruleTagMap;
    private String backgroundfile;
    private String genefile;
    private Double fdr;
    private boolean okPressed;
    private Shell shell;
    private Button okButton;
    private Button cancelButton;
    private Button bgBrowseButton;
    private Button geneBrowseButton;
    private Text bgText;
    private Text geneText;
    private Text fdrText;
    private Combo neighTypeCombo;
    private int neighTypeSelectionIndex = 2;

    public EnrichmentInSIFParameterDialog(Shell shell, List<SIFType> possibleRules, List<SIFType> selectedRules, String genefile, String backgroundfile, Double fdr) {
        super(shell);
        this.possibleRules = possibleRules;
        this.selectedRules = selectedRules;
        this.backgroundfile = backgroundfile;
        this.genefile = genefile;
        this.fdr = fdr;
        this.ruleTagMap = new HashMap<String, SIFType>();
        for (SIFType rule : possibleRules) {
            this.ruleTagMap.put(rule.getTag(), rule);
        }
        this.okPressed = false;
    }

    public boolean open() {
        this.createContents();
        this.shell.pack();
        this.shell.setLocation(this.getParent().getLocation().x + this.getParent().getSize().x / 2 - this.shell.getSize().x / 2, this.getParent().getLocation().y + this.getParent().getSize().y / 2 - this.shell.getSize().y / 2);
        this.shell.open();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.okPressed;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), 67680);
        this.shell.setText("Paths Between Query on SIF File");
        this.shell.setImage(ImageDescriptor.createFromFile(ChisioMain.class, "icon/cbe-icon.png").createImage());
        this.shell.setLayout(new GridLayout());
        Label infoLabel = new Label(this.shell, 0);
        infoLabel.setText("Find the sub-network that contains\nnodes with enriched neighborhood ");
        infoLabel.setLayoutData(new GridData(4, 4, false, false, 1, 8));
        ButtonAdapter adapter = new ButtonAdapter();
        Group geneGroup = new Group(this.shell, 0);
        geneGroup.setText("Query genes file name");
        geneGroup.setLayout(new RowLayout());
        this.geneText = new Text(geneGroup, 2052);
        this.geneText.setLayoutData(new RowData(200, 20));
        if (this.genefile != null) {
            this.geneText.setText(this.genefile);
        }
        this.geneBrowseButton = new Button(geneGroup, 8);
        this.geneBrowseButton.setText("Browse");
        this.geneBrowseButton.addSelectionListener(adapter);
        Group bgGroup = new Group(this.shell, 0);
        bgGroup.setText("Background genes file name");
        bgGroup.setLayout(new RowLayout());
        this.bgText = new Text(bgGroup, 2052);
        this.bgText.setLayoutData(new RowData(200, 20));
        if (this.backgroundfile != null) {
            this.bgText.setText(this.backgroundfile);
        }
        this.bgBrowseButton = new Button(bgGroup, 8);
        this.bgBrowseButton.setText("Browse");
        this.bgBrowseButton.addSelectionListener(adapter);
        Group fdrGroup = new Group(this.shell, 0);
        fdrGroup.setLayout(new RowLayout());
        fdrGroup.setText("False discovery rate");
        this.fdrText = new Text(fdrGroup, 2052);
        if (this.fdr != null) {
            this.fdrText.setText(this.fdr.toString());
        }
        this.fdrText.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                EnrichmentInSIFParameterDialog.this.checkButtons();
            }
        });
        Group neighTypeGroup = new Group(this.shell, 0);
        neighTypeGroup.setLayout(new RowLayout());
        neighTypeGroup.setText("Neighborhood type");
        this.neighTypeCombo = new Combo(neighTypeGroup, 0);
        Graph.NeighborType[] types = Graph.NeighborType.values();
        String[] s = new String[types.length];
        for (int i = 0; i < s.length; ++i) {
            s[i] = types[i].name().toLowerCase();
        }
        this.neighTypeCombo.setItems(s);
        this.neighTypeCombo.select(this.neighTypeSelectionIndex);
        this.neighTypeCombo.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                EnrichmentInSIFParameterDialog.this.checkButtons();
            }
        });
        Group rulesGroup = new Group(this.shell, 0);
        rulesGroup.setLayout(new GridLayout());
        rulesGroup.setText("Select rules to use");
        for (SIFType rule : this.possibleRules) {
            Button ruleBox = new Button(rulesGroup, 32);
            ruleBox.setText(rule.getTag());
            ruleBox.setToolTipText(this.prepareToolTipText(rule.getDescription()));
            ruleBox.addSelectionListener(adapter);
            if (!this.selectedRules.contains(rule)) continue;
            ruleBox.setSelection(true);
        }
        Composite buttonsGroup = new Composite(this.shell, 0);
        buttonsGroup.setLayout(new RowLayout());
        this.okButton = new Button(buttonsGroup, 0);
        this.okButton.setText("OK");
        this.okButton.addSelectionListener(adapter);
        this.cancelButton = new Button(buttonsGroup, 0);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addSelectionListener(adapter);
        this.checkButtons();
    }

    private String prepareToolTipText(String text) {
        String tooltip = "";
        String line = "";
        StringTokenizer tokenizer = new StringTokenizer(text);
        while (tokenizer.hasMoreTokens()) {
            String token = (line.length() == 0 ? "" : " ") + tokenizer.nextToken();
            tooltip = tooltip + token;
            if ((line = line + token).length() <= 50) continue;
            tooltip = tooltip + "\n";
            line = "";
        }
        return tooltip;
    }

    public String getGenefile() {
        return this.genefile;
    }

    public String getBackgroundfile() {
        return this.backgroundfile;
    }

    public Double getFdr() {
        return this.fdr;
    }

    private void checkButtons() {
        this.okButton.setEnabled(!this.selectedRules.isEmpty() && (this.bgText.getText().isEmpty() || this.bgText.getText().length() > 0 && new File(this.bgText.getText()).exists()) && this.geneText.getText().length() > 0 && new File(this.geneText.getText()).exists() && this.readFDR() != null);
        this.neighTypeSelectionIndex = this.neighTypeCombo.getSelectionIndex();
    }

    private Double readFDR() {
        try {
            return new Double(this.fdrText.getText());
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getNeighTypeIndex() {
        return this.neighTypeSelectionIndex;
    }

    class ButtonAdapter
    extends SelectionAdapter {
        ButtonAdapter() {
        }

        @Override
        public void widgetSelected(SelectionEvent arg) {
            Button button = (Button)arg.widget;
            if ((button.getStyle() & 0x20) > 0) {
                String ruleTag = button.getText();
                SIFType rule = (SIFType)EnrichmentInSIFParameterDialog.this.ruleTagMap.get(ruleTag);
                if (button.getSelection()) {
                    assert (!EnrichmentInSIFParameterDialog.this.selectedRules.contains(rule));
                    EnrichmentInSIFParameterDialog.this.selectedRules.add(rule);
                } else {
                    assert (EnrichmentInSIFParameterDialog.this.selectedRules.contains(rule));
                    EnrichmentInSIFParameterDialog.this.selectedRules.remove(rule);
                }
                EnrichmentInSIFParameterDialog.this.checkButtons();
            } else if (button == EnrichmentInSIFParameterDialog.this.okButton) {
                EnrichmentInSIFParameterDialog.this.fdr = EnrichmentInSIFParameterDialog.this.readFDR();
                EnrichmentInSIFParameterDialog.this.okPressed = true;
                EnrichmentInSIFParameterDialog.this.shell.dispose();
            } else if (button == EnrichmentInSIFParameterDialog.this.cancelButton) {
                EnrichmentInSIFParameterDialog.this.okPressed = false;
                EnrichmentInSIFParameterDialog.this.shell.dispose();
            } else if (button == EnrichmentInSIFParameterDialog.this.bgBrowseButton) {
                FileDialog dialog = new FileDialog(EnrichmentInSIFParameterDialog.this.shell, 4096);
                if (EnrichmentInSIFParameterDialog.this.backgroundfile != null) {
                    dialog.setFileName(EnrichmentInSIFParameterDialog.this.backgroundfile);
                }
                dialog.setFilterNames(new String[]{"Simple Interaction Format (*.sif)"});
                dialog.setFilterExtensions(new String[]{"*.sif"});
                String file = dialog.open();
                if (file != null) {
                    EnrichmentInSIFParameterDialog.this.backgroundfile = file;
                    EnrichmentInSIFParameterDialog.this.bgText.setText(EnrichmentInSIFParameterDialog.this.backgroundfile);
                }
                EnrichmentInSIFParameterDialog.this.checkButtons();
            } else if (button == EnrichmentInSIFParameterDialog.this.geneBrowseButton) {
                FileDialog dialog = new FileDialog(EnrichmentInSIFParameterDialog.this.shell, 4096);
                if (EnrichmentInSIFParameterDialog.this.genefile != null) {
                    dialog.setFileName(EnrichmentInSIFParameterDialog.this.genefile);
                }
                dialog.setFilterNames(new String[]{"Genes of Interest List (*.txt)"});
                dialog.setFilterExtensions(new String[]{"*.txt"});
                String file = dialog.open();
                if (file != null) {
                    EnrichmentInSIFParameterDialog.this.genefile = file;
                    EnrichmentInSIFParameterDialog.this.geneText.setText(EnrichmentInSIFParameterDialog.this.genefile);
                }
                EnrichmentInSIFParameterDialog.this.checkButtons();
            }
        }
    }
}

