/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.gui;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.biopax.paxtools.pattern.miner.SIFType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.gvt.ChisioMain;

public class ExportToSIFL3Dialog
extends Dialog {
    private List<SIFType> possibleRules;
    private List<SIFType> selectedRules;
    private Map<String, SIFType> ruleTagMap;
    private boolean okPressed;
    private Shell shell;
    private Button okButton;
    private Button cancelButton;

    public ExportToSIFL3Dialog(Shell shell, List<SIFType> possibleRules, List<SIFType> selectedRules) {
        super(shell);
        this.possibleRules = possibleRules;
        this.selectedRules = selectedRules;
        this.ruleTagMap = new HashMap<String, SIFType>();
        for (SIFType rule : possibleRules) {
            this.ruleTagMap.put(rule.getTag(), rule);
        }
        this.okPressed = false;
    }

    public boolean open() {
        this.createContents();
        this.shell.pack();
        this.shell.open();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.okPressed;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), 67680);
        this.shell.setText("Binary Interaction Types");
        this.shell.setImage(ImageDescriptor.createFromFile(ChisioMain.class, "icon/cbe-icon.png").createImage());
        GridLayout gridLy = new GridLayout();
        gridLy.numColumns = 1;
        this.shell.setLayout(gridLy);
        Group rulesGroup = new Group(this.shell, 0);
        rulesGroup.setText("Select interaction types to use");
        gridLy = new GridLayout();
        gridLy.numColumns = 1;
        rulesGroup.setLayout(gridLy);
        GridData gridDt = new GridData();
        gridDt.grabExcessVerticalSpace = true;
        rulesGroup.setLayoutData(gridDt);
        ButtonAdapter adapter = new ButtonAdapter();
        for (SIFType rule : this.possibleRules) {
            Button ruleBox = new Button(rulesGroup, 32);
            ruleBox.setText(rule.getTag());
            ruleBox.setToolTipText(this.prepareToolTipText(rule.getDescription()));
            ruleBox.addSelectionListener(adapter);
            if (!this.selectedRules.contains(rule)) continue;
            ruleBox.setSelection(true);
        }
        Composite buttons = new Composite(this.shell, 0);
        buttons.setLayout(new RowLayout());
        gridDt = new GridData();
        gridDt.horizontalAlignment = 64;
        buttons.setLayoutData(gridDt);
        this.okButton = new Button(buttons, 0);
        this.okButton.setText("OK");
        this.okButton.addSelectionListener(adapter);
        this.okButton.setEnabled(!this.selectedRules.isEmpty());
        this.cancelButton = new Button(buttons, 0);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addSelectionListener(adapter);
    }

    private String prepareToolTipText(String text) {
        if ((text = text.trim()).endsWith("\n")) {
            text = text.substring(0, text.length() - 1);
        }
        String tooltip = "";
        String line = "";
        StringTokenizer tokenizer = new StringTokenizer(text);
        while (tokenizer.hasMoreTokens()) {
            String token = (line.length() == 0 ? "" : " ") + tokenizer.nextToken();
            tooltip = tooltip + token;
            if ((line = line + token).length() <= 50 || !tokenizer.hasMoreTokens()) continue;
            tooltip = tooltip + "\n";
            line = "";
        }
        return tooltip;
    }

    class ButtonAdapter
    extends SelectionAdapter {
        ButtonAdapter() {
        }

        @Override
        public void widgetSelected(SelectionEvent arg) {
            Button button = (Button)arg.widget;
            if ((button.getStyle() & 0x20) > 0) {
                String ruleTag = button.getText();
                SIFType rule = (SIFType)ExportToSIFL3Dialog.this.ruleTagMap.get(ruleTag);
                if (button.getSelection()) {
                    assert (!ExportToSIFL3Dialog.this.selectedRules.contains(rule));
                    ExportToSIFL3Dialog.this.selectedRules.add(rule);
                } else {
                    assert (ExportToSIFL3Dialog.this.selectedRules.contains(rule));
                    ExportToSIFL3Dialog.this.selectedRules.remove(rule);
                }
                ExportToSIFL3Dialog.this.okButton.setEnabled(!ExportToSIFL3Dialog.this.selectedRules.isEmpty());
            } else if (button == ExportToSIFL3Dialog.this.okButton) {
                ExportToSIFL3Dialog.this.okPressed = true;
                ExportToSIFL3Dialog.this.shell.dispose();
            } else if (button == ExportToSIFL3Dialog.this.cancelButton) {
                ExportToSIFL3Dialog.this.okPressed = false;
                ExportToSIFL3Dialog.this.shell.dispose();
            }
        }
    }
}

