/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.Process;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.gvt.ChisioMain;

public class PathwaySelectionDialog
extends Dialog {
    Shell shell;
    Model model;
    List<String> selected;
    private boolean pressedCancel;

    public PathwaySelectionDialog(Shell shell, Model model, List<String> selected) {
        super(shell, 0);
        this.model = model;
        this.selected = selected;
        this.pressedCancel = false;
    }

    public void open() {
        this.pressedCancel = true;
        this.createContents();
        this.shell.setText("Select pathways to display");
        this.shell.setImage(ImageDescriptor.createFromFile(ChisioMain.class, "icon/cbe-icon.png").createImage());
        this.shell.pack();
        if (this.shell.getSize().y > 500) {
            this.shell.setSize(new Point(this.shell.getSize().x, 500));
        }
        this.shell.setLocation(this.getParent().getLocation().x + this.getParent().getSize().x / 2 - this.shell.getSize().x / 2, this.getParent().getLocation().y + this.getParent().getSize().y / 2 - this.shell.getSize().y / 2);
        this.shell.open();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), 2160);
        this.shell.setLayout(new FillLayout());
        Composite parent = new Composite(this.shell, 2048);
        GridLayout grid = new GridLayout(2, true);
        parent.setLayout(grid);
        final Tree tree = new Tree(parent, 68386);
        this.fillTree(tree);
        this.setChecks(tree, this.selected);
        tree.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    TreeItem item = (TreeItem)event.item;
                    PathwaySelectionDialog.this.propagateCheckStatus(item, tree);
                }
            }
        });
        GridData data = new GridData(4, 4, true, true, 2, 1);
        tree.setLayoutData(data);
        Button okButton = new Button(parent, 8);
        okButton.setText("OK");
        okButton.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event) {
                Set checked = PathwaySelectionDialog.this.getChecked(tree);
                PathwaySelectionDialog.this.selected.clear();
                for (TreeItem item : checked) {
                    if (PathwaySelectionDialog.this.selected.contains(item.getText())) continue;
                    PathwaySelectionDialog.this.selected.add(item.getText());
                }
                PathwaySelectionDialog.this.pressedCancel = false;
                PathwaySelectionDialog.this.shell.dispose();
            }
        });
        data = new GridData(131072, 0x1000000, false, false, 1, 1);
        okButton.setLayoutData(data);
        Button cancelButton = new Button(parent, 8);
        cancelButton.setText("Cancel");
        cancelButton.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event) {
                PathwaySelectionDialog.this.shell.dispose();
            }
        });
        data = new GridData(16384, 0x1000000, false, false, 1, 1);
        cancelButton.setLayoutData(data);
    }

    private void fillTree(Tree tree) {
        for (Pathway p : this.order(this.model.getObjects(Pathway.class))) {
            if (p.getPathwayComponent().isEmpty() || !p.getPathwayComponentOf().isEmpty()) continue;
            TreeItem item = new TreeItem(tree, 0);
            item.setText(p.getDisplayName());
            this.handleChildren(p, item);
        }
    }

    private List<Pathway> order(Set<Pathway> set) {
        ArrayList<Pathway> list = new ArrayList<Pathway>(set);
        Collections.sort(list, new Comparator<Pathway>(){

            @Override
            public int compare(Pathway p1, Pathway p2) {
                return p1.getDisplayName().compareTo(p2.getDisplayName());
            }
        });
        return list;
    }

    private void handleChildren(Pathway p, TreeItem parent) {
        for (Process prc : p.getPathwayComponent()) {
            if (!(prc instanceof Pathway)) continue;
            Pathway c = (Pathway)prc;
            TreeItem item = new TreeItem(parent, 0);
            item.setText(c.getDisplayName());
            this.handleChildren(c, item);
        }
    }

    private void setChecks(Tree tree, List<String> selected) {
        HashSet<String> set = new HashSet<String>();
        set.addAll(selected);
        for (TreeItem item : tree.getItems()) {
            this.setCheckedRecursive(item, set);
        }
    }

    private void setCheckedRecursive(TreeItem item, Set<String> selected) {
        item.setExpanded(true);
        item.setChecked(selected.contains(item.getText()));
        for (TreeItem child : item.getItems()) {
            this.setCheckedRecursive(child, selected);
        }
    }

    public boolean isCancelled() {
        return this.pressedCancel;
    }

    private Set<TreeItem> getChecked(Tree tree) {
        HashSet<TreeItem> set = new HashSet<TreeItem>();
        for (TreeItem item : tree.getItems()) {
            this.collectChecked(item, set);
        }
        return set;
    }

    private void collectChecked(TreeItem item, Set<TreeItem> set) {
        if (item.getChecked()) {
            set.add(item);
        }
        for (TreeItem child : item.getItems()) {
            this.collectChecked(child, set);
        }
    }

    private void propagateCheckStatus(TreeItem copy, Tree tree) {
        Listener lis = tree.getListeners(13)[0];
        tree.removeListener(13, lis);
        for (TreeItem item : tree.getItems()) {
            this.propagateCheckStatus(copy, item);
        }
        tree.addListener(13, lis);
    }

    private void propagateCheckStatus(TreeItem copy, TreeItem item) {
        if (item == copy) {
            return;
        }
        if (item.getText().equals(copy.getText())) {
            item.setChecked(copy.getChecked());
            return;
        }
        for (TreeItem child : item.getItems()) {
            this.propagateCheckStatus(copy, child);
        }
    }
}

