/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.inspector;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.TableItem;
import org.gvt.ChisioMain;
import org.gvt.inspector.Inspector;
import org.gvt.model.NodeModel;
import org.patika.mada.graph.GraphObject;

public class NodeInspector
extends Inspector {
    NodeModel node;

    private NodeInspector(org.gvt.model.GraphObject model, String title, ChisioMain main) {
        super(model, title, main);
        this.node = (NodeModel)model;
    }

    private void prepare() {
        TableItem item = this.addRow(this.table, "Text");
        item.setText(1, this.model.getText());
        if (this.model.getTooltipText() != null) {
            item = this.addRow(this.table, "Tooltip");
            item.setText(1, this.model.getTooltipText());
        }
        item = this.addRow(this.table, "Text Font");
        Font font = this.model.getTextFont();
        String fontName = font.getFontData()[0].getName();
        int fontSize = font.getFontData()[0].getHeight();
        int fontStyle = font.getFontData()[0].getStyle();
        if (fontSize > 14) {
            fontSize = 14;
        }
        item.setText(1, fontName);
        item.setFont(1, new Font(null, fontName, fontSize, fontStyle));
        item.setForeground(1, this.model.getTextColor());
        item = this.addRow(this.table, "Color");
        item.setBackground(1, this.model.getColor());
        item = this.addRow(this.table, "Border Color");
        item.setBackground(1, ((NodeModel)this.model).getBorderColor());
        item = this.addRow(this.table, "Shape");
        item.setText(1, ((NodeModel)this.model).getShape());
    }

    private void prepareForGraphObject() {
        GraphObject go = (GraphObject)((Object)this.model);
        for (String[] property : go.getInspectable()) {
            this.addRow(this.table, property[0]).setText(1, property[1]);
        }
        this.table.getColumn(1).pack();
        this.table.pack();
    }

    private void show() {
        this.createContents(this.shell);
        this.shell.setLocation(this.calculateInspectorLocation(this.main.clickLocation.x, this.main.clickLocation.y));
        this.shell.open();
    }

    public static void getInstance(org.gvt.model.GraphObject model, String title, ChisioMain main) {
        if (NodeInspector.isSingle(model)) {
            NodeInspector ndIns = new NodeInspector(model, title, main);
            instances.add(ndIns);
            ndIns.prepare();
            if (model instanceof GraphObject) {
                ndIns.prepareForGraphObject();
            }
            ndIns.show();
        }
    }
}

