/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.gvt.model.CompoundModel;
import org.gvt.model.NodeModel;

public class NodeIterator
implements Iterator<NodeModel> {
    private int ledgeType;
    private HashSet<NodeModel> lnodes;
    private Iterator<NodeModel> literator;
    private NodeModel lnext;
    private boolean lisRecursive;

    public NodeIterator(CompoundModel root, boolean isRecursive) {
        this.lisRecursive = isRecursive;
        this.lnodes = new HashSet();
        this.constructNodes(root);
        this.literator = this.lnodes.iterator();
    }

    private void constructNodes(CompoundModel root) {
        for (NodeModel node : root.children) {
            this.lnodes.add(node);
            if (!(node instanceof CompoundModel) || !this.lisRecursive) continue;
            this.constructNodes((CompoundModel)node);
        }
    }

    @Override
    public boolean hasNext() {
        this.findNext();
        return this.lnext != null;
    }

    @Override
    public NodeModel next() {
        return this.lnext;
    }

    private void findNext() {
        this.lnext = null;
        while (this.literator.hasNext()) {
            this.lnext = this.literator.next();
        }
    }

    @Override
    public void remove() {
    }

    public Set<NodeModel> getNodes() {
        return this.lnodes;
    }
}

