/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.gvt.model.CompoundModel;
import org.gvt.model.ECluster;
import org.gvt.model.EClusterManager;
import org.gvt.model.EdgeModel;
import org.gvt.model.GraphObject;
import org.ivis.layout.Cluster;
import org.ivis.layout.Clustered;
import org.ivis.layout.LGraphObject;
import org.ivis.layout.LNode;
import org.ivis.layout.Updatable;

public class NodeModel
extends GraphObject
implements Updatable,
Clustered {
    private CompoundModel parentModel = null;
    protected Rectangle constraint = new Rectangle();
    protected String shape;
    protected List<Cluster> clusters;
    protected Color borderColor;
    protected int borderWidth;
    protected List sourceConnections = new ArrayList();
    protected List targetConnections = new ArrayList();
    public static String[] shapes = new String[]{"Rectangle", "RoundRect", "Ellipse", "Triangle", "Diamond", "RoundRectWithInfo", "RPPA"};
    public static Dimension DEFAULT_SIZE = new Dimension(40, 40);
    public static String DEFAULT_TEXT = "Node";
    public static Font DEFAULT_TEXT_FONT = new Font(null, new FontData("Arial", 8, 0));
    public static Color DEFAULT_TEXT_COLOR = ColorConstants.black;
    public static Color DEFAULT_COLOR = new Color(null, 14, 112, 130);
    public static Color DEFAULT_BORDER_COLOR = new Color(null, 14, 112, 130);
    public static int DEFAULT_BORDER_WIDTH = 1;
    public static String DEFAULT_SHAPE = shapes[0];
    public static final String P_CONSTRAINT = "_constraint";
    public static final String P_SHAPE = "_shape";
    public static final String P_CLUSTERID = "_clusterID";
    public static final String P_BORDERCOLOR = "_borderColor";
    public static final String P_BORDERWIDTH = "_borderWidth";
    public static final String P_CONNX_SOURCE = "_connx_source";
    public static final String P_CONNX_TARGET = "_connx_target";

    public NodeModel() {
        this(new Rectangle(new Point(0, 0), DEFAULT_SIZE));
    }

    public NodeModel(Point pt) {
        this(new Rectangle(pt, DEFAULT_SIZE));
    }

    public NodeModel(Rectangle rect) {
        this.setConstraint(rect);
        this.text = DEFAULT_TEXT;
        this.textFont = DEFAULT_TEXT_FONT;
        this.textColor = DEFAULT_TEXT_COLOR;
        this.color = DEFAULT_COLOR;
        this.borderColor = DEFAULT_BORDER_COLOR;
        this.borderWidth = DEFAULT_BORDER_WIDTH;
        this.shape = DEFAULT_SHAPE;
        this.clusters = new ArrayList<Cluster>();
    }

    @Override
    public void update(LGraphObject lGraphObj) {
        LNode lNode = (LNode)lGraphObj;
        this.setLocationAbs(new Point(lNode.getRect().x, lNode.getRect().y));
    }

    public void setConstraint(Rectangle rectangle) {
        this.constraint.setLocation(rectangle.getLocation());
        this.constraint.setSize(rectangle.getSize());
        this.firePropertyChange(P_CONSTRAINT, null, this.constraint);
    }

    public Rectangle getConstraint() {
        return this.constraint;
    }

    public void addSourceConnection(EdgeModel connx) {
        this.sourceConnections.add(connx);
        this.firePropertyChange(P_CONNX_SOURCE, null, null);
    }

    public void addTargetConnection(EdgeModel connx) {
        this.targetConnections.add(connx);
        this.firePropertyChange(P_CONNX_TARGET, null, null);
    }

    public void removeSourceConnection(EdgeModel connx) {
        this.sourceConnections.remove(connx);
        this.firePropertyChange(P_CONNX_SOURCE, null, null);
    }

    public void removeTargetConnection(EdgeModel connx) {
        this.targetConnections.remove(connx);
        this.firePropertyChange(P_CONNX_TARGET, null, null);
    }

    public List getSourceConnections() {
        return this.sourceConnections;
    }

    public List getTargetConnections() {
        return this.targetConnections;
    }

    public String getShape() {
        return this.shape;
    }

    public void setShape(String s) {
        this.shape = s;
        this.firePropertyChange(P_SHAPE, null, this.shape);
    }

    public void setBorderColor(Color c) {
        this.borderColor = c;
        this.firePropertyChange(P_BORDERCOLOR, null, this.borderColor);
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
        this.firePropertyChange(P_BORDERWIDTH, null, this.borderWidth);
    }

    public NodeModel(Point pt, String str, Color c, String lbl) {
        this(new Rectangle(pt, DEFAULT_SIZE));
        this.setShape(str);
        this.setColor(c);
        this.setText(lbl);
    }

    public CompoundModel getParentModel() {
        return this.parentModel;
    }

    public void setParentModel(CompoundModel parent) {
        this.parentModel = parent;
    }

    public void setLocation(Point p) {
        this.constraint.setLocation(p);
        this.firePropertyChange(P_CONSTRAINT, null, this.constraint);
        for (Cluster cluster : this.getClusters()) {
            cluster.calculatePolygon();
        }
    }

    public void setLocationAbs(Point p) {
        CompoundModel parent = this.getParentModel();
        if (parent != null && parent instanceof CompoundModel) {
            Point parentLocation = parent.getLocationAbs();
            p.translate(-parentLocation.x, -parentLocation.y);
        }
        this.setLocation(p);
    }

    public Point getLocation() {
        return this.constraint.getLocation();
    }

    public Point getLocationAbs() {
        Point location = this.constraint.getLocation();
        CompoundModel parent = this.getParentModel();
        if (parent != null && parent instanceof CompoundModel) {
            location.translate(parent.getLocationAbs());
        }
        return location;
    }

    public void setSize(Dimension d) {
        this.constraint.setSize(d);
        this.firePropertyChange(P_CONSTRAINT, null, this.constraint);
    }

    public Dimension getSize() {
        return this.constraint.getSize();
    }

    public List getEdgeListToNode(NodeModel to) {
        ArrayList<EdgeModel> edgeList = new ArrayList<EdgeModel>();
        if (this.sourceConnections != null) {
            int i = 0;
            while (i < this.sourceConnections.size()) {
                EdgeModel edge;
                if ((edge = (EdgeModel)this.sourceConnections.get(i++)).getTarget() != to) continue;
                edgeList.add(edge);
            }
        }
        return edgeList;
    }

    public boolean isNeighbor(NodeModel node) {
        return this.sourceConnections.contains(node) || this.targetConnections.contains(node);
    }

    public List<NodeModel> getNeighborsList() {
        EdgeModel edge;
        int i;
        ArrayList<NodeModel> neigbors = new ArrayList<NodeModel>();
        for (i = 0; i < this.sourceConnections.size(); ++i) {
            edge = (EdgeModel)this.sourceConnections.get(i);
            neigbors.add(edge.getTarget());
        }
        for (i = 0; i < this.targetConnections.size(); ++i) {
            edge = (EdgeModel)this.targetConnections.get(i);
            neigbors.add(edge.getSource());
        }
        return neigbors;
    }

    public String getClusterIDs() {
        String clusterIDs = "";
        for (Cluster cluster : this.clusters) {
            clusterIDs = clusterIDs + cluster.getClusterID() + "|";
        }
        if (clusterIDs.length() - 1 > 0) {
            return clusterIDs.substring(0, clusterIDs.length() - 1);
        }
        return "0";
    }

    @Override
    public double getLeft() {
        return this.constraint.x;
    }

    @Override
    public double getRight() {
        return this.constraint.x + this.constraint.width;
    }

    @Override
    public double getTop() {
        return this.constraint.y;
    }

    @Override
    public double getBottom() {
        return this.constraint.y + this.constraint.height;
    }

    public int getCenterX() {
        return this.constraint.getCenter().x;
    }

    public int getCenterY() {
        return this.constraint.getCenter().y;
    }

    public int getLeftAbs() {
        return this.getLocationAbs().x;
    }

    public int getRightAbs() {
        return this.getLeftAbs() + this.constraint.width;
    }

    public int getTopAbs() {
        return this.getLocationAbs().y;
    }

    public int getBottomAbs() {
        return this.getTopAbs() + this.constraint.height;
    }

    public int getCenterXAbs() {
        return this.getLeftAbs() + this.constraint.width / 2;
    }

    public int getCenterYAbs() {
        return this.getTopAbs() + this.constraint.height / 2;
    }

    public void setLeftAbs(int left) {
        Point loc = this.getLocationAbs();
        loc.x = left;
        this.setLocationAbs(loc);
    }

    public void setRightAbs(int right) {
        Point loc = this.getLocationAbs();
        loc.x = right - this.constraint.width;
        this.setLocationAbs(loc);
    }

    public void setTopAbs(int top) {
        Point loc = this.getLocationAbs();
        loc.y = top;
        this.setLocationAbs(loc);
    }

    public void setBottomAbs(int bottom) {
        Point loc = this.getLocationAbs();
        loc.y = bottom - this.constraint.height;
        this.setLocationAbs(loc);
    }

    public void setCenterXAbs(int centerX) {
        Point loc = this.getLocationAbs();
        loc.x = centerX - this.constraint.width / 2;
        this.setLocationAbs(loc);
    }

    public void setCenterYAbs(int centerY) {
        Point loc = this.getLocationAbs();
        loc.y = centerY - this.constraint.height / 2;
        this.setLocationAbs(loc);
    }

    public void setPositiveLocation(Rectangle r) {
        this.setConstraint(r);
        Point loc = this.getLocationAbs();
        if (loc.x < 0) {
            loc.x = 0;
        }
        if (loc.y < 0) {
            loc.y = 0;
        }
        this.setLocationAbs(loc);
    }

    public List<Cluster> getClusters() {
        return this.clusters;
    }

    @Override
    public void addCluster(int clusterID) {
        EClusterManager cm = this.parentModel.getClusterManager();
        Cluster eCluster = cm.getClusterByID(clusterID);
        if (eCluster == null) {
            eCluster = new ECluster(cm, clusterID, "Cluster " + clusterID);
            cm.addCluster(eCluster);
        }
        this.addCluster(eCluster);
    }

    @Override
    public void addCluster(Cluster eCluster) {
        if (!this.clusters.contains(eCluster)) {
            this.clusters.add(eCluster);
            eCluster.getNodes().add(this);
            eCluster.calculatePolygon();
        }
    }

    @Override
    public void removeCluster(Cluster eCluster) {
        if (this.clusters.contains(eCluster)) {
            this.clusters.remove(eCluster);
            eCluster.getNodes().remove(this);
            eCluster.calculatePolygon();
        }
    }

    @Override
    public void resetClusters() {
        for (Cluster cluster : this.clusters) {
            cluster.getNodes().remove(this);
            cluster.calculatePolygon();
        }
        this.clusters.clear();
    }

    @Override
    public Clustered getParent() {
        return this.parentModel;
    }

    protected void updatePolygonsOfChildren() {
        for (Cluster cluster : this.getClusters()) {
            cluster.calculatePolygon();
        }
    }

    public boolean hasCommonCluster(NodeModel node) {
        for (Cluster cluster : this.getClusters()) {
            if (!node.getClusters().contains(cluster)) continue;
            return true;
        }
        return false;
    }
}

