/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.biopaxl2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gvt.command.CreateCommand;
import org.gvt.model.CompoundModel;
import org.gvt.model.biopaxl2.BioPAXL2Graph;
import org.gvt.model.biopaxl2.Compartment;
import org.gvt.model.biopaxl2.IBioPAXL2Node;
import org.gvt.model.biopaxl2.NodeUtil;
import org.patika.mada.graph.Edge;
import org.patika.mada.graph.GraphObject;
import org.patika.mada.graph.Node;
import org.patika.mada.util.ExperimentData;
import org.patika.mada.util.Representable;
import org.patika.mada.util.XRef;

public abstract class BioPAXCompoundNode
extends CompoundModel
implements IBioPAXL2Node {
    private int id;
    private List<XRef> references;
    protected NodeUtil util;

    public BioPAXCompoundNode(CompoundModel root) {
        CreateCommand command = new CreateCommand(root, this);
        command.execute();
        this.references = new ArrayList<XRef>();
        this.util = new NodeUtil(this);
    }

    public BioPAXCompoundNode(BioPAXCompoundNode excised, CompoundModel root) {
        this(root);
        this.id = excised.id;
        this.references.addAll(excised.getReferences());
        this.setShape(excised.getShape());
        this.setSize(excised.getSize());
        this.setColor(excised.getColor());
        this.setText(excised.getText());
        this.setTextColor(excised.getTextColor());
        this.setTooltipText(excised.getTooltipText());
        this.setBorderColor(excised.getBorderColor());
        for (Object key : excised.getAllLabels()) {
            this.putLabel(key, excised.getLabel(key));
        }
        this.getGraph().putInExcisionMap(excised, this);
        this.putLabel("EXCISED_FROM", excised);
    }

    @Override
    public boolean isComplexMember() {
        return false;
    }

    @Override
    public void configFromModel() {
    }

    @Override
    public BioPAXL2Graph getGraph() {
        return this.util.getGraph();
    }

    public Compartment getCompartment() {
        return this.util.getCompartment();
    }

    @Override
    public boolean isEvent() {
        return false;
    }

    @Override
    public boolean isTranscriptionEvent() {
        return false;
    }

    @Override
    public List<XRef> getReferences() {
        return this.references;
    }

    public void addReference(XRef ref) {
        if (!this.references.contains(ref)) {
            this.references.add(ref);
        }
    }

    @Override
    public List<XRef> getSecondaryReferences() {
        return Collections.emptyList();
    }

    @Override
    public String getName() {
        return this.getText();
    }

    @Override
    public Representable getRepresentableData(Object key) {
        return (Representable)this.getLabel(key);
    }

    @Override
    public ExperimentData getExperimentData(String type) {
        return (ExperimentData)this.getLabel(type);
    }

    @Override
    public void setExperimentData(ExperimentData data) {
        this.putLabel(data.getKey(), data);
    }

    @Override
    public boolean hasExperimentData(Object key) {
        return this.hasLabel(key);
    }

    @Override
    public boolean hasSignificantExperimentalChange(String type) {
        return this.hasExperimentData(type) && this.getExperimentData(type).isSignificant();
    }

    @Override
    public int getExperimentDataSign(String type) {
        return this.getExperimentData(type).getSign();
    }

    @Override
    public boolean fetchLocation(String pathwayRDFID) {
        return this.util.fetchLocation(pathwayRDFID);
    }

    @Override
    public void recordLocation() {
        this.util.recordLocation();
    }

    @Override
    public void eraseLocation() {
        this.util.eraseLocation();
    }

    @Override
    public String getIDHash() {
        return this.util.getIDHash();
    }

    @Override
    public boolean hasModelTag(String tag) {
        return this.util.hasModelTag(tag);
    }

    @Override
    public String fetchModelTag(String tag) {
        return this.util.fetchModelTag(tag);
    }

    @Override
    public Collection<? extends Node> getParents() {
        CompoundModel p = this.getParentModel();
        ArrayList<BioPAXCompoundNode> col = new ArrayList<BioPAXCompoundNode>(1);
        if (p == null || p.isRoot()) {
            return col;
        }
        col.add((BioPAXCompoundNode)p);
        return col;
    }

    @Override
    public Collection<? extends Edge> getUpstream() {
        return this.getTargetConnections();
    }

    @Override
    public Collection<? extends Edge> getDownstream() {
        return this.getSourceConnections();
    }

    @Override
    public Set<Node> getTabuNodes() {
        return Collections.emptySet();
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public boolean sameEntity(Node n) {
        return n.equals(this);
    }

    @Override
    public boolean isBreadthNode() {
        return false;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isHighlighted() {
        return this.isHighlight();
    }

    @Override
    public Set<GraphObject> getRequisites() {
        HashSet<GraphObject> reqs = new HashSet<GraphObject>();
        if (this.getParentModel() instanceof Compartment) {
            reqs.add((GraphObject)((Object)this.getParentModel()));
        }
        return reqs;
    }

    @Override
    public List<String[]> getInspectable() {
        ArrayList<String[]> list = new ArrayList<String[]>();
        return list;
    }
}

