/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.biopaxl2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.Level2Element;
import org.biopax.paxtools.model.level2.complex;
import org.biopax.paxtools.model.level2.openControlledVocabulary;
import org.biopax.paxtools.model.level2.physicalEntity;
import org.biopax.paxtools.model.level2.physicalEntityParticipant;
import org.biopax.paxtools.model.level2.sequenceFeature;
import org.biopax.paxtools.model.level2.sequenceParticipant;
import org.biopax.paxtools.model.level2.xref;
import org.eclipse.swt.graphics.Color;
import org.gvt.model.CompoundModel;
import org.gvt.model.EntityAssociated;
import org.gvt.model.biopaxl2.BioPAXCompoundNode;
import org.gvt.model.biopaxl2.BioPAXNode;
import org.gvt.model.biopaxl2.ComplexMember;
import org.gvt.util.EntityHolder;
import org.gvt.util.ID;
import org.patika.mada.graph.GraphObject;
import org.patika.mada.util.XRef;

public class Complex
extends BioPAXCompoundNode
implements EntityAssociated {
    private complex cmp;
    List<physicalEntityParticipant> participants;
    private static final Color COLOR = new Color(null, 140, 140, 140);

    public Complex(CompoundModel root) {
        super(root);
        this.setText("Complex");
    }

    @Override
    public Collection<? extends Level2Element> getRelatedModelElements() {
        return this.participants;
    }

    public Complex(CompoundModel root, complex cmp, List<physicalEntityParticipant> participants) {
        this(root);
        this.cmp = cmp;
        this.participants = participants;
        this.extractReferences();
        this.setText(cmp.getSHORT_NAME() != null && cmp.getSHORT_NAME().length() > 0 ? cmp.getSHORT_NAME() : cmp.getNAME());
        this.setTooltipText(this.getText());
        this.setColor(COLOR);
    }

    public Complex(Complex toexcise, CompoundModel root) {
        super(toexcise, root);
        this.cmp = toexcise.getComplex();
        this.participants = toexcise.getParticipants();
    }

    private void extractReferences() {
        for (xref xr : this.cmp.getXREF()) {
            this.addReference(new XRef(xr));
        }
    }

    public complex getComplex() {
        return this.cmp;
    }

    @Override
    public EntityHolder getEntity() {
        return new EntityHolder(this.cmp);
    }

    public List<physicalEntityParticipant> getParticipants() {
        return this.participants;
    }

    @Override
    public boolean isBreadthNode() {
        return true;
    }

    @Override
    public Set<GraphObject> getRequisites() {
        Set<GraphObject> reqs = super.getRequisites();
        reqs.addAll(this.getChildren());
        return reqs;
    }

    @Override
    public List<String[]> getInspectable() {
        physicalEntityParticipant pep;
        openControlledVocabulary loc;
        ArrayList<String[]> list = new ArrayList<String[]>();
        BioPAXNode.addNamesAndTypeAndID(list, this.cmp);
        if (this.participants != null && !this.participants.isEmpty() && (loc = (pep = this.participants.get(0)).getCELLULAR_LOCATION()) != null) {
            list.add(new String[]{"Location", loc.toString()});
        }
        BioPAXNode.addDataSourceAndXrefAndComments(list, this.cmp);
        return list;
    }

    @Override
    public String getIDHash() {
        String h = ID.get(this.cmp);
        int c = 0;
        if (!this.participants.isEmpty()) {
            c += this.participants.iterator().next().stateCode();
        }
        return h + c;
    }

    public physicalEntityParticipant createNewPEP(Model model, String rdfid) {
        if (this.participants.isEmpty()) {
            physicalEntityParticipant pepNew = model.addNew(physicalEntityParticipant.class, rdfid);
            pepNew.setPHYSICAL_ENTITY(this.cmp);
            return pepNew;
        }
        physicalEntityParticipant pep = this.participants.get(0);
        physicalEntityParticipant pepNew = (physicalEntityParticipant)model.addNew(pep.getModelInterface(), rdfid);
        pepNew.setCELLULAR_LOCATION(pep.getCELLULAR_LOCATION());
        if (pep instanceof sequenceParticipant) {
            for (sequenceFeature feat : ((sequenceParticipant)pep).getSEQUENCE_FEATURE_LIST()) {
                ((sequenceParticipant)pepNew).addSEQUENCE_FEATURE_LIST(feat);
            }
        }
        pepNew.setPHYSICAL_ENTITY(this.cmp);
        return pepNew;
    }

    public String suggestCompartmentNameUsingMembers() {
        return Complex.suggestCompartmentNameUsingMembers(this.cmp.getCOMPONENTS());
    }

    public static String suggestCompartmentNameUsingMembers(Set<physicalEntityParticipant> memberParts) {
        ArrayList<String> names = new ArrayList<String>();
        for (physicalEntityParticipant pep : memberParts) {
            if (pep.getCELLULAR_LOCATION() == null) continue;
            names.add(pep.getCELLULAR_LOCATION().getTERM().iterator().next());
        }
        if (!names.isEmpty()) {
            return (String)names.get(0);
        }
        return null;
    }

    public List<ComplexMember> getRelatedMembers(physicalEntity pe) {
        ArrayList<ComplexMember> list = new ArrayList<ComplexMember>();
        for (Object o : this.getChildren()) {
            ComplexMember mem = (ComplexMember)o;
            if (mem.getEntity() != pe) continue;
            list.add(mem);
        }
        return list;
    }
}

