/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.biopaxl2;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.model.level2.Level2Element;
import org.biopax.paxtools.model.level2.control;
import org.biopax.paxtools.model.level2.evidence;
import org.biopax.paxtools.model.level2.interaction;
import org.biopax.paxtools.model.level2.physicalEntityParticipant;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;
import org.gvt.model.CompoundModel;
import org.gvt.model.NodeModel;
import org.gvt.model.biopaxl2.BioPAXNode;
import org.gvt.model.biopaxl2.Control;
import org.gvt.model.biopaxl2.EffectorSecondHalf;
import org.gvt.model.biopaxl2.NonModulatedEffector;
import org.gvt.util.ID;
import org.patika.mada.graph.GraphObject;

public class Hub
extends BioPAXNode {
    private interaction inter;
    private List<physicalEntityParticipant> peps;
    private static final Color COLOR = new Color(null, 100, 100, 100);

    public Hub(CompoundModel root) {
        super(root);
        this.setShape("Ellipse");
        this.setColor(COLOR);
        this.setText("");
        this.setSize(new Dimension(9, 9));
    }

    public Hub(CompoundModel root, interaction inter, List<physicalEntityParticipant> peps, Map<String, NodeModel> map) {
        this(root);
        this.inter = inter;
        this.peps = peps;
        this.setTooltipText(inter.getNAME());
        this.extractReferences(inter);
        this.buildConnections(root, map);
    }

    public Hub(Hub excised, CompoundModel root) {
        super(excised, root);
        this.inter = excised.getInteraction();
        this.peps = excised.getParticipants();
    }

    public interaction getInteraction() {
        return this.inter;
    }

    @Override
    public boolean isEvent() {
        return true;
    }

    public List<physicalEntityParticipant> getParticipants() {
        return this.peps;
    }

    @Override
    public Collection<? extends Level2Element> getRelatedModelElements() {
        return Arrays.asList(this.inter);
    }

    private void buildConnections(CompoundModel root, Map<String, NodeModel> map) {
        for (control c : this.inter.isCONTROLLEDOf()) {
            if (map.containsKey(ID.get(c))) {
                Control mod = (Control)map.get(ID.get(c));
                new EffectorSecondHalf(mod, this, mod.getControl());
                continue;
            }
            if (c.isCONTROLLEDOf().isEmpty() && c.getCONTROLLER().size() == 1) {
                NodeModel source = map.get(ID.get(c.getCONTROLLER().iterator().next()));
                new NonModulatedEffector(source, this, c, c.getCONTROLLER().iterator().next(), this.inter);
                continue;
            }
            Control ctrl = new Control(root, c, this, map);
            map.put(ID.get(c), ctrl);
        }
    }

    public static String getPossibleCompartmentName(Collection<physicalEntityParticipant> peps) {
        HashSet<String> names = new HashSet<String>();
        for (physicalEntityParticipant par : peps) {
            if (par.getCELLULAR_LOCATION() == null) continue;
            names.add(par.getCELLULAR_LOCATION().getTERM().iterator().next());
        }
        if (names.size() == 1) {
            return (String)names.iterator().next();
        }
        return null;
    }

    @Override
    public Set<GraphObject> getRequisites() {
        Set<GraphObject> reqs = super.getRequisites();
        reqs.addAll(this.getSourceConnections());
        reqs.addAll(this.getTargetConnections());
        return reqs;
    }

    @Override
    public String getIDHash() {
        return ID.get(this.inter);
    }

    @Override
    public List<String[]> getInspectable() {
        List<String[]> list = super.getInspectable();
        Hub.addNamesAndTypeAndID(list, this.inter);
        for (evidence ev : this.inter.getEVIDENCE()) {
            list.add(new String[]{"Evidence", ev.toString()});
        }
        Hub.addDataSourceAndXrefAndComments(list, this.inter);
        return list;
    }
}

