/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.biopaxl2;

import java.util.ArrayList;
import org.biopax.paxtools.model.level2.Level2Element;
import org.eclipse.draw2d.geometry.Point;
import org.gvt.model.NodeModel;
import org.gvt.model.biopaxl2.BioPAXL2Graph;
import org.gvt.model.biopaxl2.Compartment;
import org.gvt.model.biopaxl2.IBioPAXL2Node;

public class NodeUtil {
    private IBioPAXL2Node node;

    public NodeUtil(IBioPAXL2Node node) {
        this.node = node;
    }

    public BioPAXL2Graph getGraph() {
        NodeModel parent = (NodeModel)((Object)this.node);
        while ((parent = parent.getParentModel()) != null && !(parent instanceof BioPAXL2Graph)) {
        }
        return (BioPAXL2Graph)parent;
    }

    public Compartment getCompartment() {
        NodeModel parent = (NodeModel)((Object)this.node);
        while ((parent = parent.getParentModel()) != null && !(parent instanceof Compartment)) {
        }
        return (Compartment)parent;
    }

    public String fetchModelTag(String type) {
        String prefix = this.node.getIDHash() + "@" + type;
        for (Level2Element level2Element : this.node.getRelatedModelElements()) {
            for (String comment : level2Element.getCOMMENT()) {
                if (!comment.startsWith(prefix)) continue;
                return comment.substring(prefix.length() + 1);
            }
        }
        return null;
    }

    public boolean hasModelTag(String type) {
        String prefix = this.node.getIDHash() + "@" + type;
        for (Level2Element level2Element : this.node.getRelatedModelElements()) {
            for (String comment : level2Element.getCOMMENT()) {
                if (!comment.startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    public void recordModelTag(String type, String tag) {
        String prefix = this.node.getIDHash() + "@" + type;
        tag = prefix + "@" + tag;
        for (Level2Element level2Element : this.node.getRelatedModelElements()) {
            this.removeCommentStartsWith(level2Element, prefix);
            level2Element.addCOMMENT(tag);
        }
    }

    public void removeModelTag(String type) {
        String prefix = this.node.getIDHash() + "@" + type;
        for (Level2Element level2Element : this.node.getRelatedModelElements()) {
            this.removeCommentStartsWith(level2Element, prefix);
        }
    }

    private void removeCommentStartsWith(Level2Element element, String prefix) {
        for (String com : new ArrayList<String>(element.getCOMMENT())) {
            if (!com.startsWith(prefix)) continue;
            element.removeCOMMENT(com);
        }
    }

    public String getIDHash() {
        return this.node.getName() != null ? this.node.getName() : "";
    }

    public boolean fetchLocation(String pathwayRDFID) {
        String type;
        String tag;
        if (pathwayRDFID == null) {
            pathwayRDFID = this.getGraph().getPathway().getRDFID();
        }
        if ((tag = this.fetchModelTag(type = "Layout@" + pathwayRDFID)) == null) {
            return false;
        }
        String[] terms = tag.split("@");
        assert (terms.length == 2) : "terms length: " + terms.length + "\n" + tag;
        this.node.setLocationAbs(new Point(Integer.parseInt(terms[0]), Integer.parseInt(terms[1])));
        return true;
    }

    public void recordLocation() {
        String pathwayRDFID = this.getGraph().getPathway().getRDFID();
        String type = "Layout@" + pathwayRDFID;
        String tag = this.node.getLocationAbs().x + "@" + this.node.getLocationAbs().y;
        this.recordModelTag(type, tag);
    }

    public void eraseLocation() {
        String pathwayRDFID = this.getGraph().getPathway().getRDFID();
        String type = "Layout@" + pathwayRDFID;
        this.removeModelTag(type);
    }
}

