/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.biopaxl3;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.biopax.paxtools.model.level3.ControlledVocabulary;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.FragmentFeature;
import org.biopax.paxtools.model.level3.Level3Element;
import org.biopax.paxtools.model.level3.ModificationFeature;
import org.biopax.paxtools.model.level3.Named;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.SequenceLocation;
import org.biopax.paxtools.model.level3.SequenceModificationVocabulary;
import org.biopax.paxtools.model.level3.SequenceSite;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.SmallMolecule;
import org.biopax.paxtools.model.level3.SmallMoleculeReference;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.pattern.util.Blacklist;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.gvt.model.CompoundModel;
import org.gvt.model.EntityAssociated;
import org.gvt.model.biopaxl3.BioPAXNode;
import org.gvt.model.biopaxl3.EffectorFirstHalf;
import org.gvt.model.biopaxl3.Member;
import org.gvt.model.biopaxl3.NonModulatedEffector;
import org.gvt.util.Conf;
import org.gvt.util.EntityHolder;
import org.gvt.util.ID;
import org.patika.mada.graph.Edge;
import org.patika.mada.graph.GraphObject;
import org.patika.mada.graph.Node;

public class Actor
extends BioPAXNode
implements EntityAssociated {
    protected EntityHolder entity;
    protected Entity related;
    int multimerNo;
    private static Blacklist blacklist;
    static boolean showFragmentFeature;
    public static final int DEFAULT_HEIGHT = 20;
    public static final int DEFAULT_UBIQUE_HEIGHT = 15;
    public static final int DEFAULT_INFO_BULB = 6;
    public static final int MIN_INITIAL_WIDTH = 40;
    public static final Color SMALL_MOL_BG_COLOR;
    public static final Color UBIQUE_BORDER_COLOR;

    public Actor(CompoundModel root) {
        super(root);
        this.setColor(new Color(null, 150, 150, 150));
        this.setText("Actor");
        this.setSize(new Dimension(50, 20));
        this.setShape("RoundRect");
    }

    public Actor(CompoundModel root, PhysicalEntity entity2, Entity related) {
        this(root);
        this.entity = new EntityHolder(entity2);
        this.related = related;
        this.multimerNo = 1;
        this.configFromModel();
    }

    public Actor(CompoundModel root, EntityReference entity2, Entity related) {
        this(root);
        this.entity = new EntityHolder(entity2);
        this.related = related;
        this.multimerNo = 1;
        this.configFromModel();
    }

    public Actor(Actor excised, CompoundModel root) {
        super(excised, root);
        this.entity = excised.getEntity();
        this.related = excised.getRelated();
        this.multimerNo = excised.multimerNo;
        this.getReferences().clear();
        this.configFromModel();
    }

    public int getMultimerNo() {
        return this.multimerNo;
    }

    public void setMultimerNo(int multimerNo) {
        this.multimerNo = multimerNo;
    }

    public boolean isMultimer() {
        return this.multimerNo > 1;
    }

    @Override
    public void configFromModel() {
        int width;
        int height;
        String names = this.extractReferences(this.entity.getNamed());
        String name = Actor.getDisplayName(this.entity.getNamed());
        this.setText(name);
        this.setTooltipText(names);
        List<String> infos = this.getInfoStrings();
        if (this.isUbique()) {
            height = infos.isEmpty() ? 15 : 27;
            FontData data = this.getTextFont().getFontData()[0];
            data.setHeight(6);
            this.setTextFont(new Font(null, data));
            if (this.getName().startsWith("Phosphate") || this.getName().startsWith("phosphate") || this.getName().startsWith("Orthophosphate") || this.getName().startsWith("orthophosphate") || this.getName().startsWith("PPi") || this.getName().equals("Pi")) {
                this.setText("P");
            } else if (this.getName().startsWith("NTP [")) {
                this.setText("NTP");
            }
            width = Math.max(this.suggestInitialWidth(), 15);
            this.setBorderColor(UBIQUE_BORDER_COLOR);
        } else {
            width = this.suggestInitialWidth();
            if (!this.isSmallMolecule(this.entity) && width < 40) {
                width = 40;
            }
            height = infos.isEmpty() ? 20 : 32;
        }
        this.setSize(new Dimension(width, height));
        if (this.isSmallMolecule(this.entity)) {
            this.setColor(SMALL_MOL_BG_COLOR);
        } else {
            this.setColor(this.getEntitySpecificColor());
        }
        String shp = "RoundRect";
        if (!infos.isEmpty()) {
            shp = shp + "WithInfo";
            for (String info : infos) {
                shp = shp + ";" + info;
            }
        }
        this.setShape(shp);
    }

    private boolean isSmallMolecule(EntityHolder ent) {
        return ent.getNamed() instanceof SmallMolecule || ent.getNamed() instanceof SmallMoleculeReference;
    }

    @Override
    public EntityHolder getEntity() {
        return this.entity;
    }

    public Entity getRelated() {
        return this.related;
    }

    public void setRelated(Entity related) {
        this.related = related;
    }

    @Override
    public Collection<? extends Level3Element> getRelatedModelElements() {
        HashSet<Named> col = new HashSet<Named>();
        col.add(this.entity.getNamed());
        return col;
    }

    public static String getShortestNameInParanthesis(String longName) {
        int i;
        int mark = 0;
        String shortName = longName;
        while ((i = longName.indexOf("(", mark)) > 0 && longName.indexOf(")", i) > i) {
            String s = longName.substring(longName.indexOf("(", mark) + 1, longName.indexOf(")", i));
            mark = longName.indexOf(")", i);
            if (s.length() >= shortName.length()) continue;
            shortName = s;
        }
        return shortName;
    }

    public List<String> getInfoStrings() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.entity.l3pe != null) {
            this.extractFeatures(list, this.entity.l3pe.getFeature(), false);
            this.extractFeatures(list, this.entity.l3pe.getNotFeature(), true);
        }
        return list;
    }

    private void extractFeatures(List<String> list, Set<EntityFeature> feats, boolean not) {
        for (EntityFeature feat : feats) {
            String featStr = null;
            if (feat instanceof ModificationFeature) {
                ModificationFeature mf = (ModificationFeature)feat;
                SequenceModificationVocabulary voc = mf.getModificationType();
                if (voc != null) {
                    Set<String> terms = voc.getTerm();
                    if (!terms.isEmpty()) {
                        if (terms.size() > 1) {
                            System.err.print("Terms has more than one term. First: ");
                            Iterator<String> iter = terms.iterator();
                            System.err.print(iter.next() + "  Second:");
                            System.err.println(iter.next());
                        }
                        featStr = terms.iterator().next();
                    }
                } else {
                    featStr = "?";
                }
            } else if (showFragmentFeature && feat instanceof FragmentFeature) {
                featStr = "fragment";
            }
            if (featStr == null) continue;
            SequenceLocation loc = feat.getFeatureLocation();
            if (loc instanceof SequenceSite) {
                SequenceSite ss = (SequenceSite)loc;
                featStr = featStr + " @" + ss.getSequencePosition();
            }
            if (not) {
                featStr = "-" + featStr;
            }
            list.add(featStr);
        }
    }

    public boolean hasInfoString() {
        if (this.entity.l3pe != null) {
            for (EntityFeature feat : this.entity.l3pe.getFeature()) {
                if (!(feat instanceof ModificationFeature) && !(feat instanceof FragmentFeature)) continue;
                return true;
            }
        }
        return false;
    }

    public Color getEntitySpecificColor() {
        EntityHolder ent = this.getEntity();
        if (ent.l3er != null) {
            return super.getStringSpecificColor(ID.get(ent.l3er));
        }
        if (ent.l3pe != null) {
            List<String> memErs = this.getMemberEntityIDs(ent.l3pe, new ArrayList<String>());
            if (!memErs.isEmpty()) {
                Collections.sort(memErs);
                String s = "";
                for (String memEr : memErs) {
                    s = s + memEr;
                }
                return super.getStringSpecificColor(s);
            }
            return super.getStringSpecificColor(ID.get(ent.l3pe));
        }
        return null;
    }

    protected List<String> getMemberEntityIDs(PhysicalEntity pe, List<String> list) {
        for (PhysicalEntity mem : pe.getMemberPhysicalEntity()) {
            if (!(mem instanceof SimplePhysicalEntity)) continue;
            SimplePhysicalEntity spe = (SimplePhysicalEntity)mem;
            EntityReference er = spe.getEntityReference();
            if (er != null) {
                if (list.contains(ID.get(er))) continue;
                list.add(ID.get(er));
                continue;
            }
            this.getMemberEntityIDs(spe, list);
        }
        return list;
    }

    @Override
    public boolean isEvent() {
        return false;
    }

    @Override
    public boolean sameEntity(Node n) {
        return n instanceof Actor && this.entity.equals(((Actor)n).getEntity());
    }

    @Override
    public boolean isBreadthNode() {
        return true;
    }

    @Override
    public String getIDHash() {
        return this.entity.getID() + (this.related != null ? ID.get(this.related) : "");
    }

    public boolean isUbique() {
        return this.entity.l3pe != null && Actor.isIDUbique(this.entity.l3pe);
    }

    public static boolean isUbique(PhysicalEntity pe) {
        return Actor.isIDUbique(pe) || pe instanceof SmallMolecule && Actor.isUbiqueName(pe.getDisplayName());
    }

    public static boolean isIDUbique(PhysicalEntity pe) {
        if (blacklist == null) {
            blacklist = Actor.fetchBlackListFromPC();
        }
        return blacklist.isUbique(pe);
    }

    public static Blacklist getBlackList() {
        if (blacklist == null) {
            blacklist = Actor.fetchBlackListFromPC();
        }
        return blacklist;
    }

    public static boolean isUbiqueName(String name) {
        return name != null && (name.startsWith("ATP") || name.startsWith("ADP") || name.startsWith("AMP") || name.startsWith("adenosine 5'-monophosphate") || name.startsWith("H2O") || name.startsWith("H+") || name.startsWith("Oxygen") || name.startsWith("O2") || name.startsWith("CO2") || name.startsWith("GDP") || name.startsWith("GTP") || name.startsWith("PPi") || name.equals("Pi") || name.equals("NAD") || name.equals("NADH") || name.equals("NAD+") || name.equals("NADP") || name.equals("NADPH") || name.equals("NADP+") || name.equals("FAD") || name.equals("FADH") || name.equals("FADH2") || name.startsWith("Phosphate") || name.startsWith("phosphate") || name.startsWith("Orthophosphate") || name.startsWith("orthophosphate") || name.startsWith("NTP"));
    }

    private boolean isEffector() {
        for (Edge edge : this.getDownstream()) {
            if (!(edge instanceof EffectorFirstHalf) && !(edge instanceof NonModulatedEffector)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String[]> getInspectable() {
        List<String[]> list = super.getInspectable();
        Actor.addNamesAndTypeAndID(list, this.entity.getNamed());
        ControlledVocabulary voc = null;
        if (this.entity.l3pe != null) {
            voc = this.entity.l3pe.getCellularLocation();
        }
        if (voc != null && !voc.getTerm().isEmpty()) {
            list.add(new String[]{"Location", voc.getTerm().iterator().next()});
        }
        for (String info : this.getInfoStrings()) {
            String type = Character.isDigit(info.charAt(0)) ? "Stochiometry" : "Modification";
            list.add(new String[]{type, info});
        }
        Actor.addDataSourceAndXrefAndComments(list, this.entity.getNamed());
        EntityHolder ent = this.getEntity();
        if (ent.l3er != null) {
            Actor.addNamesAndTypeAndID(list, ent.l3er);
            for (Xref xr : ent.l3er.getXref()) {
                list.add(new String[]{"Reference", xr.toString()});
            }
        }
        return list;
    }

    @Override
    public Set<GraphObject> getRequisites() {
        Set<GraphObject> reqs = super.getRequisites();
        for (Object o : this.getTargetConnections()) {
            if (!(o instanceof Member)) continue;
            reqs.add((Member)o);
        }
        return reqs;
    }

    private static Blacklist fetchBlackListFromPC() {
        try {
            String blacklistURL = Conf.getBlacklistURL();
            if (blacklistURL.startsWith("http://")) {
                URL url = new URL(blacklistURL);
                URLConnection con = url.openConnection();
                return new Blacklist((InputStream)con.getContent());
            }
            return new Blacklist(blacklistURL);
        }
        catch (Exception e) {
            System.out.println("Cannot fetch blacklist from Pathway Commons.");
            return new Blacklist();
        }
    }

    static {
        showFragmentFeature = Conf.getBoolean("DISPLAY_FRAGMENT_FEATURE");
        SMALL_MOL_BG_COLOR = new Color(null, 255, 255, 255);
        UBIQUE_BORDER_COLOR = new Color(null, 130, 130, 130);
    }
}

