/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.biopaxl3;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.ControlType;
import org.biopax.paxtools.model.level3.Controller;
import org.biopax.paxtools.model.level3.Evidence;
import org.biopax.paxtools.model.level3.Level3Element;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.Process;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;
import org.gvt.model.CompoundModel;
import org.gvt.model.NodeModel;
import org.gvt.model.biopaxl3.Actor;
import org.gvt.model.biopaxl3.BioPAXNode;
import org.gvt.model.biopaxl3.EffectorFirstHalf;
import org.gvt.model.biopaxl3.EffectorSecondHalf;
import org.gvt.util.ID;
import org.gvt.util.NodeProvider;
import org.patika.mada.graph.GraphObject;

public class ChbControl
extends BioPAXNode {
    Control con;
    private static final Color COLOR_ACTIVATE = new Color(null, 170, 170, 170);
    private static final Color COLOR_INHIBIT = new Color(null, 170, 170, 170);
    public static final Color EDGE_COLOR_ACTIVATE = new Color(null, 50, 150, 50);
    public static final Color EDGE_COLOR_INHIBIT = new Color(null, 150, 50, 50);

    public ChbControl(CompoundModel root) {
        super(root);
        this.setColor(COLOR_ACTIVATE);
        this.setText("");
        this.setSize(new Dimension(9, 9));
        this.setShape("Diamond");
    }

    public ChbControl(CompoundModel root, Control con, NodeProvider provider) {
        this(root);
        NodeModel node;
        provider.register(ID.get(con), this);
        for (Controller controller : con.getController()) {
            if (!provider.needsToBeDisplayed(ID.get(controller))) continue;
            node = provider.getNode(ID.get(controller), root);
            new EffectorFirstHalf(node, this);
            if (!(node instanceof Actor) || !((Actor)node).isUbique()) continue;
            ((Actor)node).setRelated(con);
        }
        for (Process process2 : con.getControlled()) {
            if (!provider.needsToBeDisplayed(ID.get(process2))) continue;
            node = provider.getNode(ID.get(process2), root);
            if (!(process2 instanceof Pathway) || node == null) continue;
            new EffectorSecondHalf(this, node, con);
        }
        this.createControlOverInteraction(root, con, provider);
        this.con = con;
        this.configFromModel();
    }

    public static boolean controlNeedsToBeANode(Control ctrl, NodeProvider prov) {
        int controllerCnt = 0;
        for (Controller controller : ctrl.getController()) {
            if (!prov.needsToBeDisplayed(ID.get(controller))) continue;
            ++controllerCnt;
        }
        if (controllerCnt != 1) {
            return true;
        }
        for (Control control2 : ctrl.getControlledOf()) {
            if (!prov.needsToBeDisplayed(ID.get(control2))) continue;
            return true;
        }
        int tarCnt = 0;
        for (Process process2 : ctrl.getControlled()) {
            if (!prov.needsToBeDisplayed(ID.get(process2))) continue;
            ++tarCnt;
        }
        return tarCnt == 0;
    }

    @Override
    public void configFromModel() {
        super.configFromModel();
        this.setTooltipText(this.con.getStandardName());
        this.setColor(ChbControl.isActivation(this.con) ? COLOR_ACTIVATE : COLOR_INHIBIT);
    }

    public ChbControl(ChbControl excised, CompoundModel root) {
        super(excised, root);
        this.con = excised.getControl();
    }

    public Control getControl() {
        return this.con;
    }

    public static boolean isActivation(Control cont) {
        boolean isActivation = true;
        ControlType type = cont.getControlType();
        if (type != null) {
            if (type == ControlType.ACTIVATION || type == ControlType.ACTIVATION_ALLOSTERIC || type == ControlType.ACTIVATION_NONALLOSTERIC || type == ControlType.ACTIVATION_UNKMECH) {
                isActivation = true;
            } else if (type == ControlType.INHIBITION || type == ControlType.INHIBITION_ALLOSTERIC || type == ControlType.INHIBITION_COMPETITIVE || type == ControlType.INHIBITION_IRREVERSIBLE || type == ControlType.INHIBITION_NONCOMPETITIVE || type == ControlType.INHIBITION_OTHER || type == ControlType.INHIBITION_UNCOMPETITIVE || type == ControlType.INHIBITION_UNKMECH) {
                isActivation = false;
            } else assert (false) : "Unknown control type: " + (Object)((Object)type);
        }
        return isActivation;
    }

    @Override
    public Collection<? extends Level3Element> getRelatedModelElements() {
        return Arrays.asList(this.con);
    }

    @Override
    public boolean isEvent() {
        return true;
    }

    @Override
    public Set<GraphObject> getRequisites() {
        Set<GraphObject> reqs = super.getRequisites();
        reqs.addAll(this.getSourceConnections());
        reqs.addAll(this.getTargetConnections());
        return reqs;
    }

    @Override
    public List<String[]> getInspectable() {
        List<String[]> list = super.getInspectable();
        ChbControl.addNamesAndTypeAndID(list, this.con);
        for (Evidence ev : this.con.getEvidence()) {
            list.add(new String[]{"Evidence", ev.toString()});
        }
        if (!this.con.getInteractionType().isEmpty()) {
            String s = ChbControl.formatInString(this.con.getInteractionType());
            list.add(new String[]{"Interaction Type", s});
        }
        if (this.con.getControlType() != null) {
            list.add(new String[]{"Control Type", this.con.getControlType().toString()});
        }
        ChbControl.addDataSourceAndXrefAndComments(list, this.con);
        return list;
    }

    @Override
    public String getIDHash() {
        return ID.get(this.con);
    }
}

