/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.custom;

import java.util.HashMap;
import java.util.Map;
import org.gvt.command.AddCommand;
import org.gvt.command.CreateCommand;
import org.gvt.command.OrphanChildCommand;
import org.gvt.command.ReconnectConnectionCommand;
import org.gvt.model.CompoundModel;
import org.gvt.model.NodeModel;
import org.gvt.model.custom.CustomEdge;
import org.gvt.model.custom.CustomGraph;
import org.gvt.model.custom.CustomNode;

public class CustomGroup
extends CompoundModel {
    public CustomGroup(CompoundModel root, Map<String, String> props, Map<String, NodeModel> nodeMap) {
        CreateCommand command = new CreateCommand(root, this);
        command.execute();
        if (props.containsKey("TEXT")) {
            this.setText(props.get("TEXT"));
        } else {
            this.setText("group");
        }
        if (props.containsKey("TOOLTIP")) {
            this.setTooltipText(props.get("TOOLTIP"));
        }
        if (props.containsKey("BGCOLOR")) {
            this.setColor(CustomGraph.textToColor(props.get("BGCOLOR")));
        }
        if (props.containsKey("BORDERCOLOR")) {
            this.setBorderColor(CustomGraph.textToColor(props.get("BORDERCOLOR")));
        }
        if (props.containsKey("TEXTCOLOR")) {
            this.setTextColor(CustomGraph.textToColor(props.get("TEXTCOLOR")));
        }
        HashMap<NodeModel, NodeModel> old2new = new HashMap<NodeModel, NodeModel>();
        if (props.containsKey("MEMBERS")) {
            String[] members = props.get("MEMBERS").split(":");
            for (String mem : members) {
                if (mem.isEmpty()) continue;
                assert (nodeMap.containsKey(mem)) : "Member node not found: " + mem;
                NodeModel node = nodeMap.get(mem);
                if (node.getParentModel() instanceof CustomGroup) {
                    NodeModel old = node;
                    if (old instanceof CustomNode) {
                        node = new CustomNode((CompoundModel)this, (CustomNode)old);
                        ((CustomNode)old).duplicate = true;
                        ((CustomNode)node).duplicate = true;
                    } else if (old instanceof CustomGroup) {
                        throw new RuntimeException("Missing implementation!");
                    }
                    old2new.put(old, node);
                    continue;
                }
                OrphanChildCommand orphan = new OrphanChildCommand();
                orphan.setParent(node.getParentModel());
                orphan.setChild(node);
                orphan.execute();
                AddCommand add = new AddCommand();
                add.setParent(this);
                add.setChild(node);
                add.execute();
            }
            for (NodeModel old : old2new.keySet()) {
                NodeModel newMate;
                NodeModel mate;
                CustomEdge edge;
                for (Object o : old.getSourceConnections()) {
                    edge = (CustomEdge)o;
                    assert (edge.getSource() == old);
                    mate = edge.getTarget();
                    if (!old2new.keySet().contains(mate)) continue;
                    newMate = (NodeModel)old2new.get(mate);
                    new CustomEdge((NodeModel)old2new.get(old), newMate, edge);
                }
                for (Object o : old.getTargetConnections()) {
                    edge = (CustomEdge)o;
                    assert (edge.getTarget() == old);
                    mate = edge.getSource();
                    if (!old2new.keySet().contains(mate)) continue;
                    newMate = (NodeModel)old2new.get(mate);
                    new CustomEdge(newMate, (NodeModel)old2new.get(old), edge);
                }
            }
            for (Object o : this.getChildren()) {
                ReconnectConnectionCommand com;
                NodeModel mate;
                CustomEdge edge;
                NodeModel child = (NodeModel)o;
                if (old2new.values().contains(child)) continue;
                for (Object oo : child.getSourceConnections()) {
                    edge = (CustomEdge)oo;
                    mate = edge.getTarget();
                    if (!old2new.containsKey(mate)) continue;
                    com = new ReconnectConnectionCommand();
                    com.setConnectionModel(edge);
                    com.setNewTarget(old2new.get(mate));
                    com.execute();
                }
                for (Object oo : child.getTargetConnections()) {
                    edge = (CustomEdge)oo;
                    mate = edge.getSource();
                    if (!old2new.containsKey(mate)) continue;
                    com = new ReconnectConnectionCommand();
                    com.setConnectionModel(edge);
                    com.setNewSource(old2new.get(mate));
                    com.execute();
                }
            }
        }
    }
}

