/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.sifl3;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.pattern.miner.SIFEnum;
import org.biopax.paxtools.pattern.miner.SIFInteraction;
import org.biopax.paxtools.pattern.miner.SIFSearcher;
import org.biopax.paxtools.pattern.miner.SIFType;
import org.biopax.paxtools.pattern.util.Blacklist;
import org.eclipse.draw2d.geometry.Point;
import org.gvt.model.BioPAXGraph;
import org.gvt.model.CompoundModel;
import org.gvt.model.GraphObject;
import org.gvt.model.NodeModel;
import org.gvt.model.biopaxl3.BioPAXL3Graph;
import org.gvt.model.sifl3.SIFEdge;
import org.gvt.model.sifl3.SIFGroup;
import org.gvt.model.sifl3.SIFNode;
import org.gvt.util.Conf;
import org.gvt.util.EntityHolder;
import org.gvt.util.PathwayHolder;
import org.patika.mada.graph.Node;

public class SIFGraph
extends BioPAXL3Graph {
    private List<SIFType> ruleTypes;
    private Blacklist blacklist;

    public SIFGraph(Model biopaxModel, List<SIFType> ruleTypes, Blacklist blacklist) {
        super(biopaxModel);
        this.setBiopaxModel(biopaxModel);
        this.setGraphType("SIF_LEVEL3");
        this.ruleTypes = ruleTypes;
        this.blacklist = blacklist;
        this.createContents();
    }

    private void createContents() {
        Set<SIFInteraction> sifInts = this.getSimpleInteractions();
        HashMap<EntityHolder, SIFNode> map = new HashMap<EntityHolder, SIFNode>();
        HashSet<String> encountered = new HashSet<String>();
        for (SIFInteraction simpleInt : sifInts) {
            if (simpleInt.type == null) continue;
            EntityHolder source = new EntityHolder(simpleInt.sourceERs.iterator().next());
            EntityHolder target = new EntityHolder(simpleInt.targetERs.iterator().next());
            if (!map.containsKey(source)) {
                map.put(source, new SIFNode((CompoundModel)this, source));
            }
            if (!map.containsKey(target)) {
                map.put(target, new SIFNode((CompoundModel)this, target));
            }
            SIFNode sourceNode = (SIFNode)map.get(source);
            SIFNode targetNode = (SIFNode)map.get(target);
            String id = source.getID() + " - " + target.getID();
            if (encountered.contains(id)) continue;
            new SIFEdge(sourceNode, targetNode, simpleInt.type.getTag(), new HashSet<String>(Arrays.asList(simpleInt.getMediatorsInString().split(" |;"))));
            encountered.add(id);
            if (simpleInt.type.isDirected()) continue;
            encountered.add(target.getID() + " - " + source.getID());
        }
        if (Conf.getBoolean("USE_SIF_GROUPING")) {
            this.groupSimilarNodes();
        }
    }

    private Set<SIFInteraction> getSimpleInteractions() {
        SIFSearcher searcher = new SIFSearcher(this.ruleTypes.toArray(new SIFType[this.ruleTypes.size()]));
        searcher.setBlacklist(this.blacklist);
        return searcher.searchSIF(this.biopaxModel);
    }

    public static List<SIFType> getPossibleRuleTypes() {
        return new ArrayList<SIFType>(Arrays.asList(SIFEnum.values()));
    }

    public void writeLayout(OutputStream os) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os));
        for (Object o : this.getNodes()) {
            if (!(o instanceof SIFNode)) continue;
            SIFNode node = (SIFNode)o;
            Point p = node.getLocationAbs();
            writer.write(node.getText() + "\t" + p.x + "\t" + p.y + "\n");
        }
        writer.close();
    }

    public void loadLayout(Map<String, Point> locMap) {
        for (Object o : this.getNodes()) {
            SIFNode node;
            Point p;
            if (!(o instanceof SIFNode) || (p = locMap.get((node = (SIFNode)o).getText())) == null) continue;
            node.setLocationAbs(p);
        }
        for (Object o : this.getNodes()) {
            if (!(o instanceof CompoundModel)) continue;
            ((CompoundModel)o).calculateSizeUp();
        }
    }

    public void write(OutputStream os) {
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os));
            for (Object o : this.getEdges()) {
                SIFEdge edge = (SIFEdge)o;
                for (SIFNode sIFNode : this.getNonGroupNodes(edge.getSource())) {
                    for (SIFNode target : this.getNonGroupNodes(edge.getTarget())) {
                        writer.write(sIFNode.getText() + "\t");
                        writer.write(edge.getTag() + "\t");
                        writer.write(target.getText());
                        Set<String> mediators = edge.getMediators(new HashSet<GraphObject>(Arrays.asList(sIFNode, target)));
                        writer.write(mediators.isEmpty() ? "\n" : "\t");
                        String s = "";
                        for (String mediator : mediators) {
                            s = s + mediator + ";";
                        }
                        if (!mediators.isEmpty()) {
                            s = s.substring(0, s.length() - 1);
                        }
                        writer.write(s + "\n");
                    }
                }
            }
            for (Object o : this.getChildren()) {
                String text;
                if (!(o instanceof SIFGroup) || (text = ((SIFGroup)o).getText()) == null || text.isEmpty()) continue;
                for (String string : text.split(",")) {
                    String string2 = string.trim();
                    SIFEnum sifType = SIFEnum.typeOf(string2);
                    if (sifType == null) continue;
                    SIFNode[] members = this.getNonGroupNodes((SIFGroup)o);
                    for (int i = 0; i < members.length; ++i) {
                        for (int j = 0; j < members.length; ++j) {
                            if (i == j || !sifType.isDirected() && members[i].getText().compareTo(members[i].getText()) >= 0) continue;
                            writer.write(members[i].getText() + "\t");
                            writer.write(string2 + "\t");
                            writer.write(members[j].getText() + "\n");
                        }
                    }
                }
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private SIFNode[] getNonGroupNodes(NodeModel node) {
        if (node instanceof SIFGroup) {
            return ((SIFGroup)node).getChildren().toArray(new SIFNode[((SIFGroup)node).getChildren().size()]);
        }
        return new SIFNode[]{(SIFNode)node};
    }

    public void groupSimilarNodes() {
        HashMap<NodeModel, Set<String>> incomingMap = new HashMap<NodeModel, Set<String>>();
        HashMap<NodeModel, Set<String>> outgoingMap = new HashMap<NodeModel, Set<String>>();
        for (Object e : this.getNodes()) {
            String key;
            SIFEdge edge;
            NodeModel node = (NodeModel)e;
            if (!incomingMap.containsKey(node)) {
                incomingMap.put(node, new HashSet());
            }
            if (!outgoingMap.containsKey(node)) {
                outgoingMap.put(node, new HashSet());
            }
            for (Object oo : node.getTargetConnections()) {
                edge = (SIFEdge)oo;
                assert (edge.getTarget() == node);
                key = edge.getTag() + " " + edge.getSource().getText();
                ((Set)incomingMap.get(node)).add(key);
                if (edge.isDirected()) continue;
                ((Set)outgoingMap.get(node)).add(key);
            }
            for (Object oo : node.getSourceConnections()) {
                edge = (SIFEdge)oo;
                assert (edge.getSource() == node);
                key = edge.getTag() + " " + edge.getTarget().getText();
                ((Set)outgoingMap.get(node)).add(key);
                if (edge.isDirected()) continue;
                ((Set)incomingMap.get(node)).add(key);
            }
        }
        for (Set set : this.findGroups(this.getNodes(), incomingMap, outgoingMap)) {
            HashSet<SIFNode> members = new HashSet<SIFNode>();
            for (NodeModel m : set) {
                members.add((SIFNode)m);
            }
            new SIFGroup(this, members);
        }
    }

    private Set<Set<NodeModel>> findGroups(Collection<NodeModel> nodes, Map<NodeModel, Set<String>> incomingMap, Map<NodeModel, Set<String>> outgoingMap) {
        HashSet<Set<NodeModel>> groups = new HashSet<Set<NodeModel>>();
        for (NodeModel node : nodes) {
            Set<NodeModel> group = this.getSimilarNodes(node, nodes, incomingMap, outgoingMap);
            if (group.isEmpty() || this.contains(groups, group)) continue;
            groups.add(group);
        }
        return groups;
    }

    private boolean contains(Set<Set<NodeModel>> groups, Set<NodeModel> group) {
        for (Set<NodeModel> g : groups) {
            if (g.size() != group.size() || !g.containsAll(group)) continue;
            return true;
        }
        return false;
    }

    private Set<NodeModel> getSimilarNodes(NodeModel node, Collection<NodeModel> nodes, Map<NodeModel, Set<String>> incomingMap, Map<NodeModel, Set<String>> outgoingMap) {
        if (incomingMap.get(node).isEmpty() && outgoingMap.get(node).isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<NodeModel> sim = new HashSet<NodeModel>();
        for (NodeModel n : nodes) {
            if (!this.similar(n, node, incomingMap, outgoingMap)) continue;
            sim.add(n);
        }
        if (sim.size() > 1) {
            return sim;
        }
        return Collections.emptySet();
    }

    private boolean similar(NodeModel n1, NodeModel n2, Map<NodeModel, Set<String>> incomingMap, Map<NodeModel, Set<String>> outgoingMap) {
        if (incomingMap.get(n1).size() != incomingMap.get(n2).size() || outgoingMap.get(n1).size() != outgoingMap.get(n2).size()) {
            return false;
        }
        if (incomingMap.get(n1).containsAll((Collection)incomingMap.get(n2)) && outgoingMap.get(n1).containsAll((Collection)outgoingMap.get(n2))) {
            return true;
        }
        HashSet<String> n1_in = new HashSet<String>((Collection)incomingMap.get(n1));
        HashSet<String> n2_in = new HashSet<String>((Collection)incomingMap.get(n2));
        HashSet<String> n1_out = new HashSet<String>((Collection)outgoingMap.get(n1));
        HashSet<String> n2_out = new HashSet<String>((Collection)outgoingMap.get(n2));
        this.removeCommon(n1_in, n2_in);
        this.removeCommon(n1_out, n2_out);
        return this.containssOnlyInterEdges(n1.getText(), n2.getText(), this.getParsed(n1_in), this.getParsed(n2_in)) && this.containssOnlyInterEdges(n1.getText(), n2.getText(), this.getParsed(n1_out), this.getParsed(n2_out));
    }

    private void removeCommon(Set<String> set1, Set<String> set2) {
        HashSet<String> temp = new HashSet<String>(set1);
        set1.removeAll(set2);
        set2.removeAll(temp);
    }

    private boolean containssOnlyInterEdges(String name1, String name2, Map<String, Set<String>> edges1, Map<String, Set<String>> edges2) {
        for (String type : edges1.keySet()) {
            if (!edges2.containsKey(type)) {
                return false;
            }
            assert (!edges1.get(type).isEmpty());
            if (edges1.get(type).size() == 1 && edges1.get(type).iterator().next().equals(name2)) continue;
            return false;
        }
        for (String type : edges2.keySet()) {
            if (!edges1.containsKey(type)) {
                return false;
            }
            assert (!edges2.get(type).isEmpty());
            if (edges2.get(type).size() == 1 && edges2.get(type).iterator().next().equals(name1)) continue;
            return false;
        }
        return true;
    }

    private Map<String, Set<String>> getParsed(Set<String> edges) {
        HashMap<String, Set<String>> parsed = new HashMap<String, Set<String>>();
        for (String edge : edges) {
            String[] tok = edge.split(" ");
            if (!parsed.containsKey(tok[0])) {
                parsed.put(tok[0], new HashSet());
            }
            ((Set)parsed.get(tok[0])).add(tok[1]);
        }
        return parsed;
    }

    @Override
    public String getPathwayRDFID() {
        return null;
    }

    @Override
    public List<String[]> getInspectable() {
        return null;
    }

    @Override
    public BioPAXGraph excise(Collection<org.patika.mada.graph.GraphObject> objects, boolean keepHighlights) {
        return null;
    }

    @Override
    protected void prepareEntityToNodeMap() {
    }

    @Override
    public boolean fetchLayout() {
        return false;
    }

    @Override
    public boolean fetchLayout(String pathwayRDFID) {
        return false;
    }

    @Override
    public void recordLayout() {
    }

    @Override
    public void forgetLayout() {
    }

    @Override
    public Set<Node> getRelatedStates(EntityHolder pe) {
        return null;
    }

    @Override
    public Set<Node> getRelatedStates(Collection<EntityHolder> entities) {
        return null;
    }

    @Override
    public void replaceComplexMembersWithComplexes(Collection<Node> objects) {
    }

    @Override
    public BioPAXGraph excise(PathwayHolder p) {
        return null;
    }

    @Override
    public PathwayHolder getPathway() {
        return null;
    }

    @Override
    public void setPathway(PathwayHolder p) {
    }

    @Override
    public void registerContentsToPathway() {
    }
}

