/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.model.sifl3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.model.level3.Level3Element;
import org.eclipse.swt.graphics.Color;
import org.gvt.command.AddCommand;
import org.gvt.command.DeleteConnectionCommand;
import org.gvt.command.OrphanChildCommand;
import org.gvt.model.CompoundModel;
import org.gvt.model.EntityAssociated;
import org.gvt.model.GraphObject;
import org.gvt.model.NodeModel;
import org.gvt.model.biopaxl3.BioPAXCompoundNode;
import org.gvt.model.sifl3.SIFEdge;
import org.gvt.model.sifl3.SIFNode;
import org.gvt.util.EntityHolder;
import org.patika.mada.graph.Edge;

public class SIFGroup
extends BioPAXCompoundNode
implements EntityAssociated {
    private Set<String> mediators;
    private Map<GraphObject, Set<SIFEdge>> substitutionMap;
    private static final Color BG_COLOR = new Color(null, 255, 255, 255);
    private static final Color BORDER_COLOR = new Color(null, 150, 150, 150);
    private static final Color TEXT_COLOR = new Color(null, 0, 0, 0);

    public SIFGroup(CompoundModel root) {
        super(root);
        this.setLabelHeight(0);
        this.setText("");
    }

    @Override
    public Collection<? extends Level3Element> getRelatedModelElements() {
        return Collections.emptySet();
    }

    public SIFGroup(CompoundModel root, Collection<SIFNode> members) {
        this(root);
        for (SIFNode member : members) {
            OrphanChildCommand occ = new OrphanChildCommand();
            occ.setChild(member);
            occ.setParent(member.getParentModel());
            occ.execute();
            AddCommand add = new AddCommand();
            add.setParent(this);
            add.setChild(member);
            add.execute();
        }
        this.mergeEdges(members, true);
        this.mergeEdges(members, false);
        this.mergeEdges(members);
        this.mediators = new HashSet<String>();
        this.deleteInnerClique(members);
        this.setBorderColor(BORDER_COLOR);
        this.setColor(BG_COLOR);
        this.setTextColor(TEXT_COLOR);
    }

    protected void mergeEdges(Collection<SIFNode> members, boolean incoming) {
        HashMap map = new HashMap();
        for (SIFNode member : members) {
            for (Edge edge : incoming ? member.getUpstream() : member.getDownstream()) {
                SIFEdge edge2 = (SIFEdge)edge;
                if (!edge2.isDirected()) continue;
                NodeModel neigh = incoming ? edge2.getSource() : edge2.getTarget();
                String key = this.getKey(edge2, neigh);
                if (!map.containsKey(key)) {
                    map.put(key, new HashSet());
                }
                ((Set)map.get(key)).add(edge2);
            }
        }
        for (String key : map.keySet()) {
            if (((Set)map.get(key)).size() != members.size()) continue;
            this.createMergedEdge((Collection<SIFEdge>)((Collection)map.get(key)), incoming);
        }
    }

    protected void mergeEdges(Collection<SIFNode> members) {
        HashMap map = new HashMap();
        for (SIFNode member : members) {
            String key;
            NodeModel neigh;
            SIFEdge edge;
            for (Edge edge2 : member.getUpstream()) {
                edge = (SIFEdge)edge2;
                if (edge.isDirected()) continue;
                neigh = edge.getSource();
                key = this.getKey(edge, neigh);
                if (!map.containsKey(key)) {
                    map.put(key, new HashSet());
                }
                ((Set)map.get(key)).add(edge);
            }
            for (Edge edge3 : member.getDownstream()) {
                edge = (SIFEdge)edge3;
                if (edge.isDirected()) continue;
                neigh = edge.getTarget();
                key = this.getKey(edge, neigh);
                if (!map.containsKey(key)) {
                    map.put(key, new HashSet());
                }
                ((Set)map.get(key)).add(edge);
            }
        }
        for (String key : map.keySet()) {
            if (((Set)map.get(key)).size() != members.size()) continue;
            this.createMergedEdge((Collection<SIFEdge>)((Collection)map.get(key)), key.split(" ")[1]);
        }
    }

    private String getKey(SIFEdge edge, NodeModel node) {
        return edge.getTag() + " " + this.getNodeName(node);
    }

    private String getNodeName(NodeModel node) {
        if (node instanceof SIFGroup) {
            return ((SIFGroup)node).getMemberNames();
        }
        return node.getText();
    }

    private void createMergedEdge(Collection<SIFEdge> edges, boolean incoming) {
        SIFEdge sample = edges.iterator().next();
        SIFEdge merged = new SIFEdge(incoming ? sample.getSource() : this, incoming ? this : sample.getTarget(), sample.getTag(), null);
        for (SIFEdge edge : edges) {
            merged.addSubstitution(edge, incoming ? edge.getTarget() : edge.getSource());
            DeleteConnectionCommand command = new DeleteConnectionCommand();
            command.setConnectionModel(edge);
            command.execute();
        }
    }

    private void createMergedEdge(Collection<SIFEdge> edges, String commonNodeName) {
        SIFEdge sample = edges.iterator().next();
        boolean incoming = this.getNodeName(sample.getSource()).equals(commonNodeName);
        if (!incoming) assert (this.getNodeName(sample.getTarget()).equals(commonNodeName));
        SIFEdge merged = new SIFEdge(incoming ? sample.getSource() : this, incoming ? this : sample.getTarget(), sample.getTag(), null);
        for (SIFEdge edge : edges) {
            merged.addSubstitution(edge, incoming ? edge.getTarget() : edge.getSource());
            DeleteConnectionCommand command = new DeleteConnectionCommand();
            command.setConnectionModel(edge);
            command.execute();
        }
    }

    protected void deleteInnerClique(Collection<? extends NodeModel> members) {
        HashMap<NodeModel, Map<String, Set<SIFEdge>>> inMap = new HashMap<NodeModel, Map<String, Set<SIFEdge>>>();
        HashMap<NodeModel, Map<String, Set<SIFEdge>>> outMap = new HashMap<NodeModel, Map<String, Set<SIFEdge>>>();
        for (NodeModel nodeModel : members) {
            SIFEdge edge;
            if (!inMap.containsKey(nodeModel)) {
                inMap.put(nodeModel, new HashMap());
            }
            if (!outMap.containsKey(nodeModel)) {
                outMap.put(nodeModel, new HashMap());
            }
            for (Object o : nodeModel.getTargetConnections()) {
                edge = (SIFEdge)o;
                this.putInMap(inMap, nodeModel, edge, members);
                if (edge.isDirected()) continue;
                this.putInMap(outMap, nodeModel, edge, members);
            }
            for (Object o : nodeModel.getSourceConnections()) {
                edge = (SIFEdge)o;
                this.putInMap(outMap, nodeModel, edge, members);
                if (edge.isDirected()) continue;
                this.putInMap(inMap, nodeModel, edge, members);
            }
        }
        HashSet<Set<SIFEdge>> edgeSets = new HashSet<Set<SIFEdge>>();
        this.collectEdgeSets(members, inMap, edgeSets);
        this.collectEdgeSets(members, outMap, edgeSets);
        for (Set set : edgeSets) {
            this.deleteEdges(set);
        }
    }

    private void collectEdgeSets(Collection<? extends NodeModel> members, Map<NodeModel, Map<String, Set<SIFEdge>>> map, Set<Set<SIFEdge>> edgeSets) {
        for (String type : map.values().iterator().next().keySet()) {
            HashSet<SIFEdge> collectedEdges = new HashSet<SIFEdge>();
            boolean isAClique = true;
            for (NodeModel member : map.keySet()) {
                if (!map.get(member).containsKey(type)) break;
                Set<SIFEdge> edges = map.get(member).get(type);
                if (edges.size() == members.size() - 1 && !this.contains(edgeSets, edges)) {
                    collectedEdges.addAll(edges);
                    continue;
                }
                isAClique = false;
                break;
            }
            if (!isAClique) continue;
            edgeSets.add(collectedEdges);
        }
    }

    private boolean contains(Set<Set<SIFEdge>> edgeSets, Set<SIFEdge> edges) {
        for (Set<SIFEdge> set : edgeSets) {
            if (set.size() != edges.size() || !set.containsAll(edges)) continue;
            return true;
        }
        return false;
    }

    private void putInMap(Map<NodeModel, Map<String, Set<SIFEdge>>> map, NodeModel member, SIFEdge edge, Collection<? extends NodeModel> members) {
        if (!members.contains(edge.getSource()) || !members.contains(edge.getTarget())) {
            return;
        }
        if (!map.get(member).containsKey(edge.getTag())) {
            map.get(member).put(edge.getTag(), new HashSet());
        }
        map.get(member).get(edge.getTag()).add(edge);
    }

    private void deleteEdges(Set<SIFEdge> edges) {
        String type = edges.iterator().next().getTag();
        for (SIFEdge edge : edges) {
            this.mediators.addAll(edge.getMediators());
            DeleteConnectionCommand command = new DeleteConnectionCommand();
            command.setConnectionModel(edge);
            command.execute();
        }
        String text = this.getText().isEmpty() ? "" : ", ";
        text = text + type;
        this.setText(this.getText() + text);
        this.setLabelHeight(CompoundModel.LABEL_HEIGHT);
    }

    public String getMemberNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Object o : this.children) {
            if (!(o instanceof NodeModel)) continue;
            names.add(((NodeModel)o).getText());
        }
        Collections.sort(names);
        String s = "";
        for (String name : names) {
            s = s + name;
        }
        return s;
    }

    public Set<String> getMediators() {
        return this.mediators;
    }

    public Set<String> getMediators(Set<GraphObject> nodes) {
        if (nodes.isEmpty()) {
            return this.mediators;
        }
        if (this.substitutionMap == null) {
            return this.mediators;
        }
        HashSet edges = new HashSet();
        for (GraphObject node : nodes) {
            if (!this.substitutionMap.containsKey(node)) continue;
            edges.addAll(this.substitutionMap.get(node));
        }
        HashSet<String> meds = new HashSet<String>();
        for (SIFEdge edge : edges) {
            meds.addAll(edge.getMediators());
        }
        return meds;
    }

    public void addSubstitution(SIFEdge edge) {
        this.mediators.addAll(edge.getMediators());
        if (this.substitutionMap == null) {
            this.substitutionMap = new HashMap<GraphObject, Set<SIFEdge>>();
        }
        if (!this.substitutionMap.containsKey(edge.getSource())) {
            this.substitutionMap.put(edge.getSource(), new HashSet());
        }
        if (!this.substitutionMap.containsKey(edge.getTarget())) {
            this.substitutionMap.put(edge.getTarget(), new HashSet());
        }
        this.substitutionMap.get(edge.getSource()).add(edge);
        this.substitutionMap.get(edge.getTarget()).add(edge);
    }

    public SIFGroup(SIFGroup toexcise, CompoundModel root) {
        super(toexcise, root);
    }

    @Override
    public boolean isBreadthNode() {
        return true;
    }

    @Override
    public Set<org.patika.mada.graph.GraphObject> getRequisites() {
        Set<org.patika.mada.graph.GraphObject> reqs = super.getRequisites();
        reqs.addAll(this.getChildren());
        return reqs;
    }

    @Override
    public List<String[]> getInspectable() {
        return Collections.emptyList();
    }

    @Override
    public String getIDHash() {
        String hash = "";
        for (Object o : this.children) {
            hash = hash + ((SIFNode)o).getIDHash();
        }
        return hash;
    }

    @Override
    public EntityHolder getEntity() {
        return null;
    }
}

