/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.util.onotoa;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ImageConverter {
    private static final PaletteData PALETTE_DATA = new PaletteData(0xFF0000, 65280, 255);

    public static Image convert(BufferedImage srcImage) {
        ImageData swtImageData = new ImageData(srcImage.getWidth(), srcImage.getHeight(), 24, PALETTE_DATA);
        int scansize = (srcImage.getWidth() * 3 + 3) * 4 / 4;
        WritableRaster alphaRaster = srcImage.getAlphaRaster();
        byte[] alphaBytes = new byte[srcImage.getWidth()];
        for (int y = 0; y < srcImage.getHeight(); ++y) {
            int[] buff = srcImage.getRGB(0, y, srcImage.getWidth(), 1, null, 0, scansize);
            swtImageData.setPixels(0, y, srcImage.getWidth(), buff, 0);
            if (alphaRaster == null) continue;
            int[] alpha = alphaRaster.getPixels(0, y, srcImage.getWidth(), 1, (int[])null);
            for (int i = 0; i < srcImage.getWidth(); ++i) {
                alphaBytes[i] = (byte)alpha[i];
            }
            swtImageData.setAlphas(0, y, srcImage.getWidth(), alphaBytes, 0);
        }
        return new Image((Device)Display.getCurrent(), swtImageData);
    }

    public static BufferedImage convert(Image srcImage) {
        ImageData imageData = srcImage.getImageData();
        int width = imageData.width;
        int height = imageData.height;
        ImageData maskData = null;
        int[] alpha = new int[1];
        if (imageData.alphaData == null) {
            maskData = imageData.getTransparencyMask();
        }
        BufferedImage image = new BufferedImage(imageData.width, imageData.height, 2);
        WritableRaster alphaRaster = image.getAlphaRaster();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                RGB color = imageData.palette.getRGB(imageData.getPixel(x, y));
                image.setRGB(x, y, new Color(color.red, color.green, color.blue).getRGB());
                if (alphaRaster == null) continue;
                if (imageData.alphaData != null) {
                    alpha[0] = imageData.getAlpha(x, y);
                    alphaRaster.setPixel(x, y, alpha);
                    continue;
                }
                if (maskData == null) continue;
                alpha[0] = maskData.getPixel(x, y) == 0 ? 0 : 255;
                alphaRaster.setPixel(x, y, alpha);
            }
        }
        return image;
    }
}

