/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.ivis.layout.sbgn.SbgnPDNode;

public class Organization {
    private double width = 40.0;
    private double height = 40.0;
    private List<Double> rowWidth = new ArrayList<Double>();
    private List<Double> rowHeight = new ArrayList<Double>();
    private List<LinkedList<SbgnPDNode>> rows = new ArrayList<LinkedList<SbgnPDNode>>();

    public double getWidth() {
        this.shiftToLastRow();
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    private int getShortestRowIndex() {
        int r = -1;
        double min = Double.MAX_VALUE;
        for (int i = 0; i < this.rows.size(); ++i) {
            if (!(this.rowWidth.get(i) < min)) continue;
            r = i;
            min = this.rowWidth.get(i);
        }
        return r;
    }

    private int getLongestRowIndex() {
        int r = -1;
        double max = Double.MIN_VALUE;
        for (int i = 0; i < this.rows.size(); ++i) {
            if (!(this.rowWidth.get(i) > max)) continue;
            r = i;
            max = this.rowWidth.get(i);
        }
        return r;
    }

    public void insertNode(SbgnPDNode node) {
        if (this.rows.isEmpty()) {
            this.insertNodeToRow(node, 0);
        } else if (this.canAddHorizontal(node.getWidth(), node.getHeight())) {
            this.insertNodeToRow(node, this.getShortestRowIndex());
        } else {
            this.insertNodeToRow(node, this.rows.size());
        }
    }

    private void insertNodeToRow(SbgnPDNode node, int rowIndex) {
        if (rowIndex == this.rows.size()) {
            this.rows.add(new LinkedList());
            this.rowWidth.add(40.0);
            this.rowHeight.add(0.0);
            assert (this.rows.size() == this.rowWidth.size());
        }
        double w = this.rowWidth.get(rowIndex) + node.getWidth();
        if (!this.rows.get(rowIndex).isEmpty()) {
            w += 5.0;
        }
        this.rowWidth.set(rowIndex, w);
        if (this.width < w) {
            this.width = w;
        }
        double h = node.getHeight();
        if (rowIndex > 0) {
            h += 5.0;
        }
        double extraHeight = 0.0;
        if (h > this.rowHeight.get(rowIndex)) {
            extraHeight = this.rowHeight.get(rowIndex);
            this.rowHeight.set(rowIndex, h);
            extraHeight = this.rowHeight.get(rowIndex) - extraHeight;
        }
        this.height += extraHeight;
        this.rows.get(rowIndex).add(node);
    }

    private void shiftToLastRow() {
        int longest = this.getLongestRowIndex();
        int last = this.rowWidth.size() - 1;
        LinkedList<SbgnPDNode> row = this.rows.get(longest);
        SbgnPDNode node = row.getLast();
        double diff = node.getWidth() + 5.0;
        if (this.width - this.rowWidth.get(last) > diff && this.rowHeight.get(last) > node.getHeight()) {
            row.removeLast();
            this.rows.get(last).add(node);
            this.rowWidth.set(longest, this.rowWidth.get(longest) - diff);
            this.rowWidth.set(last, this.rowWidth.get(last) + diff);
            this.width = this.rowWidth.get(this.getLongestRowIndex());
            double maxHeight = Double.MIN_VALUE;
            for (int i = 0; i < row.size(); ++i) {
                if (!(row.get(i).getHeight() > maxHeight)) continue;
                maxHeight = row.get(i).getHeight();
            }
            if (longest > 0) {
                maxHeight += 5.0;
            }
            double prevTotal = this.rowHeight.get(longest) + this.rowHeight.get(last);
            this.rowHeight.set(longest, maxHeight);
            if (this.rowHeight.get(last) < node.getHeight() + 5.0) {
                this.rowHeight.set(last, node.getHeight() + 5.0);
            }
            double finalTotal = this.rowHeight.get(longest) + this.rowHeight.get(last);
            this.height += finalTotal - prevTotal;
            this.shiftToLastRow();
        }
    }

    private boolean canAddHorizontal(double extraWidth, double extraHeight) {
        int sri = this.getShortestRowIndex();
        if (sri < 0) {
            return true;
        }
        double min = this.rowWidth.get(sri);
        double hDiff = 0.0;
        if (this.rowHeight.get(sri) < extraHeight && sri > 0) {
            hDiff = extraHeight + 5.0 - this.rowHeight.get(sri);
        }
        if (this.width - min >= extraWidth + 5.0) {
            return true;
        }
        return this.height + hDiff > min + extraWidth + 5.0;
    }

    public void adjustLocations(double x, double y) {
        y += 20.0;
        double left = x += 20.0;
        for (LinkedList<SbgnPDNode> row : this.rows) {
            x = left;
            double maxHeight = 0.0;
            for (SbgnPDNode node : row) {
                node.setLocation(x, y);
                x += node.getWidth() + 5.0;
                if (!(node.getHeight() > maxHeight)) continue;
                maxHeight = node.getHeight();
            }
            y += maxHeight + 5.0;
        }
    }
}

