/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.util;

import org.ivis.util.DimensionD;
import org.ivis.util.PointD;
import org.ivis.util.RectangleD;

public class Transform {
    private double lworldOrgX;
    private double lworldOrgY;
    private double lworldExtX;
    private double lworldExtY;
    private double ldeviceOrgX;
    private double ldeviceOrgY;
    private double ldeviceExtX;
    private double ldeviceExtY;

    public Transform() {
        this.init();
    }

    void init() {
        this.lworldOrgX = 0.0;
        this.lworldOrgY = 0.0;
        this.ldeviceOrgX = 0.0;
        this.ldeviceOrgY = 0.0;
        this.lworldExtX = 1.0;
        this.lworldExtY = 1.0;
        this.ldeviceExtX = 1.0;
        this.ldeviceExtY = 1.0;
    }

    public double getWorldOrgX() {
        return this.lworldOrgX;
    }

    public void setWorldOrgX(double wox) {
        this.lworldOrgX = wox;
    }

    public double getWorldOrgY() {
        return this.lworldOrgY;
    }

    public void setWorldOrgY(double woy) {
        this.lworldOrgY = woy;
    }

    public double getWorldExtX() {
        return this.lworldExtX;
    }

    public void setWorldExtX(double wex) {
        this.lworldExtX = wex;
    }

    public double getWorldExtY() {
        return this.lworldExtY;
    }

    public void setWorldExtY(double wey) {
        this.lworldExtY = wey;
    }

    public double getDeviceOrgX() {
        return this.ldeviceOrgX;
    }

    public void setDeviceOrgX(double dox) {
        this.ldeviceOrgX = dox;
    }

    public double getDeviceOrgY() {
        return this.ldeviceOrgY;
    }

    public void setDeviceOrgY(double doy) {
        this.ldeviceOrgY = doy;
    }

    public double getDeviceExtX() {
        return this.ldeviceExtX;
    }

    public void setDeviceExtX(double dex) {
        this.ldeviceExtX = dex;
    }

    public double getDeviceExtY() {
        return this.ldeviceExtY;
    }

    public void setDeviceExtY(double dey) {
        this.ldeviceExtY = dey;
    }

    public double transformX(double x) {
        double worldExtX = this.lworldExtX;
        double xDevice = worldExtX != 0.0 ? this.ldeviceOrgX + (x - this.lworldOrgX) * this.ldeviceExtX / worldExtX : 0.0;
        return xDevice;
    }

    public double transformY(double y) {
        double worldExtY = this.lworldExtY;
        double yDevice = worldExtY != 0.0 ? this.ldeviceOrgY + (y - this.lworldOrgY) * this.ldeviceExtY / worldExtY : 0.0;
        return yDevice;
    }

    public double inverseTransformX(double x) {
        double deviceExtX = this.ldeviceExtX;
        double xWorld = deviceExtX != 0.0 ? this.lworldOrgX + (x - this.ldeviceOrgX) * this.lworldExtX / deviceExtX : 0.0;
        return xWorld;
    }

    public double inverseTransformY(double y) {
        double deviceExtY = this.ldeviceExtY;
        double yWorld = deviceExtY != 0.0 ? this.lworldOrgY + (y - this.ldeviceOrgY) * this.lworldExtY / deviceExtY : 0.0;
        return yWorld;
    }

    public PointD transformPoint(PointD inPoint) {
        PointD outPoint = new PointD(this.transformX(inPoint.x), this.transformY(inPoint.y));
        return outPoint;
    }

    public DimensionD transformDimension(DimensionD inDimension) {
        DimensionD outDimension = new DimensionD(this.transformX(inDimension.width) - this.transformX(0.0), this.transformY(inDimension.height) - this.transformY(0.0));
        return outDimension;
    }

    public RectangleD transformRect(RectangleD inRect) {
        RectangleD outRect = new RectangleD();
        DimensionD inRectDim = new DimensionD(inRect.width, inRect.height);
        DimensionD outRectDim = this.transformDimension(inRectDim);
        outRect.setWidth(outRectDim.width);
        outRect.setHeight(outRectDim.height);
        outRect.setX(this.transformX(inRect.x));
        outRect.setY(this.transformY(inRect.y));
        return outRect;
    }

    public PointD inverseTransformPoint(PointD inPoint) {
        PointD outPoint = new PointD(this.inverseTransformX(inPoint.x), this.inverseTransformY(inPoint.y));
        return outPoint;
    }

    public DimensionD inverseTransformDimension(DimensionD inDimension) {
        DimensionD outDimension = new DimensionD(this.inverseTransformX(inDimension.width - this.inverseTransformX(0.0)), this.inverseTransformY(inDimension.height - this.inverseTransformY(0.0)));
        return outDimension;
    }

    public RectangleD inverseTransformRect(RectangleD inRect) {
        RectangleD outRect = new RectangleD();
        DimensionD inRectDim = new DimensionD(inRect.width, inRect.height);
        DimensionD outRectDim = this.inverseTransformDimension(inRectDim);
        outRect.setWidth(outRectDim.width);
        outRect.setHeight(outRectDim.height);
        outRect.setX(this.inverseTransformX(inRect.x));
        outRect.setY(this.inverseTransformY(inRect.y));
        return outRect;
    }

    public void adjustExtToPreserveAspectRatio() {
        double deviceExtX = this.ldeviceExtX;
        double deviceExtY = this.ldeviceExtY;
        if (deviceExtY != 0.0 && deviceExtX != 0.0) {
            double worldExtX = this.lworldExtX;
            double worldExtY = this.lworldExtY;
            if (deviceExtY * worldExtX < deviceExtX * worldExtY) {
                this.setWorldExtX(deviceExtY > 0.0 ? deviceExtX * worldExtY / deviceExtY : 0.0);
            } else {
                this.setWorldExtY(deviceExtX > 0.0 ? deviceExtY * worldExtX / deviceExtX : 0.0);
            }
        }
    }

    public static void main(String[] args) {
        Transform trans = new Transform();
        trans.setWorldOrgX(0.0);
        trans.setWorldOrgY(0.0);
        trans.setWorldExtX(100.0);
        trans.setWorldExtY(50.0);
        trans.setDeviceOrgX(10.0);
        trans.setDeviceOrgY(20.0);
        trans.setDeviceExtX(50.0);
        trans.setDeviceExtY(-100.0);
        RectangleD rectWorld = new RectangleD();
        rectWorld.x = 12.0;
        rectWorld.y = -25.0;
        rectWorld.width = 150.0;
        rectWorld.height = 150.0;
        PointD pointWorld = new PointD(rectWorld.x, rectWorld.y);
        DimensionD dimWorld = new DimensionD(rectWorld.width, rectWorld.height);
        PointD pointDevice = trans.transformPoint(pointWorld);
        DimensionD dimDevice = trans.transformDimension(dimWorld);
        RectangleD rectDevice = trans.transformRect(rectWorld);
    }
}

