/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.algorithm;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.patika.mada.algorithm.LocalCommonStreamQuery;
import org.patika.mada.algorithm.LocalNeighborhoodQuery;
import org.patika.mada.algorithm.MarkDistances;
import org.patika.mada.algorithm.MarkShortestPlusPaths;
import org.patika.mada.algorithm.PathsBetweenSIF;
import org.patika.mada.algorithm.PathsBetweenSIFWithLinkers;
import org.patika.mada.algorithm.PathsBetweenSIFWithMinimalLinkers;
import org.patika.mada.algorithm.SearchCauses;
import org.patika.mada.algorithm.SearchPathsBetween;
import org.patika.mada.graph.Graph;
import org.patika.mada.graph.GraphObject;
import org.patika.mada.graph.Node;
import org.patika.mada.util.CausativePath;
import org.patika.mada.util.Path;

public class AlgoRunner {
    public static Map<Node, Map<Integer, List<CausativePath>>> searchCausativePaths(Graph graph, Set<? extends Node> targets, int limit, int t, int k) {
        MarkDistances md = new MarkDistances(graph, limit);
        md.run();
        MarkShortestPlusPaths mspp = new MarkShortestPlusPaths(graph, limit, k);
        mspp.run();
        SearchCauses sc = new SearchCauses(graph, targets, limit, t, k);
        return sc.run();
    }

    public static Map<Node, Map<Integer, List<Path>>> searchPathsBetween(Graph graph, Collection<Node> target, int limit) {
        SearchPathsBetween spb = new SearchPathsBetween(graph, target, limit);
        return spb.run();
    }

    public static Collection<GraphObject> searchPathsBetweenSIF(Set<Node> seed, int limit, boolean directed, int k, boolean ignoreLoops) {
        PathsBetweenSIF goi = new PathsBetweenSIF(seed, directed, limit);
        if (k >= 0) {
            goi.setUseShortestPlusK(true);
            goi.setK(k);
        }
        goi.setIgnoreSelfLoops(ignoreLoops);
        return goi.run();
    }

    public static Collection<GraphObject> searchPathsBetweenSIFWithLinkers(Set<Node> seed) {
        PathsBetweenSIFWithLinkers goi = new PathsBetweenSIFWithLinkers(seed);
        return goi.run();
    }

    public static Collection<GraphObject> searchPathsBetweenSIFWithMinimalLinkers(Set<Node> seed) {
        PathsBetweenSIFWithMinimalLinkers goi = new PathsBetweenSIFWithMinimalLinkers(seed);
        return goi.run();
    }

    public static Collection<GraphObject> searchNeighborhood(Set<Node> seed, int limit, boolean upstream, boolean downstream) {
        LocalNeighborhoodQuery nq = new LocalNeighborhoodQuery(seed, upstream, downstream, limit);
        return nq.run();
    }

    public static Collection<GraphObject> searchPathsFromTo(Set<Node> source, Set<Node> target, int limit, boolean directedGraph, int k, boolean ignoreLoops) {
        PathsBetweenSIF goi = new PathsBetweenSIF(source, target, directedGraph, limit);
        if (k >= 0) {
            goi.setUseShortestPlusK(true);
            goi.setK(k);
        }
        goi.setIgnoreSelfLoops(ignoreLoops);
        return goi.run();
    }

    public static Collection<GraphObject> searchCommonStream(Set<Node> source, boolean downstream, int limit, boolean directedGraph) {
        LocalCommonStreamQuery csq = new LocalCommonStreamQuery(source, downstream, limit);
        Set<Node> common = csq.run();
        if (downstream) {
            return AlgoRunner.searchPathsFromTo(source, common, limit, directedGraph, -1, false);
        }
        return AlgoRunner.searchPathsFromTo(common, source, limit, directedGraph, -1, false);
    }
}

