/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.algorithm;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gvt.model.BioPAXGraph;
import org.gvt.model.EntityAssociated;
import org.gvt.util.EntityHolder;
import org.patika.mada.algorithm.BFS;
import org.patika.mada.graph.GraphObject;
import org.patika.mada.graph.Node;

public class LocalPathIterationQuery {
    private BioPAXGraph rootGraph;
    private Set<EntityHolder> allEntities;
    private Map<NodePair, NodePair> shortestPaths;

    public LocalPathIterationQuery(BioPAXGraph rootGraph) {
        this.rootGraph = rootGraph;
        this.allEntities = this.rootGraph.getAllEntities();
        this.shortestPaths = new HashMap<NodePair, NodePair>();
    }

    public Set<NodePair> run() {
        BFS bfs = null;
        for (EntityHolder entity2 : this.allEntities) {
            HashSet<Node> entityNodeStates = new HashSet<Node>();
            Set<Node> entityStates = this.rootGraph.getRelatedStates(entity2);
            for (GraphObject graphObject : entityStates) {
                if (!(graphObject instanceof Node)) continue;
                entityNodeStates.add((Node)graphObject);
            }
            bfs = new BFS(entityNodeStates, null, true, Integer.MAX_VALUE);
            Map<GraphObject, Integer> BFSResult = bfs.run();
            for (GraphObject graphObject : BFSResult.keySet()) {
                if (!(graphObject instanceof Node) || ((Node)graphObject).isComplexMember()) continue;
                Node nodeB = (Node)graphObject;
                int currentShortestDist = BFSResult.get(graphObject);
                if (!nodeB.isBreadthNode()) continue;
                NodePair keyPair = new NodePair(entity2, ((EntityAssociated)nodeB).getEntity(), currentShortestDist);
                if (this.shortestPaths.containsKey(keyPair)) {
                    int previousShortestDist = this.shortestPaths.get(keyPair).getCurrentShortestPath();
                    if (currentShortestDist >= previousShortestDist) continue;
                    this.shortestPaths.get(keyPair).setCurrentShortestPath(currentShortestDist);
                    continue;
                }
                this.shortestPaths.put(keyPair, keyPair);
            }
        }
        Object[] pairArray = new NodePair[this.shortestPaths.size()];
        pairArray = this.shortestPaths.keySet().toArray(pairArray);
        Arrays.sort(pairArray);
        HashSet<NodePair> queryResult = new HashSet<NodePair>();
        for (Object object : pairArray) {
            queryResult.add((NodePair)object);
        }
        return queryResult;
    }

    public class NodePair
    implements Comparable {
        private EntityHolder nodeA;
        private EntityHolder nodeB;
        private Integer currentShortestPath;

        public NodePair(EntityHolder nodeA, EntityHolder nodeB, int currentShortestPath) {
            this.nodeA = nodeA;
            this.nodeB = nodeB;
            this.currentShortestPath = currentShortestPath;
        }

        public EntityHolder getNodeA() {
            return this.nodeA;
        }

        public EntityHolder getNodeB() {
            return this.nodeB;
        }

        public int getCurrentShortestPath() {
            return this.currentShortestPath;
        }

        public void setCurrentShortestPath(int currentShortestPath) {
            this.currentShortestPath = currentShortestPath;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof NodePair)) {
                return false;
            }
            NodePair pair = (NodePair)obj;
            return this.nodeA.equals(pair.getNodeA()) && this.nodeB.equals(pair.getNodeB());
        }

        public int hashCode() {
            int hashA = this.nodeA.hashCode();
            int hashB = this.nodeB.hashCode();
            return hashA + hashB;
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof NodePair)) {
                return 0;
            }
            NodePair pair = (NodePair)obj;
            int result = this.currentShortestPath.compareTo(pair.getCurrentShortestPath());
            if (result == 0) {
                result = this.nodeA.getName().compareTo(pair.getNodeA().getName());
            }
            if (result == 0) {
                result = this.nodeB.getName().compareTo(pair.getNodeB().getName());
            }
            return result;
        }

        public String toString() {
            return this.nodeA.getName() + " -- " + this.currentShortestPath + " -> " + this.nodeB.getName();
        }
    }
}

