/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.algorithm;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.patika.mada.graph.Graph;
import org.patika.mada.graph.Node;

public class MarkShortestPlusPaths {
    private Graph graph;
    private int limit;
    private int k;
    public static final String TO_FROM_PATH_MAP = "TO_FROM_PATH_MAP";

    public MarkShortestPlusPaths(Graph graph, int limit, int k) {
        this.graph = graph;
        this.limit = limit;
        this.k = k;
    }

    public void run() {
        for (Node node : this.graph.getNodes()) {
            Map distFrom = (Map)node.getLabel("DIST_FROM");
            Map distTo = (Map)node.getLabel("DIST_TO");
            if (distFrom == null || distTo == null) continue;
            for (Node from : distFrom.keySet()) {
                assert (from.hasSignificantExperimentalChange("Expression Data"));
                for (Node to : distTo.keySet()) {
                    int s;
                    if (from == node || (s = this.getShortestDistance(from, to)) > this.limit) continue;
                    int d = Math.min(s + this.k, this.limit);
                    int foundDistance = (Integer)distFrom.get(from) + (Integer)distTo.get(to);
                    if (!node.isBreadthNode()) {
                        ++foundDistance;
                    }
                    if (foundDistance > d) continue;
                    Map<Node, Set<Node>> tofromPathMap = this.getToFromPathMap(node);
                    if (!tofromPathMap.containsKey(to)) {
                        tofromPathMap.put(to, new HashSet());
                    }
                    Set<Node> fromSet = tofromPathMap.get(to);
                    fromSet.add(from);
                }
            }
        }
    }

    private int getShortestDistance(Node from, Node to) {
        Map distTo = (Map)from.getLabel("DIST_TO");
        int s = Integer.MAX_VALUE;
        if (distTo.containsKey(to)) {
            s = (Integer)distTo.get(to);
        }
        return s;
    }

    private Map<Node, Set<Node>> getToFromPathMap(Node node) {
        if (!node.hasLabel(TO_FROM_PATH_MAP)) {
            node.putLabel(TO_FROM_PATH_MAP, new HashMap());
        }
        return (Map)node.getLabel(TO_FROM_PATH_MAP);
    }

    public void clearLabels() {
        this.graph.removeLabels(Arrays.asList(TO_FROM_PATH_MAP, "DIST_FROM", "DIST_TO"));
    }
}

