/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.gui;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.table.AbstractTableModel;
import org.eclipse.swt.graphics.Color;
import org.patika.mada.dataXML.Experiment;
import org.patika.mada.dataXML.Reference;
import org.patika.mada.dataXML.Row;
import org.patika.mada.dataXML.ValueTuple;
import org.patika.mada.util.ExperimentDataManager;
import org.patika.mada.util.ExpressionData;
import org.patika.mada.util.XRef;

public class ExperimentValuesTableModel
extends AbstractTableModel {
    private Integer[] expNos;
    private String[] expNames;
    protected List<Integer> firstExpIndices;
    protected List<Integer> secondExpIndices;
    protected int expIndexShift = 1;
    private Row[] displayArray = new Row[0];
    private Map<Row, Integer> rowToIndex;
    private Map<String, String> cache = new HashMap<String, String>();
    private int compareIndex;
    private Color[] columnColors;
    public static final Color gr1Color = new Color(null, 255, 255, 225);
    public static final Color gr2Color = new Color(null, 225, 225, 255);
    public static final Color valueColor = new Color(null, 255, 235, 235);
    public static final Color defaultColor = new Color(null, 255, 255, 255);

    public ExperimentValuesTableModel(ExperimentDataManager man) {
        this.firstExpIndices = new ArrayList<Integer>();
        this.secondExpIndices = new ArrayList<Integer>();
        this.configure(man);
    }

    public void configure(ExperimentDataManager man) {
        ArrayList<Integer> expNos = new ArrayList<Integer>();
        for (Object o : man.getCed().getExperiment()) {
            Experiment e = (Experiment)o;
            int no = e.getNo();
            assert (!expNos.contains(no));
            expNos.add(no);
        }
        this.expNos = expNos.toArray(new Integer[0]);
        this.expNames = new String[this.expNos.length];
        for (int i = 0; i < this.expNos.length; ++i) {
            this.expNames[i] = man.getExperimentName(i);
        }
        this.firstExpIndices = man.getFirstExpIndices();
        this.secondExpIndices = man.getSecondExpIndices();
        this.expIndexShift = this.secondExpIndices.isEmpty() && this.firstExpIndices.size() == 1 ? 1 : 2;
    }

    @Override
    public int getRowCount() {
        return this.displayArray.length;
    }

    @Override
    public int getColumnCount() {
        return this.expNos.length + this.expIndexShift;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String key = rowIndex + ":" + columnIndex;
        String value = this.cache.get(key);
        if (value == null) {
            Row row = this.displayArray[rowIndex];
            switch (columnIndex) {
                case 0: {
                    value = this.getRefs(row);
                    break;
                }
                case 1: {
                    if (this.expIndexShift == 2) {
                        if (this.secondExpIndices.isEmpty()) {
                            Double v = this.getMean(rowIndex, this.firstExpIndices);
                            value = v == null ? "" : "" + v;
                            break;
                        }
                        Double v = this.getRatio(rowIndex);
                        value = v == null ? "" : "" + v;
                        break;
                    }
                }
                default: {
                    value = this.getValue(row, columnIndex - this.expIndexShift);
                }
            }
            this.cache.put(key, value);
        }
        return value;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "References";
        }
        if (column == 1 && this.expIndexShift == 2) {
            return this.secondExpIndices.isEmpty() ? "Avg value" : "Log Ratio";
        }
        return this.expNames[column - this.expIndexShift];
    }

    public String[] getColumnNames() {
        String[] names = new String[this.getColumnCount()];
        for (int i = 0; i < this.getColumnCount(); ++i) {
            names[i] = this.getColumnName(i);
        }
        return names;
    }

    public Row[] getDisplayArray() {
        return this.displayArray;
    }

    private String getRefs(Row row) {
        String refs = "";
        for (Object o : row.getRef()) {
            Reference ref = (Reference)o;
            refs = refs + ref.getDb() + ":" + ref.getValue() + " ";
        }
        return refs;
    }

    private String getValue(Row row, int expIndex) {
        assert (expIndex < this.expNos.length) : "Experiment index out of bounds: " + expIndex;
        for (Object o : row.getValue()) {
            ValueTuple val = (ValueTuple)o;
            if (val.getNo() != this.expNos[expIndex].intValue()) continue;
            return new DecimalFormat("#.####").format(val.getValue());
        }
        return "";
    }

    private Double getMean(int rowIndex, List<Integer> exps) {
        ArrayList<Double> v = new ArrayList<Double>();
        for (int i : exps) {
            String s = (String)this.getValueAt(rowIndex, i + this.expIndexShift);
            if (s.length() <= 0) continue;
            v.add(new Double(s));
        }
        if (v.isEmpty()) {
            return null;
        }
        return Double.parseDouble(new DecimalFormat("#.####").format(this.mean(v)));
    }

    private Double getRatio(int rowIndex) {
        String s;
        assert (!this.firstExpIndices.isEmpty());
        assert (!this.secondExpIndices.isEmpty());
        ArrayList<Double> v1 = new ArrayList<Double>();
        ArrayList<Double> v2 = new ArrayList<Double>();
        for (int i : this.firstExpIndices) {
            s = (String)this.getValueAt(rowIndex, i + this.expIndexShift);
            if (s.length() <= 0) continue;
            v1.add(new Double(s));
        }
        for (int i : this.secondExpIndices) {
            s = (String)this.getValueAt(rowIndex, i + this.expIndexShift);
            if (s.length() <= 0) continue;
            v2.add(new Double(s));
        }
        if (!v1.isEmpty() && !v2.isEmpty()) {
            ExpressionData info = new ExpressionData(this.mean(v1), this.mean(v2));
            return Double.parseDouble(new DecimalFormat("#.####").format(info.getValue()));
        }
        return null;
    }

    private double mean(Collection<Double> col) {
        double sum = 0.0;
        for (double d : col) {
            sum += d;
        }
        return sum / (double)col.size();
    }

    public List<XRef> getSelectedReferences(int[] rowIndex) {
        ArrayList<XRef> refs = new ArrayList<XRef>();
        for (int r : rowIndex) {
            String s = (String)this.getValueAt(r, 0);
            StringTokenizer st = new StringTokenizer(s);
            while (st.hasMoreTokens()) {
                refs.add(new XRef(st.nextToken()));
            }
        }
        return refs;
    }

    public void updateRows(List<Row> displayList) {
        this.displayArray = displayList.toArray(new Row[displayList.size()]);
        this.cache.clear();
        if (this.rowToIndex == null) {
            this.rowToIndex = new HashMap<Row, Integer>();
        }
        this.rowToIndex.clear();
        int i = 0;
        for (Row row : this.displayArray) {
            this.rowToIndex.put(row, i++);
        }
    }

    public int getRowIndex(Row row) {
        return this.rowToIndex.get(row);
    }

    public Color getColumnColor(int col) {
        if (this.columnColors == null) {
            this.columnColors = new Color[this.getColumnCount()];
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (i >= this.expIndexShift) {
                    if (this.firstExpIndices.contains(i - this.expIndexShift)) {
                        this.columnColors[i] = gr1Color;
                        continue;
                    }
                    if (this.secondExpIndices.contains(i - this.expIndexShift)) {
                        this.columnColors[i] = gr2Color;
                        continue;
                    }
                    this.columnColors[i] = defaultColor;
                    continue;
                }
                this.columnColors[i] = i == 1 && this.expIndexShift == 2 ? valueColor : defaultColor;
            }
        }
        return this.columnColors[col];
    }

    public void sort(int index) {
        this.compareIndex = index;
        TreeSet<ComparableRow> set = new TreeSet<ComparableRow>();
        for (int i = 0; i < this.displayArray.length; ++i) {
            set.add(new ComparableRow(this.displayArray[i], i));
        }
        ArrayList<Row> sorted = new ArrayList<Row>();
        for (ComparableRow cr : set) {
            sorted.add(cr.row);
        }
        this.updateRows(sorted);
    }

    public int getValueIndex() {
        if (this.expIndexShift == 2) {
            return 1;
        }
        return this.firstExpIndices.get(0) + this.expIndexShift;
    }

    class ComparableRow
    implements Comparable {
        Row row;
        int rowIndex;

        public ComparableRow(Row row, int rowIndex) {
            this.row = row;
            this.rowIndex = rowIndex;
        }

        public int compareTo(Object o) {
            int c;
            assert (o instanceof ComparableRow) : "Cannot compare with another object!";
            ComparableRow cr = (ComparableRow)o;
            String s1 = (String)ExperimentValuesTableModel.this.getValueAt(this.rowIndex, ExperimentValuesTableModel.this.compareIndex);
            String s2 = (String)ExperimentValuesTableModel.this.getValueAt(cr.rowIndex, ExperimentValuesTableModel.this.compareIndex);
            if (ExperimentValuesTableModel.this.compareIndex == 0) {
                c = s1.compareTo(s2);
            } else {
                Double d1 = s1.length() == 0 ? 0.0 : new Double(s1);
                Double d2 = s2.length() == 0 ? 0.0 : new Double(s2);
                c = d1.compareTo(d2);
            }
            if (c == 0) {
                c = new Integer(this.rowIndex).compareTo(cr.rowIndex);
            }
            return c;
        }
    }
}

