/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.patika.mada.gui.ExperimentDataConvertionWizard;
import org.patika.mada.gui.KeyValueSpecificationPage;
import org.patika.mada.gui.NonePlatformMappingPage;
import org.patika.mada.gui.PatikaWizardPage;

public class SingleDataFileLoadPage
extends PatikaWizardPage
implements ActionListener {
    ExperimentDataConvertionWizard mdcw;
    File dataFile;
    private TitledBorder mainTitledBorder;
    private JPanel filePanel;
    private JLabel filePanelLabel;
    private JTextField fileNameArea;
    private JButton browseButton;

    public SingleDataFileLoadPage(ExperimentDataConvertionWizard mdcw) {
        super(mdcw);
        this.mdcw = mdcw;
        this.setSize(new Dimension(489, 260));
        this.setLayout(new FlowLayout());
        this.mainTitledBorder = new TitledBorder(BorderFactory.createEtchedBorder(new Color(52, 52, 52), new Color(25, 25, 25)), " Single data file loading ");
        this.setBorder(this.mainTitledBorder);
        this.filePanel = new JPanel();
        this.filePanel.setPreferredSize(new Dimension(470, 55));
        this.filePanel.setLayout(new GridLayout(1, 1));
        this.filePanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(new Color(52, 52, 52), new Color(25, 25, 25)), " Load a tab-limited data file "));
        this.filePanelLabel = new JLabel("Loaded data file: ");
        this.fileNameArea = new JTextField("                         ");
        this.fileNameArea.setMaximumSize(new Dimension(30, 26));
        this.fileNameArea.setEditable(false);
        this.browseButton = new JButton(" Browse ");
        this.browseButton.addActionListener(this);
        this.filePanel.setLayout(new GridLayout(1, 3, 5, 10));
        this.filePanel.add(this.filePanelLabel);
        this.filePanel.add(this.fileNameArea);
        this.filePanel.add(this.browseButton);
        this.add(this.filePanel);
    }

    @Override
    void reset() {
    }

    @Override
    void update() {
    }

    @Override
    public boolean canNext() {
        if (this.dataFile == null) {
            return false;
        }
        if (this.dataFile.exists()) {
            if (this.getColumns().size() == 0) {
                JOptionPane.showMessageDialog(this.mdcw, "Could not recognize file format, data must be tab delimitted! ", null, 0);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canFinish() {
        return this.dataFile != null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int returnVal;
        JFileChooser chooser = new JFileChooser();
        if (ExperimentDataConvertionWizard.recentDir != null) {
            chooser.setCurrentDirectory(ExperimentDataConvertionWizard.recentDir);
        }
        if ((returnVal = chooser.showOpenDialog(this.mdcw)) == 0) {
            this.dataFile = chooser.getSelectedFile();
            ExperimentDataConvertionWizard.recentDir = this.dataFile.getParentFile();
            if (!this.dataFile.exists()) {
                JOptionPane.showMessageDialog(this.mdcw, this.dataFile.getName() + " does not exists! ", null, 0);
            } else if (!this.isFileValid(this.dataFile)) {
                JOptionPane.showMessageDialog(this.mdcw, this.dataFile.getName() + " is not " + "recognized by ChiBE because " + "\n it contains non-ASCII characters.", "Illegal Data File", 0);
            } else {
                this.fileNameArea.setText(this.dataFile.getName());
                this.mdcw.checkButtons();
                if (this.mdcw.hasPlatformFile()) {
                    ((KeyValueSpecificationPage)this.mdcw.pages[3]).init();
                } else {
                    ((NonePlatformMappingPage)this.mdcw.pages[2]).init();
                }
            }
        }
    }

    public Vector getColumns() {
        Vector<String> columns = new Vector<String>();
        String line = "";
        try {
            FileReader fr = new FileReader(this.dataFile);
            BufferedReader br = new BufferedReader(fr);
            while ((line = br.readLine()) != null && ExperimentDataConvertionWizard.startsWithSpecialChar(line)) {
            }
            if (line != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, "\t");
                while (tokenizer.hasMoreTokens()) {
                    columns.add(tokenizer.nextToken());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return columns;
    }

    public File getLoadedFile() {
        return this.dataFile;
    }

    private boolean isFileValid(File f) {
        BufferedReader br;
        String line = "";
        try {
            FileReader fr = new FileReader(f);
            br = new BufferedReader(fr);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        do {
            try {
                line = br.readLine();
                if (line != null && (line.startsWith("!") || line.startsWith("#") || line.startsWith("^"))) continue;
                for (int i = 0; line != null && i < line.length(); ++i) {
                    if (line.charAt(i) <= '\u007f') continue;
                    System.out.println("line = " + line);
                    System.out.println("line.charAt(" + i + ") = " + line.charAt(i) + " -- " + line.charAt(i));
                    return false;
                }
            }
            catch (IOException e) {
                return false;
            }
        } while (line != null);
        return true;
    }
}

