/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.util;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.gvt.util.Conf;
import org.patika.mada.util.ExperimentData;
import org.patika.mada.util.SignificanceFilter;

public class AlterationData
extends ExperimentData {
    private static SignificanceFilter sigFilt;

    public AlterationData(double value) {
        super(value);
    }

    public AlterationData(double v1, double v2) {
        super(v1, v2);
    }

    @Override
    public double getMaxValue() {
        return VALUES.ALTERED.toDouble();
    }

    @Override
    public double getMinValue() {
        return VALUES.NOT_ALTERED.toDouble();
    }

    @Override
    protected SignificanceFilter getSignificanceFilter() {
        return sigFilt;
    }

    public static void setSignificanceFilter(SignificanceFilter sigFilt) {
        AlterationData.sigFilt = sigFilt;
    }

    @Override
    public Object getKey() {
        return "Alteration Data";
    }

    @Override
    public Color getNodeColor() {
        return AlterationData.getNodeColor(this.getValue());
    }

    public static Color getNodeColor(double value) {
        double C2 = 100.0;
        value = value * C2 + 1.0;
        Color alt = Conf.getColor("EXPERIMENT_UP_COLOR");
        Color nonalt = Conf.getColor("EXPERIMENT_MIDDLE_COLOR");
        float redDiff = alt.getRed() - nonalt.getRed();
        float greenDiff = alt.getGreen() - nonalt.getGreen();
        float blueDiff = alt.getBlue() - nonalt.getBlue();
        redDiff = (float)((double)redDiff * (Math.log(value) / Math.log(C2)));
        greenDiff = (float)((double)greenDiff * (Math.log(value) / Math.log(C2)));
        blueDiff = (float)((double)blueDiff * (Math.log(value) / Math.log(C2)));
        RGB rgb = new RGB(nonalt.getRed() + (int)redDiff, nonalt.getGreen() + (int)greenDiff, nonalt.getBlue() + (int)blueDiff);
        return new Color(alt.getDevice(), rgb);
    }

    public static enum VALUES {
        ALTERED(1.0),
        NOT_ALTERED(0.0);

        private Double numericalValue;

        private VALUES(Double numericalValue) {
            this.numericalValue = numericalValue;
        }

        public Double toDouble() {
            return this.numericalValue;
        }
    }
}

