/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.util;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.gvt.util.Conf;
import org.patika.mada.util.Representable;
import org.patika.mada.util.SignificanceFilter;

public abstract class ExperimentData
implements Representable {
    private double value1;
    private double value2;
    private boolean type;
    private int presInExp1;
    private int presInExp2;
    static final DecimalFormat fmt = new DecimalFormat("0.##");
    public static final int UPREGULATION = 1;
    public static final int DOWNREGULATION = -1;
    public static final boolean SINGLE = false;
    public static final boolean DOUBLE = true;
    public static final double LOG2 = Math.log(2.0);
    public static final String EXPRESSION_DATA = "Expression Data";
    public static final String MASS_SPEC_DATA = "Mass Spectrometry Data";
    public static final String COPY_NUMBER_VARIATION = "Copy Number Variation Data";
    public static final String MUTATION_DATA = "Mutation Data";
    public static final String ALTERATION_DATA = "Alteration Data";
    public static final String CBIOPORTAL_ALTERATION_DATA = "cBio Portal Alteration Data";
    public static final int PRESENT = 1;
    public static final int ABSENT = -1;
    public static final int UNKNOWN = 0;
    private static final Color highC = Conf.getColor("EXPERIMENT_UP_COLOR");
    private static final Color midC = Conf.getColor("EXPERIMENT_MIDDLE_COLOR");
    private static final Color lowC = Conf.getColor("EXPERIMENT_DOWN_COLOR");
    public static final double high = Conf.getNumber("EXPERIMENT_MAX_UPREGULATION");
    public static final double mid_h = Conf.getNumber("EXPERIMENT_NO_CHANGE_UPPER_BOUND");
    public static final double mid_l = Conf.getNumber("EXPERIMENT_NO_CHANGE_LOWER_BOUND");
    public static final double low = Conf.getNumber("EXPERIMENT_MAX_DOWNREGULATION");
    private static final Color DEFAULT_TEXT_COLOR = new Color(null, 0, 0, 0);

    public ExperimentData(double value) {
        this.value1 = value;
        this.presInExp1 = 0;
        this.type = false;
    }

    public ExperimentData(double value1, double value2) {
        this.value1 = value1;
        this.value2 = value2;
        this.presInExp1 = 0;
        this.presInExp2 = 0;
        this.type = true;
    }

    public abstract double getMaxValue();

    public abstract double getMinValue();

    protected abstract SignificanceFilter getSignificanceFilter();

    public double getValue() {
        if (this.isSingle()) {
            return this.getValue1();
        }
        if (this.getMinValue() < 0.0) {
            if (this.getValue1() > this.getValue2()) {
                return -(this.getValue1() - this.getMinValue()) / (this.getValue2() - this.getMinValue());
            }
            return (this.getValue2() - this.getMinValue()) / (this.getValue1() - this.getMinValue());
        }
        if (this.getValue1() > this.getValue2()) {
            return -(this.getValue1() / this.getValue2());
        }
        return this.getValue2() / this.getValue1();
    }

    public double getValue1() {
        return this.value1;
    }

    public void setValue1(double value1) {
        this.value1 = value1;
    }

    public double getValue2() {
        return this.value2;
    }

    public void setValue2(double value2) {
        this.value2 = value2;
    }

    public boolean isSingle() {
        return !this.type;
    }

    public boolean isDouble() {
        return this.type;
    }

    public void setType(boolean type) {
        this.type = type;
    }

    public boolean isSignificant() {
        return this.getSignificanceFilter().isSignificant(this);
    }

    public boolean isUpRegulated() {
        return this.value2 - this.value1 > 0.0;
    }

    public boolean isDownRegulated() {
        return this.value2 - this.value1 < 0.0;
    }

    public int getSign() {
        return this.isUpRegulated() ? 1 : -1;
    }

    @Override
    public boolean alterNodeColor() {
        return true;
    }

    @Override
    public boolean alterToolTipText() {
        return true;
    }

    @Override
    public boolean alterTextColor() {
        return true;
    }

    @Override
    public Color getNodeColor() {
        return ExperimentData.getNodeColor(this.getValue());
    }

    public static Color getNodeColor(double v) {
        if (v >= high) {
            return highC;
        }
        if (v > mid_h) {
            return new Color(null, ExperimentData.getValueByRatio(v, mid_h, high, midC.getRed(), highC.getRed()), ExperimentData.getValueByRatio(v, mid_h, high, midC.getGreen(), highC.getGreen()), ExperimentData.getValueByRatio(v, mid_h, high, midC.getBlue(), highC.getBlue()));
        }
        if (v <= mid_h && v >= mid_l) {
            return midC;
        }
        if (v < mid_l && v > low) {
            return new Color(null, ExperimentData.getValueByRatio(v, low, mid_l, lowC.getRed(), midC.getRed()), ExperimentData.getValueByRatio(v, low, mid_l, lowC.getGreen(), midC.getGreen()), ExperimentData.getValueByRatio(v, low, mid_l, lowC.getBlue(), midC.getBlue()));
        }
        return lowC;
    }

    private static int getValueByRatio(double num, double numLow, double numHigh, int colorNum1, int colorNum2) {
        return (int)((num - numLow) / (numHigh - numLow) * (double)(colorNum2 - colorNum1) + (double)colorNum1);
    }

    @Override
    public String getToolTipText() {
        return fmt.format(this.getValue());
    }

    @Override
    public Color getTextColor() {
        return DEFAULT_TEXT_COLOR;
    }

    public abstract Object getKey();

    public static List<String> getDataTypes() {
        return Arrays.asList(EXPRESSION_DATA, MASS_SPEC_DATA, COPY_NUMBER_VARIATION, MUTATION_DATA, ALTERATION_DATA, CBIOPORTAL_ALTERATION_DATA);
    }
}

