/*
 * Decompiled with CFR 0.152.
 */
package cpath.query;

import cpath.client.CPathClient;
import cpath.client.util.CPathException;
import cpath.query.BaseCPathQuery;
import cpath.query.CPathQuery;
import cpath.service.Cmd;
import cpath.service.CmdArgs;
import cpath.service.GraphType;
import cpath.service.OutputFormat;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.ArrayUtils;
import org.biopax.paxtools.controller.ModelUtils;
import org.biopax.paxtools.model.Model;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public final class CPathGraphQuery
extends BaseCPathQuery<Model>
implements CPathQuery<Model> {
    private boolean mergeEquivalentInteractions = false;
    private Integer limit = 1;
    private CPathClient.Direction direction;
    private GraphType graphType = GraphType.NEIGHBORHOOD;
    private String[] source;
    private String[] target;
    private String[] organism;
    private String[] datasource;

    @Override
    protected MultiValueMap<String, String> getRequestParams() {
        LinkedMultiValueMap<String, String> request = new LinkedMultiValueMap<String, String>();
        request.add(CmdArgs.kind.name(), this.graphType.name());
        request.add(CmdArgs.limit.name(), this.limit.toString());
        if (this.source == null || this.source.length == 0) {
            throw new IllegalArgumentException("Required 'source' parameter (cannot be null or empty)");
        }
        request.put(CmdArgs.source.name(), (String)((Object)Arrays.asList(this.source)));
        if (this.organism != null) {
            request.put(CmdArgs.organism.name(), (String)((Object)Arrays.asList(this.organism)));
        }
        if (this.datasource != null) {
            request.put(CmdArgs.datasource.name(), (String)((Object)Arrays.asList(this.datasource)));
        }
        switch (this.graphType) {
            case COMMONSTREAM: {
                if (this.direction == null) break;
                if (this.direction == CPathClient.Direction.BOTHSTREAM) {
                    throw new IllegalArgumentException("Direction of common-stream query should be either upstream or downstream.");
                }
                request.add(CmdArgs.direction.name(), this.direction.name());
                break;
            }
            case PATHSBETWEEN: {
                break;
            }
            case PATHSFROMTO: {
                request.put(CmdArgs.target.name(), (String)((Object)Arrays.asList(this.target)));
                break;
            }
            default: {
                if (this.direction == null) break;
                request.add(CmdArgs.direction.name(), this.direction.name());
            }
        }
        return request;
    }

    public CPathGraphQuery(CPathClient client) {
        this.client = client;
        this.graphType = GraphType.NEIGHBORHOOD;
    }

    public CPathGraphQuery kind(GraphType graphType) {
        this.graphType = graphType;
        return this;
    }

    public CPathGraphQuery sources(String[] sources) {
        this.source = sources;
        return this;
    }

    public CPathGraphQuery targets(String[] targets) {
        this.target = targets;
        return this;
    }

    public CPathGraphQuery sources(Collection<String> sources) {
        this.source = sources.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        return this;
    }

    public CPathGraphQuery targets(Collection<String> targets) {
        this.target = targets.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        return this;
    }

    public CPathGraphQuery limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public CPathGraphQuery direction(CPathClient.Direction direction) {
        this.direction = direction;
        return this;
    }

    public CPathGraphQuery organismFilter(String[] organisms) {
        this.organism = organisms;
        return this;
    }

    public CPathGraphQuery datasourceFilter(String[] datasources) {
        this.datasource = datasources;
        return this;
    }

    public CPathGraphQuery organismFilter(Collection<String> organisms) {
        this.organism = organisms.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        return this;
    }

    public CPathGraphQuery datasourceFilter(Collection<String> datasources) {
        this.datasource = datasources.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        return this;
    }

    public void mergeEquivalentInteractions(boolean mergeEquivalentInteractions) {
        this.mergeEquivalentInteractions = mergeEquivalentInteractions;
    }

    @Override
    public String stringResult(OutputFormat format) throws CPathException {
        MultiValueMap<String, String> request = this.getRequestParams();
        if (format == null) {
            format = OutputFormat.BIOPAX;
        }
        request.add(CmdArgs.format.name(), format.name());
        return this.client.post(Cmd.GRAPH.toString(), request, String.class);
    }

    @Override
    public Model result() throws CPathException {
        Model model = this.client.post(Cmd.GRAPH.toString(), this.getRequestParams(), Model.class);
        if (this.mergeEquivalentInteractions && model != null) {
            ModelUtils.mergeEquivalentInteractions(model);
        }
        return model;
    }
}

