/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.command;

import java.util.Set;
import java.util.Stack;
import org.biopax.paxtools.command.AddCommand;
import org.biopax.paxtools.command.Command;
import org.biopax.paxtools.command.PropertyAddCommand;
import org.biopax.paxtools.command.PropertyRemoveCommand;
import org.biopax.paxtools.command.PropertySetCommand;
import org.biopax.paxtools.command.RemoveCommand;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;

public class CommandManager {
    private Stack<Command> undoStack = new Stack();
    private Stack<Command> redoStack = new Stack();
    private Model model;

    public CommandManager(Model model) {
        this.model = model;
    }

    public void addProperty(BioPAXElement bpe, PropertyEditor editor, Object value) {
        this.recordAndRun(editor.isMultipleCardinality() ? new PropertyAddCommand(bpe, editor, value) : new PropertySetCommand<BioPAXElement, Object>(bpe, editor, value));
    }

    public void removeProperty(BioPAXElement bpe, PropertyEditor editor, Object value) {
        this.recordAndRun(new PropertyRemoveCommand(bpe, editor, value));
    }

    public void addObjects(Set<BioPAXElement> bpes) {
        this.recordAndRun(new AddCommand(this.model, bpes));
    }

    public void removeObjects(Set<BioPAXElement> bpes) {
        this.recordAndRun(new RemoveCommand(this.model, bpes));
    }

    private void recordAndRun(Command command) {
        command.redo();
        this.undoStack.add(command);
        if (!this.redoStack.isEmpty()) {
            this.redoStack.clear();
        }
    }

    public void undo() {
        Command command = this.undoStack.pop();
        command.undo();
        this.redoStack.add(command);
    }

    public void redo() {
        Command command = this.redoStack.pop();
        command.redo();
        this.undoStack.add(command);
    }

    public boolean canUndo() {
        return !this.undoStack.isEmpty();
    }

    public boolean canRedo() {
        return !this.redoStack.isEmpty();
    }
}

